/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.databinding;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.databinding.ChangeEvent;
import org.eclipse.jface.databinding.IChangeListener;

public interface ITree {
    public Object[] getChildren(Object var1);

    public boolean hasChildren(Object var1);

    public void addTreeChangeListener(IChangeListener var1);

    public void removeTreeChangeListener(IChangeListener var1);

    public void dispose();

    public void setChildren(Object var1, Object[] var2);

    public static class ChangeSupport {
        private ITree source;
        private List listeners = null;

        public ChangeSupport(ITree source) {
            this.source = source;
        }

        public void addTreeChangeListener(IChangeListener listener) {
            if (listener != null) {
                if (this.listeners == null) {
                    this.listeners = new ArrayList();
                }
                this.listeners.add(listener);
            }
        }

        public void removeTreeChangeListener(IChangeListener listener) {
            if (listener == null || this.listeners == null) {
                return;
            }
            this.listeners.remove(listener);
        }

        public void fireTreeChange(int changeType, Object oldValue, Object newValue, Object parent, int index) {
            ChangeEvent evt = new ChangeEvent(this.source, changeType, oldValue, newValue, parent, index);
            this.fireTreeChange(evt);
        }

        public void fireTreeChange(ChangeEvent evt) {
            Object oval = evt.getOldValue();
            Object nval = evt.getNewValue();
            if (this.listeners == null || oval != null && nval != null && oval.equals(nval)) {
                return;
            }
            IChangeListener[] list = this.listeners.toArray(new IChangeListener[this.listeners.size()]);
            int i = 0;
            while (i < list.length) {
                list[i].handleChange(evt);
                ++i;
            }
        }
    }
}

