/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.databinding.swt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jface.databinding.ChangeEvent;
import org.eclipse.jface.databinding.IChangeListener;
import org.eclipse.jface.databinding.IReadable;
import org.eclipse.jface.databinding.UpdatableTracker;
import org.eclipse.jface.internal.databinding.swt.SWTUtil;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.widgets.Control;

public abstract class ControlUpdator {
    private Runnable updateRunnable = new Runnable(){

        public void run() {
            ControlUpdator.this.updateControl();
        }
    };
    private PrivateInterface privateInterface = new PrivateInterface();
    private Control theControl;
    private Collection dependencies = new ArrayList();
    private boolean dirty = false;

    public ControlUpdator(Control toUpdate) {
        this.theControl = toUpdate;
        this.theControl.addDisposeListener((DisposeListener)this.privateInterface);
        this.theControl.addPaintListener((PaintListener)this.privateInterface);
        this.makeDirty();
    }

    private void updateIfNecessary() {
        if (this.dirty) {
            Set newDependencies = UpdatableTracker.runAndMonitor(this.updateRunnable);
            Iterator iter = newDependencies.iterator();
            while (iter.hasNext()) {
                IReadable next = (IReadable)iter.next();
                next.addChangeListener(this.privateInterface);
            }
            this.dependencies = newDependencies;
            this.dirty = false;
        }
    }

    public void dispose() {
        this.theControl.removeDisposeListener((DisposeListener)this.privateInterface);
        this.theControl.removePaintListener((PaintListener)this.privateInterface);
        this.stopListening();
    }

    private void stopListening() {
        IReadable[] updatables = this.dependencies.toArray(new IReadable[this.dependencies.size()]);
        this.dependencies.clear();
        int i = 0;
        while (i < updatables.length) {
            IReadable readable = updatables[i];
            readable.removeChangeListener(this.privateInterface);
            ++i;
        }
    }

    protected abstract void updateControl();

    protected final void makeDirty() {
        if (!this.dirty) {
            this.dirty = true;
            this.stopListening();
            SWTUtil.runOnce(this.theControl.getDisplay(), this.privateInterface);
        }
    }

    private class PrivateInterface
    implements PaintListener,
    DisposeListener,
    Runnable,
    IChangeListener {
        PrivateInterface() {
        }

        public void paintControl(PaintEvent e) {
            ControlUpdator.this.updateIfNecessary();
        }

        public void widgetDisposed(DisposeEvent e) {
            ControlUpdator.this.dispose();
        }

        public void run() {
            if (ControlUpdator.this.theControl != null && !ControlUpdator.this.theControl.isDisposed() && ControlUpdator.this.theControl.isVisible()) {
                ControlUpdator.this.updateIfNecessary();
            }
        }

        public void handleChange(ChangeEvent changeEvent) {
            if (changeEvent.getChangeType() != 8) {
                ControlUpdator.this.makeDirty();
            }
        }
    }
}

