/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.databinding.updatables;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.jface.databinding.AbstractUpdatableSet;
import org.eclipse.jface.databinding.ChangeEvent;
import org.eclipse.jface.databinding.IChangeListener;
import org.eclipse.jface.databinding.IReadableSet;
import org.eclipse.jface.databinding.IUpdatableFunction;
import org.eclipse.jface.databinding.updatables.IdentityFunction;
import org.eclipse.jface.databinding.updatables.InverseMapping;
import org.eclipse.jface.util.Assert;

public class ConvertingSet
extends AbstractUpdatableSet {
    private IReadableSet input;
    private IChangeListener inputListener = new IChangeListener(){

        public void handleChange(ChangeEvent changeEvent) {
            Object source = changeEvent.getSource();
            switch (changeEvent.getChangeType()) {
                case 256: {
                    if (source != ConvertingSet.this.input) break;
                    ConvertingSet.this.processAdds((Collection)changeEvent.getNewValue());
                    break;
                }
                case 512: {
                    if (source != ConvertingSet.this.input) break;
                    ConvertingSet.this.processRemoves((Collection)changeEvent.getNewValue());
                    break;
                }
                case 1024: {
                    if (source != ConvertingSet.this.func) break;
                    ConvertingSet.this.processChanges((Collection)changeEvent.getNewValue());
                    break;
                }
                case 64: {
                    boolean noneStale;
                    boolean funcStale = ConvertingSet.this.func.isStale();
                    boolean inputStale = ConvertingSet.this.input.isStale();
                    boolean bothStale = funcStale && inputStale;
                    boolean bl = noneStale = !funcStale && !inputStale;
                    if (noneStale) {
                        ConvertingSet.this.fireStale(false);
                        break;
                    }
                    if (bothStale) break;
                    ConvertingSet.this.fireStale(true);
                }
            }
        }
    };
    private InverseMapping converter = null;
    private IUpdatableFunction func;

    public ConvertingSet(IReadableSet input, IUpdatableFunction f) {
        this.input = input;
        this.func = f;
    }

    public boolean isStale() {
        return this.func.isStale() || this.input.isStale();
    }

    private void processAdds(Collection added) {
        if (this.func == IdentityFunction.getInstance()) {
            this.fireAdded(added);
            return;
        }
        ArrayList adds = this.addMappings(added);
        this.fireAdded(adds);
    }

    private ArrayList addMappings(Collection added) {
        ArrayList<Object> adds = new ArrayList<Object>();
        Iterator iter = added.iterator();
        while (iter.hasNext()) {
            Collection keys;
            Object next = iter.next();
            Object target = this.func.calculate(next);
            if (target == null || (keys = this.converter.addMapping(next, target)).size() != 1) continue;
            adds.add(target);
        }
        return adds;
    }

    private void processRemoves(Collection removed) {
        if (this.converter == null) {
            this.fireRemoved(removed);
            return;
        }
        ArrayList<Object> removes = new ArrayList<Object>();
        Iterator iter = removed.iterator();
        while (iter.hasNext()) {
            Collection keys;
            Object next = iter.next();
            Object target = this.converter.getValue(next);
            if (target == null || !(keys = this.converter.removeMapping(next)).isEmpty()) continue;
            removes.add(target);
        }
        this.fireRemoved(removes);
    }

    protected void processChanges(Collection collection) {
        Assert.isNotNull((Object)this.converter, (String)"The identity function should never fire a change event");
        this.processRemoves(collection);
        this.processAdds(collection);
    }

    public Object getAdapter(Object element) {
        if (this.func == IdentityFunction.getInstance()) {
            return element;
        }
        if (this.converter != null) {
            return this.converter.getValue(element);
        }
        return this.func.calculate(element);
    }

    public Collection getElements(Object adapter) {
        if (this.func == IdentityFunction.getInstance()) {
            return Collections.singleton(adapter);
        }
        if (this.converter != null) {
            this.converter.getInverse(adapter);
        }
        HashSet result = new HashSet();
        Collection rawInput = this.input.toCollection();
        Iterator iter = rawInput.iterator();
        while (iter.hasNext()) {
            Object next = iter.next();
            Object converted = this.func.calculate(next);
            if (converted == null || converted != adapter) continue;
            result.add(next);
        }
        return result;
    }

    protected Collection computeElements() {
        if (this.func == IdentityFunction.getInstance()) {
            return this.input.toCollection();
        }
        if (this.converter != null) {
            return this.converter.getValues();
        }
        HashSet<Object> result = new HashSet<Object>();
        Collection rawInput = this.input.toCollection();
        Iterator iter = rawInput.iterator();
        while (iter.hasNext()) {
            Object next = iter.next();
            Object converted = this.func.calculate(next);
            if (converted == null) continue;
            result.add(converted);
        }
        return result;
    }

    protected void firstListenerAdded() {
        this.func.addChangeListener(this.inputListener);
        this.input.addChangeListener(this.inputListener);
        this.converter = new InverseMapping();
        this.addMappings(this.input.toCollection());
        super.firstListenerAdded();
    }

    protected void lastListenerRemoved() {
        this.func.removeChangeListener(this.inputListener);
        this.func.removeChangeListener(this.inputListener);
        if (this.converter != null) {
            this.converter.dispose();
            this.converter = null;
        }
        super.lastListenerRemoved();
    }
}

