/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.databinding.updatables;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

final class InverseMapping {
    private Map elementsToAdapters = new HashMap();
    private Map adaptersToElementCollection = new HashMap();

    public boolean hasMapping(Object e) {
        return this.elementsToAdapters.containsKey(e);
    }

    public Object getValue(Object key) {
        return this.elementsToAdapters.get(key);
    }

    public Collection addMapping(Object key, Object value) {
        this.elementsToAdapters.put(key, value);
        HashSet<Object> existingInverse = (HashSet<Object>)this.adaptersToElementCollection.get(value);
        if (existingInverse == null) {
            existingInverse = new HashSet<Object>();
            this.adaptersToElementCollection.put(value, existingInverse);
        }
        existingInverse.add(key);
        return existingInverse;
    }

    public Collection getValues() {
        return this.adaptersToElementCollection.keySet();
    }

    public Collection getInverse(Object value) {
        Collection result = (Collection)this.adaptersToElementCollection.get(value);
        if (result == null) {
            return Collections.EMPTY_SET;
        }
        return result;
    }

    public Collection removeMapping(Object element) {
        Collection elements;
        Object adapter = this.elementsToAdapters.remove(element);
        if (adapter != null && (elements = (Collection)this.adaptersToElementCollection.get(adapter)) != null) {
            elements.remove(element);
            if (elements.isEmpty()) {
                this.adaptersToElementCollection.remove(adapter);
            }
            return elements;
        }
        return Collections.EMPTY_SET;
    }

    public void dispose() {
        this.adaptersToElementCollection.clear();
        this.elementsToAdapters.clear();
    }
}

