/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.databinding.updatables;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jface.databinding.ChangeEvent;
import org.eclipse.jface.databinding.IChangeListener;
import org.eclipse.jface.databinding.ILazyReadableValue;
import org.eclipse.jface.databinding.IReadable;
import org.eclipse.jface.databinding.IUpdatable;
import org.eclipse.jface.databinding.UpdatableTracker;
import org.eclipse.jface.databinding.WritableUpdatable;

public abstract class LazyCalculatedValue
extends WritableUpdatable
implements ILazyReadableValue {
    private boolean dirty = true;
    private Object cachedValue = null;
    private Collection dependencies = new ArrayList();
    private int staleCount = 0;
    private PrivateInterfaces privateInterface = new PrivateInterfaces();

    public final Object getValue() {
        UpdatableTracker.getterCalled(this);
        if (this.dirty) {
            boolean isStale;
            boolean wasStale = this.staleCount != 0;
            Set newDependencies = UpdatableTracker.runAndMonitor(this.privateInterface);
            int newStaleCount = 0;
            Iterator iter = newDependencies.iterator();
            while (iter.hasNext()) {
                IReadable next = (IReadable)iter.next();
                if (next.isStale()) {
                    ++newStaleCount;
                }
                next.addChangeListener(this.privateInterface);
            }
            this.staleCount = newStaleCount;
            this.dependencies = newDependencies;
            boolean bl = isStale = this.staleCount != 0;
            if (wasStale != isStale) {
                this.fireChangeEvent(this.createStaleEvent(isStale));
            }
            this.dirty = false;
        }
        return this.cachedValue;
    }

    protected abstract Object calculate();

    protected final void makeDirty() {
        if (!this.dirty) {
            this.dirty = true;
            IReadable[] updatables = this.dependencies.toArray(new IReadable[this.dependencies.size()]);
            this.dependencies.clear();
            int i = 0;
            while (i < updatables.length) {
                IReadable readable = updatables[i];
                readable.removeChangeListener(this.privateInterface);
                ++i;
            }
            this.fireChangeEvent(new ChangeEvent(this, 128, null, null));
        }
    }

    public void dispose() {
        IUpdatable[] updatables = this.dependencies.toArray(new IUpdatable[this.dependencies.size()]);
        this.dependencies.clear();
        int i = 0;
        while (i < updatables.length) {
            IUpdatable updatable = updatables[i];
            updatable.removeChangeListener(this.privateInterface);
            ++i;
        }
        super.dispose();
    }

    private void markStale(IReadable readable, boolean isStale) {
        if (isStale) {
            ++this.staleCount;
            if (this.staleCount == 1) {
                this.fireChangeEvent(this.createStaleEvent(true));
            }
        } else {
            --this.staleCount;
            if (this.staleCount == 0) {
                this.fireChangeEvent(this.createStaleEvent(false));
            }
        }
    }

    private class PrivateInterfaces
    implements Runnable,
    IChangeListener {
        PrivateInterfaces() {
        }

        public void run() {
            LazyCalculatedValue.this.cachedValue = LazyCalculatedValue.this.calculate();
        }

        public void handleChange(ChangeEvent changeEvent) {
            switch (changeEvent.getChangeType()) {
                case 64: {
                    boolean isStale = (Boolean)changeEvent.getNewValue();
                    LazyCalculatedValue.this.markStale((IReadable)changeEvent.getSource(), isStale);
                }
                case 8: {
                    return;
                }
            }
            LazyCalculatedValue.this.makeDirty();
        }
    }
}

