/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.databinding.viewers;

import java.util.Collections;
import org.eclipse.jface.databinding.ChangeEvent;
import org.eclipse.jface.databinding.IChangeListener;
import org.eclipse.jface.databinding.viewers.UpdatableTreeContentProvider;
import org.eclipse.jface.databinding.viewers.ViewerLabelProvider;
import org.eclipse.jface.internal.databinding.swt.SWTUtil;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public final class DirtyIndicationLabelProvider
extends ViewerLabelProvider {
    private final UpdatableTreeContentProvider cp;
    private final Color busy;
    private final Color black;
    private IChangeListener dirtyListener;
    private Color grayColor;
    private IViewerLabelProvider toWrap;

    public DirtyIndicationLabelProvider(Control context, UpdatableTreeContentProvider cp, IViewerLabelProvider toConvert) {
        this(cp, context.getDisplay(), toConvert, context.getForeground(), context.getBackground());
    }

    public DirtyIndicationLabelProvider(UpdatableTreeContentProvider cp, Display display, IViewerLabelProvider convert, Color foreground, Color background) {
        this.toWrap = convert;
        this.cp = cp;
        RGB fg = foreground.getRGB();
        RGB bg = background.getRGB();
        RGB grayed = SWTUtil.mix(fg, bg, 0.5);
        this.busy = this.grayColor = new Color((Device)display, grayed);
        this.black = foreground;
        this.dirtyListener = new IChangeListener(){

            public void handleChange(ChangeEvent changeEvent) {
                if (changeEvent.getChangeType() == 64) {
                    DirtyIndicationLabelProvider.this.dirtyChanged(changeEvent.getSource());
                }
            }
        };
        cp.addDirtyListener(this.dirtyListener);
    }

    private void dirtyChanged(Object element) {
        this.fireChangeEvent(Collections.singletonList(element));
    }

    public void updateLabel(ViewerLabel label, Object element) {
        label.setForeground(this.black);
        this.toWrap.updateLabel(label, element);
        if (this.cp.isDirty(element)) {
            label.setForeground(this.busy);
        }
    }

    public void dispose() {
        this.cp.removeDirtyListener(this.dirtyListener);
        super.dispose();
        this.grayColor.dispose();
    }
}

