/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.databinding.viewers;

import org.eclipse.jface.databinding.ICellProvider;
import org.eclipse.jface.databinding.IUpdatableTable;
import org.eclipse.jface.databinding.updatables.WritableSet;
import org.eclipse.jface.databinding.viewers.UpdatableSetContentProvider;
import org.eclipse.jface.databinding.viewers.ViewerLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Image;

public class TableViewerUpdatableTable
extends WritableSet
implements IUpdatableTable {
    private final TableViewer tableViewer;
    private UpdatableSetContentProvider contentProvider;
    private ICellProvider cellProvider;

    public TableViewerUpdatableTable(TableViewer tableViewer) {
        this.tableViewer = tableViewer;
        this.contentProvider = new UpdatableSetContentProvider();
        tableViewer.setContentProvider((IContentProvider)this.contentProvider);
    }

    public void setCellProvider(ICellProvider cellProvider) {
        this.cellProvider = cellProvider;
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.tableViewer.setInput((Object)this);
    }

    public void updateElements(Object[] elements) {
        this.tableViewer.update(elements, null);
    }

    private final class LabelProvider
    extends ViewerLabelProvider
    implements ITableLabelProvider {
        LabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            Object cellValue = TableViewerUpdatableTable.this.cellProvider.getCellValue(element, columnIndex);
            if (cellValue instanceof ViewerLabel) {
                return ((ViewerLabel)cellValue).getImage();
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            Object cellValue = TableViewerUpdatableTable.this.cellProvider.getCellValue(element, columnIndex);
            if (cellValue instanceof ViewerLabel) {
                return ((ViewerLabel)cellValue).getText();
            }
            return cellValue.toString();
        }
    }
}

