/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding;

import java.util.List;
import org.eclipse.jface.databinding.BindingEvent;
import org.eclipse.jface.databinding.BindingException;
import org.eclipse.jface.databinding.ChangeEvent;
import org.eclipse.jface.databinding.IBindSpec;
import org.eclipse.jface.databinding.IChangeListener;
import org.eclipse.jface.databinding.IUpdatableCollection;
import org.eclipse.jface.databinding.converter.IConverter;
import org.eclipse.jface.databinding.validator.IValidator;
import org.eclipse.jface.internal.databinding.Binding;
import org.eclipse.jface.internal.databinding.DataBindingContext;

public class CollectionBinding
extends Binding {
    private final IUpdatableCollection target;
    private final IUpdatableCollection model;
    private IConverter converter;
    private IValidator validator;
    private boolean updating = false;
    private final IChangeListener targetChangeListener = new IChangeListener(){

        public void handleChange(ChangeEvent changeEvent) {
            if (CollectionBinding.this.updating) {
                return;
            }
            if (changeEvent.getChangeType() == 8) {
                Object value = changeEvent.getNewValue();
                String partialValidationError = CollectionBinding.this.validator.isPartiallyValid(value);
                CollectionBinding.this.context.updatePartialValidationError(this, partialValidationError);
                if (partialValidationError != null) {
                    changeEvent.setVeto(true);
                }
                BindingEvent e = new BindingEvent(changeEvent, 2, 1);
                e.originalValue = changeEvent.getNewValue();
                partialValidationError = CollectionBinding.this.fireBindingEvent(e);
                CollectionBinding.this.context.updatePartialValidationError(this, partialValidationError);
                if (partialValidationError != null) {
                    changeEvent.setVeto(true);
                }
            } else if ((changeEvent.getChangeType() & 0x307) != 0) {
                String validationError = null;
                if (changeEvent.getChangeType() != 4) {
                    Object value = changeEvent.getNewValue();
                    validationError = CollectionBinding.this.validator.isValid(value);
                    CollectionBinding.this.context.updatePartialValidationError(this, null);
                    CollectionBinding.this.context.updateValidationError(this, validationError);
                }
                if (validationError == null) {
                    CollectionBinding.this.update(CollectionBinding.this.model, CollectionBinding.this.target, changeEvent);
                }
            }
        }
    };
    private IChangeListener modelChangeListener = new IChangeListener(){

        public void handleChange(ChangeEvent changeEvent) {
            if (CollectionBinding.this.updating) {
                return;
            }
            if ((changeEvent.getChangeType() & 0x307) != 0) {
                CollectionBinding.this.update(CollectionBinding.this.target, CollectionBinding.this.model, changeEvent);
            }
        }
    };

    public CollectionBinding(DataBindingContext context, IUpdatableCollection target, IUpdatableCollection model, IBindSpec bindSpec) {
        super(context);
        this.target = target;
        this.model = model;
        this.converter = bindSpec.getConverter();
        if (this.converter == null) {
            throw new BindingException("Missing converter from " + target.getElementType() + " to " + model.getElementType());
        }
        if (!this.converter.getModelType().equals(model.getElementType())) {
            throw new BindingException("Converter does not apply to model type. Expected: " + model.getElementType() + ", actual: " + this.converter.getModelType());
        }
        if (!this.converter.getTargetType().equals(target.getElementType())) {
            throw new BindingException("Converter does not apply to target type. Expected: " + target.getElementType() + ", actual: " + this.converter.getTargetType());
        }
        this.validator = bindSpec.getValidator();
        if (this.validator == null) {
            throw new BindingException("Missing validator");
        }
        target.addChangeListener(this.targetChangeListener);
        model.addChangeListener(this.modelChangeListener);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void update(IUpdatableCollection needsUpdate, IUpdatableCollection source, ChangeEvent changeEvent) {
        block11: {
            int row = changeEvent.getPosition();
            if (row == -1) {
                this.copyContents(changeEvent, needsUpdate, source);
                return;
            }
            try {
                this.updating = true;
                int copyType = 1;
                if (needsUpdate == this.target) {
                    copyType = 0;
                }
                BindingEvent e = new BindingEvent(changeEvent, copyType, 0);
                e.originalValue = changeEvent.getNewValue();
                if (this.failure(this.errMsg(this.fireBindingEvent(e)))) {
                    Object var7_7 = null;
                    this.updating = false;
                    return;
                }
                if (changeEvent.getChangeType() == 1) {
                    needsUpdate.setElement(row, changeEvent.getNewValue());
                } else if (changeEvent.getChangeType() == 2) {
                    needsUpdate.addElement(changeEvent.getNewValue(), row);
                } else if (changeEvent.getChangeType() == 4) {
                    needsUpdate.removeElement(row);
                }
                e.pipelinePosition = 4;
                if (!this.failure(this.errMsg(this.fireBindingEvent(e)))) break block11;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                this.updating = false;
                throw throwable;
            }
            Object var7_8 = null;
            this.updating = false;
            return;
        }
        Object var7_10 = null;
        this.updating = false;
    }

    public void updateTargetFromModel(ChangeEvent changeEvent) {
        this.copyContents(changeEvent, this.target, this.model);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void copyContents(ChangeEvent changeEvent, IUpdatableCollection destination, IUpdatableCollection source) {
        block5: {
            try {
                this.updating = true;
                int copyType = 1;
                if (destination == this.target) {
                    copyType = 0;
                }
                BindingEvent e = new BindingEvent(changeEvent, copyType, 0);
                e.originalValue = source.getElements();
                if (this.failure(this.errMsg(this.fireBindingEvent(e)))) {
                    Object var6_6 = null;
                    this.updating = false;
                    return;
                }
                destination.setElements((List)e.originalValue);
                e.pipelinePosition = 4;
                if (!this.failure(this.errMsg(this.fireBindingEvent(e)))) break block5;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                this.updating = false;
                throw throwable;
            }
            Object var6_7 = null;
            this.updating = false;
            return;
        }
        Object var6_9 = null;
        this.updating = false;
    }

    private String errMsg(String validationError) {
        this.context.updatePartialValidationError(this.targetChangeListener, null);
        this.context.updateValidationError(this.targetChangeListener, validationError);
        return validationError;
    }

    private boolean failure(String errorMessage) {
        return errorMessage != null;
    }
}

