/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding;

import org.eclipse.jface.databinding.ChangeEvent;
import org.eclipse.jface.databinding.IChangeListener;
import org.eclipse.jface.databinding.IDataBindingContext;
import org.eclipse.jface.databinding.IUpdatable;
import org.eclipse.jface.databinding.IUpdatableCollection;
import org.eclipse.jface.databinding.IUpdatableTree;
import org.eclipse.jface.databinding.IUpdatableValue;
import org.eclipse.jface.databinding.TreeModelDescription;
import org.eclipse.jface.databinding.WritableUpdatable;
import org.eclipse.jface.util.Assert;

public class NestedUpdatableTree
extends WritableUpdatable
implements IUpdatableTree {
    private IDataBindingContext databindingContext;
    private TreeModelDescription originalDescription;
    private IUpdatableTree innerUpdatableTree;
    private boolean updating = false;
    private IChangeListener innerChangeListener = new IChangeListener(){

        public void handleChange(ChangeEvent changeEvent) {
            ChangeEvent nestedEvent;
            if (!NestedUpdatableTree.this.updating && (nestedEvent = NestedUpdatableTree.this.fireChangeEvent(changeEvent.getChangeType(), changeEvent.getOldValue(), changeEvent.getNewValue(), changeEvent.getParent(), changeEvent.getPosition())).getVeto()) {
                changeEvent.setVeto(true);
            }
        }
    };

    public NestedUpdatableTree(IDataBindingContext databindingContext, TreeModelDescription description) {
        this.databindingContext = databindingContext;
        this.originalDescription = description;
        Assert.isTrue((boolean)(description.getRoot() instanceof IUpdatable));
        final IUpdatable outerUpdatableValue = (IUpdatable)description.getRoot();
        this.updateInnerUpdatableValue(outerUpdatableValue);
        IChangeListener outerChangeListener = new IChangeListener(){

            public void handleChange(ChangeEvent changeEvent) {
                if ((changeEvent.getChangeType() & 0x31) != 0) {
                    Object[] old = NestedUpdatableTree.this.getElements(null);
                    NestedUpdatableTree.this.updateInnerUpdatableValue(outerUpdatableValue);
                    NestedUpdatableTree.this.fireChangeEvent(16, old, NestedUpdatableTree.this.getElements(null), null, -1);
                }
            }
        };
        outerUpdatableValue.addChangeListener(outerChangeListener);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateInnerUpdatableValue(IUpdatable outerUpdatableValue) {
        this.updating = true;
        try {
            int i;
            Object[] currentOuterValue;
            if (this.innerUpdatableTree != null) {
                this.innerUpdatableTree.removeChangeListener(this.innerChangeListener);
                this.innerUpdatableTree.dispose();
            }
            if (outerUpdatableValue instanceof IUpdatableValue) {
                currentOuterValue = ((IUpdatableValue)outerUpdatableValue).getValue();
            } else {
                IUpdatableCollection collection = (IUpdatableCollection)outerUpdatableValue;
                Object[] elements = new Object[collection.getSize()];
                i = 0;
                while (true) {
                    if (i >= elements.length) {
                        currentOuterValue = elements;
                        break;
                    }
                    elements[i] = collection.getElement(i);
                    ++i;
                }
            }
            TreeModelDescription newDescriptor = new TreeModelDescription(currentOuterValue);
            Class[] types = this.originalDescription.getTypes();
            i = 0;
            block4: while (true) {
                block11: {
                    if (i < types.length) break block11;
                    this.innerUpdatableTree = (IUpdatableTree)this.databindingContext.createUpdatable(newDescriptor);
                    this.innerUpdatableTree.addChangeListener(this.innerChangeListener);
                    break;
                }
                String[] properties = this.originalDescription.getChildrenProperties(types[i]);
                int j = 0;
                while (true) {
                    if (j >= properties.length) {
                        ++i;
                        continue block4;
                    }
                    newDescriptor.addChildrenProperty(types[i], properties[j]);
                    ++j;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.updating = false;
            throw throwable;
        }
        {
            Object var8_10 = null;
            this.updating = false;
            return;
        }
    }

    public int addElement(Object parentElement, int index, Object value) {
        return this.innerUpdatableTree.addElement(parentElement, index, value);
    }

    public void removeElement(Object parentElement, int index) {
        this.innerUpdatableTree.removeElement(parentElement, index);
    }

    public void setElement(Object parentElement, int index, Object value) {
        this.innerUpdatableTree.setElement(parentElement, index, value);
    }

    public void setElements(Object parentElement, Object[] values) {
        this.innerUpdatableTree.setElements(parentElement, values);
    }

    public Object getElement(Object parentElement, int index) {
        return this.innerUpdatableTree.getElement(parentElement, index);
    }

    public Object[] getElements(Object parentElement) {
        return this.innerUpdatableTree.getElements(parentElement);
    }
}

