/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.beans;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jface.databinding.ChangeEvent;
import org.eclipse.jface.databinding.DataBinding;
import org.eclipse.jface.databinding.IChangeListener;
import org.eclipse.jface.databinding.IDataBindingContext;
import org.eclipse.jface.databinding.IUpdatableFactory;
import org.eclipse.jface.databinding.IUpdatableValue;
import org.eclipse.jface.databinding.Property;
import org.eclipse.jface.databinding.UpdatableCollection;
import org.eclipse.jface.databinding.beans.JavaBeansScalarUpdatableValueFactory;
import org.eclipse.jface.util.Assert;

public class CopyOfJavaBeanUpdatableCollection
extends UpdatableCollection {
    private boolean updating = false;
    private PropertyDescriptor descriptor;
    private Class elementType = null;
    private IUpdatableValue objectUpdatable;
    private IChangeListener changeListener = new IChangeListener(){

        public void handleChange(ChangeEvent changeEvent) {
            if (!CopyOfJavaBeanUpdatableCollection.this.updating) {
                CopyOfJavaBeanUpdatableCollection.this.fireChangeEvent(changeEvent.getChangeType(), null, null, -1);
            }
        }
    };
    static /* synthetic */ Class class$0;

    public CopyOfJavaBeanUpdatableCollection(Object object, PropertyDescriptor descriptor, Class elementType) {
        this.descriptor = descriptor;
        this.elementType = elementType;
        IDataBindingContext dbc = DataBinding.createContext(new IUpdatableFactory[]{new JavaBeansScalarUpdatableValueFactory()});
        this.objectUpdatable = (IUpdatableValue)dbc.createUpdatable(new Property(object, descriptor.getName()));
        this.objectUpdatable.addChangeListener(this.changeListener);
    }

    public void dispose() {
        super.dispose();
        this.objectUpdatable.dispose();
    }

    private Collection collection() {
        return (Collection)this.objectUpdatable.getValue();
    }

    private Object[] array() {
        return (Object[])this.objectUpdatable.getValue();
    }

    public int computeSize() {
        if (this.descriptor.getPropertyType().isArray()) {
            return this.array().length;
        }
        return this.collection().size();
    }

    public int addElement(Object value, int index) {
        if (this.descriptor.getPropertyType().isArray()) {
            Assert.isTrue((boolean)false, (String)"cannot add elements");
        }
        Collection list = this.collection();
        list.add(value);
        if (index <= 0 || index > list.size()) {
            index = list.size();
        }
        this.fireChangeEvent(2, null, value, index);
        return index;
    }

    private Object findElement(int index) {
        Collection list = this.collection();
        Object o = null;
        int i = 0;
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            if (index == i) {
                o = iter.next();
                break;
            }
            iter.next();
            ++i;
        }
        return o;
    }

    public void removeElement(int index) {
        Object o;
        if (this.descriptor.getPropertyType().isArray()) {
            Assert.isTrue((boolean)false, (String)"cannot remove elements");
        }
        if ((o = this.findElement(index)) != null) {
            this.collection().remove(o);
            this.fireChangeEvent(4, o, null, index);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setElement(int index, Object value) {
        if (this.updating) {
            return;
        }
        this.updating = true;
        try {
            Object oldValue;
            if (this.descriptor.getPropertyType().isArray()) {
                oldValue = this.array()[index];
                this.array()[index] = value;
            } else {
                Collection c = this.collection();
                oldValue = this.findElement(index);
                try {
                    Class<?> clazz = c.getClass();
                    Class[] classArray = new Class[2];
                    classArray[0] = Integer.TYPE;
                    Class<?> clazz2 = class$0;
                    if (clazz2 == null) {
                        Class<?> clazz3;
                        try {
                            clazz3 = Class.forName("java.lang.Object");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        clazz2 = class$0 = clazz3;
                    }
                    classArray[1] = clazz2;
                    Method setMethod = clazz.getMethod("set", classArray);
                    setMethod.invoke((Object)c, new Integer(index), value);
                }
                catch (Exception exception) {
                    if (oldValue != null) {
                        c.remove(oldValue);
                    }
                    c.add(value);
                }
            }
            this.fireChangeEvent(1, oldValue, value, index);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.updating = false;
            throw throwable;
        }
        {
            Object var6_8 = null;
            this.updating = false;
            return;
        }
    }

    public Object computeElement(int index) {
        if (this.descriptor.getPropertyType().isArray()) {
            return this.array()[index];
        }
        return this.findElement(index);
    }

    public Class getElementType() {
        return this.elementType;
    }
}

