/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.swt;

import org.eclipse.jface.databinding.UpdatableValue;
import org.eclipse.swt.widgets.Control;

public class ControlUpdatableValue
extends UpdatableValue {
    private final Control control;
    private final String attribute;

    public ControlUpdatableValue(Control control, String attribute) {
        this.control = control;
        this.attribute = attribute;
        if (!attribute.equals("enabled") && !attribute.equals("visible")) {
            throw new IllegalArgumentException();
        }
    }

    public void setValue(Object value) {
        Object oldValue = this.computeValue();
        if (this.attribute.equals("enabled")) {
            this.control.setEnabled(((Boolean)value).booleanValue());
        } else if (this.attribute.equals("visible")) {
            this.control.setVisible(((Boolean)value).booleanValue());
        }
        this.fireChangeEvent(1, oldValue, value);
    }

    public Object computeValue() {
        return new Boolean(this.attribute.equals("enabled") ? this.control.getEnabled() : this.control.getVisible());
    }

    public Class getValueType() {
        return Boolean.TYPE;
    }
}

