/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.builders;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.PDEMessages;
import org.eclipse.pde.internal.builders.ErrorReporter;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.ModelEntry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.core.ibundle.IBundleFragmentModel;
import org.eclipse.pde.internal.core.ibundle.IBundleModel;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.ibundle.IManifestHeader;
import org.eclipse.pde.internal.core.text.build.BuildEntry;
import org.eclipse.pde.internal.core.text.build.BuildModel;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.eclipse.pde.internal.core.util.PatternConstructor;

public class BuildErrorReporter
extends ErrorReporter {
    private static final String BIN_INCLUDES = "bin.includes";
    private static final String SRC_INCLUDES = "src.includes";
    private static final String SOURCE = "source.";
    private static final String CUSTOM = "custom";
    private ArrayList fProblemList = new ArrayList();
    private int fSeverity;

    public BuildErrorReporter(IFile buildFile, int severity) {
        super(buildFile);
        this.fSeverity = severity;
    }

    public void validate(IProgressMonitor monitor) {
        if (this.fSeverity == 2) {
            return;
        }
        WorkspaceBuildModel wbm = new WorkspaceBuildModel(this.fFile);
        wbm.load();
        if (!wbm.isLoaded()) {
            return;
        }
        this.validateBuild(wbm.getBuild(true));
        if (this.fProblemList.size() > 0) {
            this.reportErrors(this.prepareTextBuildModel(monitor), monitor);
        }
    }

    private void validateBuild(IBuild build) {
        IBuildEntry binIncludes = null;
        IBuildEntry srcIncludes = null;
        ArrayList<IBuildEntry> sourceEntries = new ArrayList<IBuildEntry>();
        ArrayList<String> sourceEntryKeys = new ArrayList<String>();
        IBuildEntry[] entries = build.getBuildEntries();
        int i = 0;
        while (i < entries.length) {
            String[] tokens;
            String name = entries[i].getName();
            if (entries[i].getTokens().length == 0) {
                this.prepareError(name, null, PDEMessages.BuildErrorReporter_emptyEntry);
            } else if (name.equals(BIN_INCLUDES)) {
                binIncludes = entries[i];
            } else if (name.equals(SRC_INCLUDES)) {
                srcIncludes = entries[i];
            } else if (name.startsWith(SOURCE)) {
                sourceEntries.add(entries[i]);
                sourceEntryKeys.add(entries[i].getName());
            } else if (name.equals(CUSTOM) && (tokens = entries[i].getTokens()).length == 1 && tokens[0].equalsIgnoreCase("true")) {
                return;
            }
            ++i;
        }
        this.validateIncludes(binIncludes, sourceEntryKeys);
        this.validateIncludes(srcIncludes, sourceEntryKeys);
        try {
            if (this.fProject.hasNature("org.eclipse.jdt.core.javanature")) {
                IJavaProject jp = JavaCore.create((IProject)this.fProject);
                IClasspathEntry[] cpes = jp.getRawClasspath();
                this.validateMissingLibraries(sourceEntryKeys, cpes);
                this.validateSourceEntries(sourceEntries, cpes);
            }
        }
        catch (JavaModelException javaModelException) {
        }
        catch (CoreException coreException) {}
        this.validateSourceEntries(sourceEntries);
        this.validateMissingSourceInBinIncludes(binIncludes, sourceEntryKeys);
    }

    private void validateMissingSourceInBinIncludes(IBuildEntry binIncludes, ArrayList sourceEntryKeys) {
        if (binIncludes == null) {
            return;
        }
        int i = 0;
        while (i < sourceEntryKeys.size()) {
            String key = (String)sourceEntryKeys.get(i);
            key = key.substring(SOURCE.length());
            boolean found = false;
            String[] binIncludesTokens = binIncludes.getTokens();
            int j = 0;
            while (j < binIncludesTokens.length) {
                Pattern pattern = PatternConstructor.createPattern((String)binIncludesTokens[j], (boolean)false);
                if (pattern.matcher(key).matches()) {
                    found = true;
                }
                ++j;
            }
            if (!found) {
                this.prepareError(BIN_INCLUDES, null, NLS.bind((String)PDEMessages.BuildErrorReporter_binIncludesMissing, (Object)key));
            }
            ++i;
        }
    }

    private void validateSourceEntries(ArrayList sourceEntries) {
        int i = 0;
        while (i < sourceEntries.size()) {
            String name = ((IBuildEntry)sourceEntries.get(i)).getName();
            String[] tokens = ((IBuildEntry)sourceEntries.get(i)).getTokens();
            int j = 0;
            while (j < tokens.length) {
                IResource folderEntry = this.fProject.findMember(tokens[j]);
                if (folderEntry == null || !folderEntry.exists() || !(folderEntry instanceof IFolder)) {
                    this.prepareError(name, tokens[j], NLS.bind((String)PDEMessages.BuildErrorReporter_missingFolder, (Object)tokens[j]));
                }
                ++j;
            }
            ++i;
        }
    }

    private void validateMissingLibraries(ArrayList sourceEntryKeys, IClasspathEntry[] cpes) {
        IBundleModel bm;
        IManifestHeader mh;
        PluginModelManager manager = PDECore.getDefault().getModelManager();
        IPluginModelBase model = manager.findModel(this.fProject);
        if (model == null) {
            return;
        }
        if (model instanceof IBundlePluginModelBase && !(model instanceof IBundleFragmentModel) && ((mh = (bm = ((IBundlePluginModelBase)model).getBundleModel()).getBundle().getManifestHeader("Bundle-ClassPath")) == null || mh.getValue() == null)) {
            int i = 0;
            while (i < cpes.length) {
                if (cpes[i].getEntryKind() == 3) {
                    if (sourceEntryKeys.contains("source..")) break;
                    this.prepareError(PDEMessages.BuildErrorReporter_sourceMissing);
                    break;
                }
                ++i;
            }
        }
        IPluginLibrary[] libraries = model.getPluginBase().getLibraries();
        int i = 0;
        while (i < libraries.length) {
            String sourceEntryKey;
            String libname = libraries[i].getName();
            if (libname.equals(".")) {
                int j = 0;
                while (j < cpes.length) {
                    if (cpes[j].getEntryKind() == 3) {
                        if (!sourceEntryKeys.contains("source..")) {
                            this.prepareError(PDEMessages.BuildErrorReporter_sourceMissing);
                        }
                        break;
                    }
                    ++j;
                }
            } else if (this.fProject.findMember(libname) == null && !sourceEntryKeys.contains(sourceEntryKey = SOURCE + libname) && !this.containedInFragment(manager, model.getBundleDescription().getFragments(), libname)) {
                this.prepareError(NLS.bind((String)PDEMessages.BuildErrorReporter_missingEntry, (Object)sourceEntryKey));
            }
            ++i;
        }
    }

    private boolean containedInFragment(PluginModelManager manager, BundleDescription[] fragments, String libname) {
        if (fragments == null) {
            return false;
        }
        int j = 0;
        while (j < fragments.length) {
            ModelEntry entry = manager.findEntry(fragments[j].getSymbolicName());
            IPluginModelBase fragmentModel = entry.getWorkspaceModel();
            if (fragmentModel != null) {
                IProject project = fragmentModel.getUnderlyingResource().getProject();
                if (project.findMember(libname) != null) {
                    return true;
                }
                try {
                    IBuild build = ClasspathUtilCore.getBuild((IPluginModelBase)fragmentModel);
                    if (build != null) {
                        IBuildEntry[] entries = build.getBuildEntries();
                        int i = 0;
                        while (i < entries.length) {
                            if (entries[i].getName().equals(SOURCE + libname)) {
                                return true;
                            }
                            ++i;
                        }
                        return false;
                    }
                }
                catch (CoreException coreException) {}
            } else {
                String location = fragments[j].getLocation();
                File external = new File(location);
                if (external.exists()) {
                    if (external.isDirectory()) {
                        IPath p = new Path(location).addTrailingSeparator().append(libname);
                        return new File(p.toOSString()).exists();
                    }
                    return CoreUtility.jarContainsResource((File)external, (String)libname, (boolean)false);
                }
            }
            ++j;
        }
        return false;
    }

    private void validateSourceEntries(ArrayList sourceEntries, IClasspathEntry[] cpes) {
        int i = 0;
        while (i < cpes.length) {
            if (cpes[i].getEntryKind() == 3) {
                IPath path = cpes[i].getPath();
                boolean found = false;
                int j = 0;
                while (j < sourceEntries.size()) {
                    IBuildEntry be = (IBuildEntry)sourceEntries.get(j);
                    String[] tokens = be.getTokens();
                    int k = 0;
                    while (k < tokens.length) {
                        IPath ipath;
                        IResource res = this.fProject.findMember(tokens[k]);
                        if (res != null && (ipath = res.getFullPath()).equals((Object)path)) {
                            found = true;
                        }
                        ++k;
                    }
                    ++j;
                }
                if (!found) {
                    String spath = path.removeFirstSegments(1).addTrailingSeparator().toString();
                    if (sourceEntries.size() == 1) {
                        String name = ((IBuildEntry)sourceEntries.get(0)).getName();
                        this.prepareError(name, null, NLS.bind((String)PDEMessages.BuildErrorReporter_classpathEntryMissing1, (Object)spath, (Object)name));
                    } else {
                        this.prepareError(NLS.bind((String)PDEMessages.BuildErrorReporter_classpathEntryMissing, (Object)spath));
                    }
                }
            }
            ++i;
        }
    }

    private void validateIncludes(IBuildEntry includes, ArrayList sourceIncludes) {
        if (includes == null) {
            return;
        }
        String[] tokens = includes.getTokens();
        int i = 0;
        while (i < tokens.length) {
            block6: {
                String message;
                String token;
                block8: {
                    IResource member;
                    block7: {
                        token = tokens[i].trim();
                        if (token.indexOf("*") != -1 || token.equals(".")) break block6;
                        member = this.fProject.findMember(token);
                        message = null;
                        if (member != null) break block7;
                        if (sourceIncludes.contains(SOURCE + token)) break block6;
                        message = token.endsWith("/") ? NLS.bind((String)PDEMessages.BuildErrorReporter_missingFolder, (Object)token) : NLS.bind((String)PDEMessages.BuildErrorReporter_missingFile, (Object)token);
                        break block8;
                    }
                    if (token.endsWith("/") && !(member instanceof IFolder)) {
                        message = NLS.bind((String)PDEMessages.BuildErrorReporter_entiresMustRefDirs, (Object)token);
                    } else if (!token.endsWith("/") && !(member instanceof IFile)) {
                        message = NLS.bind((String)PDEMessages.BuildErrorReporter_dirsMustEndSlash, (Object)token);
                    }
                }
                if (message != null) {
                    this.prepareError(includes.getName(), token, message);
                }
            }
            ++i;
        }
    }

    private BuildModel prepareTextBuildModel(IProgressMonitor monitor) {
        try {
            IDocument doc = this.createDocument(this.fFile);
            if (doc == null) {
                return null;
            }
            BuildModel bm = new BuildModel(doc, true);
            bm.load();
            if (!bm.isLoaded()) {
                return null;
            }
            return bm;
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    private void reportErrors(BuildModel bm, IProgressMonitor monitor) {
        if (bm == null) {
            return;
        }
        IBuild build = bm.getBuild();
        IBuildEntry[] buildEntries = build.getBuildEntries();
        HashMap<String, IBuildEntry> entries = new HashMap<String, IBuildEntry>();
        int i = 0;
        while (i < buildEntries.length) {
            entries.put(buildEntries[i].getName(), buildEntries[i]);
            ++i;
        }
        i = 0;
        while (i < this.fProblemList.size()) {
            block7: {
                int lineNum;
                BuildProblem bp;
                block9: {
                    block8: {
                        bp = (BuildProblem)this.fProblemList.get(i);
                        if (bp == null) break block7;
                        if (!bp.noLine()) break block8;
                        lineNum = 1;
                        break block9;
                    }
                    bp.fBuildEntry = (IBuildEntry)entries.get(bp.fEntryName);
                    if (bp.fBuildEntry == null) break block7;
                    lineNum = this.getLineNumber(bp.fBuildEntry, bp.fEntryToken);
                }
                if (lineNum > 0) {
                    this.report(bp.fMessage, lineNum, this.fSeverity);
                }
            }
            ++i;
        }
    }

    private int getLineNumber(IBuildEntry ibe, String tokenString) {
        if (!(ibe instanceof BuildEntry)) {
            return 0;
        }
        BuildEntry be = (BuildEntry)ibe;
        IDocument doc = ((BuildModel)be.getModel()).getDocument();
        try {
            if (tokenString == null) {
                return doc.getLineOfOffset(be.getOffset()) + 1;
            }
            String entry = doc.get(be.getOffset(), be.getLength());
            int index = entry.indexOf(61) + 1;
            if (index == 0 || index == entry.length()) {
                return 0;
            }
            int entryTokenOffset = (entry = entry.substring(index)).indexOf(tokenString);
            if (entryTokenOffset == -1) {
                return 0;
            }
            if (entryTokenOffset == entry.lastIndexOf(tokenString)) {
                return doc.getLineOfOffset(be.getOffset() + index + entryTokenOffset) + 1;
            }
            entryTokenOffset = 0;
            while (true) {
                int cci;
                if ((cci = entry.indexOf(44)) == -1 && entry.indexOf(tokenString) == -1) {
                    return 0;
                }
                boolean sws = entry.charAt(0) == '\\';
                String ct = entry.substring(sws ? 1 : 0, cci);
                entryTokenOffset += cci;
                if (ct.trim().equals(tokenString)) {
                    return doc.getLineOfOffset(be.getOffset() + index + entryTokenOffset) + 1;
                }
                entry = entry.substring(cci + 1);
            }
        }
        catch (BadLocationException badLocationException) {
            return 0;
        }
    }

    private void prepareError(String name, String token, String message) {
        BuildProblem bp = new BuildProblem(name, token, message);
        this.fProblemList.add(bp);
    }

    private void prepareError(String message) {
        this.prepareError(null, null, message);
    }

    private class BuildProblem {
        IBuildEntry fBuildEntry;
        String fEntryToken;
        String fEntryName;
        String fMessage;

        BuildProblem(String name, String token, String message) {
            this.fEntryName = name;
            this.fEntryToken = token;
            this.fMessage = message;
        }

        boolean noLine() {
            return this.fEntryName == null;
        }
    }
}

