/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.core.subscribers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.ITeamStatus;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.synchronize.ISyncInfoSetChangeEvent;
import org.eclipse.team.core.synchronize.ISyncInfoSetChangeListener;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.core.synchronize.SyncInfoTree;
import org.eclipse.team.internal.core.BackgroundEventHandler;
import org.eclipse.team.internal.core.Messages;
import org.eclipse.team.internal.core.Policy;
import org.eclipse.team.internal.core.TeamPlugin;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSet;
import org.eclipse.team.internal.core.subscribers.ChangeSet;
import org.eclipse.team.internal.core.subscribers.ChangeSetCollector;
import org.eclipse.team.internal.core.subscribers.SubscriberResourceCollector;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class SubscriberChangeSetCollector
extends ChangeSetCollector
implements ISyncInfoSetChangeListener {
    private static final String PREF_CHANGE_SETS = "changeSets";
    private static final String CTX_DEFAULT_SET = "defaultSet";
    private static final int RESOURCE_REMOVAL = 1;
    private static final int RESOURCE_CHANGE = 2;
    private ActiveChangeSet defaultSet;
    private EventHandler handler;
    private ResourceCollector collector;

    public SubscriberChangeSetCollector(Subscriber subscriber) {
        this.collector = new ResourceCollector(subscriber);
        this.load();
        this.handler = new EventHandler(NLS.bind((String)Messages.SubscriberChangeSetCollector_1, (Object[])new String[]{subscriber.getName()}), NLS.bind((String)Messages.SubscriberChangeSetCollector_2, (Object[])new String[]{subscriber.getName()}));
    }

    public boolean hasMembers(IResource resource) {
        ChangeSet[] sets = this.getSets();
        int i = 0;
        while (i < sets.length) {
            ChangeSet set = sets[i];
            if (set.getSyncInfoSet().hasMembers(resource)) {
                // empty if block
            }
            ++i;
        }
        if (this.defaultSet != null) {
            return this.defaultSet.getSyncInfoSet().hasMembers(resource);
        }
        return false;
    }

    public void add(ChangeSet set) {
        Assert.isTrue((boolean)(set instanceof ActiveChangeSet));
        if (!this.contains(set)) {
            super.add(set);
            this.handleAddedResources(set, set.getSyncInfoSet().getSyncInfos());
        }
    }

    protected boolean isSingleSetPerResource() {
        return true;
    }

    public ActiveChangeSet createSet(String title, SyncInfo[] infos) {
        ActiveChangeSet commitSet = new ActiveChangeSet(this, title);
        if (infos != null && infos.length > 0) {
            commitSet.add(infos);
        }
        return commitSet;
    }

    public ActiveChangeSet createSet(String title, IFile[] files) throws TeamException {
        ArrayList<SyncInfo> infos = new ArrayList<SyncInfo>();
        int i = 0;
        while (i < files.length) {
            IFile file = files[i];
            SyncInfo info = this.getSyncInfo((IResource)file);
            if (info != null) {
                infos.add(info);
            }
            ++i;
        }
        return this.createSet(title, infos.toArray(new SyncInfo[infos.size()]));
    }

    public void makeDefault(ActiveChangeSet set) {
        if (!this.contains(set)) {
            this.add(set);
        }
        ActiveChangeSet oldSet = this.defaultSet;
        this.defaultSet = set;
        this.fireDefaultChangedEvent(oldSet, this.defaultSet);
    }

    public ActiveChangeSet getDefaultSet() {
        return this.defaultSet;
    }

    public boolean isDefault(ActiveChangeSet set) {
        return set == this.defaultSet;
    }

    protected SyncInfo getSyncInfo(IResource resource) throws TeamException {
        Subscriber subscriber = this.getSubscriber();
        SyncInfo info = subscriber.getSyncInfo(resource);
        return info;
    }

    public Subscriber getSubscriber() {
        return this.collector.getSubscriber();
    }

    protected boolean isModified(SyncInfo info) {
        if (info != null) {
            if (info.getComparator().isThreeWay()) {
                int dir = info.getKind() & 0xC;
                return dir == 4 || dir == 12;
            }
            return (info.getKind() & 3) == 3;
        }
        return false;
    }

    public void dispose() {
        this.handler.shutdown();
        this.collector.dispose();
        super.dispose();
        this.save();
    }

    private void save() {
        int i;
        Preferences prefs = this.getPreferences();
        try {
            String[] oldSetNames = prefs.childrenNames();
            i = 0;
            while (i < oldSetNames.length) {
                String string = oldSetNames[i];
                prefs.node(string).removeNode();
                ++i;
            }
        }
        catch (BackingStoreException e) {
            TeamPlugin.log(4, NLS.bind((String)"An error occurred purging the sommit set state for {0}", (Object[])new String[]{this.getSubscriber().getName()}), e);
        }
        ChangeSet[] sets = this.getSets();
        i = 0;
        while (i < sets.length) {
            ChangeSet set = sets[i];
            if (set instanceof ActiveChangeSet && !set.isEmpty()) {
                Preferences child = prefs.node(((ActiveChangeSet)set).getTitle());
                ((ActiveChangeSet)set).save(child);
            }
            ++i;
        }
        if (this.defaultSet != null) {
            prefs.put(CTX_DEFAULT_SET, this.defaultSet.getTitle());
        }
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            TeamPlugin.log(4, NLS.bind((String)Messages.SubscriberChangeSetCollector_3, (Object[])new String[]{this.getSubscriber().getName()}), e);
        }
    }

    private void load() {
        Preferences prefs = this.getPreferences();
        String defaultSetTitle = prefs.get(CTX_DEFAULT_SET, null);
        try {
            String[] childNames = prefs.childrenNames();
            int i = 0;
            while (i < childNames.length) {
                String string = childNames[i];
                Preferences childPrefs = prefs.node(string);
                ActiveChangeSet set = this.createSet(string, childPrefs);
                if (!set.isEmpty()) {
                    if (this.defaultSet == null && defaultSetTitle != null && set.getTitle().equals(defaultSetTitle)) {
                        this.defaultSet = set;
                    }
                    this.add(set);
                }
                ++i;
            }
        }
        catch (BackingStoreException e) {
            TeamPlugin.log(4, NLS.bind((String)Messages.SubscriberChangeSetCollector_4, (Object[])new String[]{this.getSubscriber().getName()}), e);
        }
    }

    protected ActiveChangeSet createSet(String title, Preferences childPrefs) {
        ActiveChangeSet changeSet = new ActiveChangeSet(this, title);
        changeSet.init(childPrefs);
        return changeSet;
    }

    private Preferences getPreferences() {
        return SubscriberChangeSetCollector.getParentPreferences().node(this.getSubscriberIdentifier());
    }

    private static Preferences getParentPreferences() {
        return SubscriberChangeSetCollector.getTeamPreferences().node(PREF_CHANGE_SETS);
    }

    private static Preferences getTeamPreferences() {
        return new InstanceScope().getNode(TeamPlugin.getPlugin().getBundle().getSymbolicName());
    }

    protected String getSubscriberIdentifier() {
        return this.getSubscriber().getName();
    }

    public void syncInfoSetReset(SyncInfoSet set, IProgressMonitor monitor) {
        this.handleSyncSetChange(set, set.getSyncInfos(), set.getResources());
    }

    public void syncInfoChanged(ISyncInfoSetChangeEvent event, IProgressMonitor monitor) {
        SyncInfoSet set = event.getSet();
        this.handleSyncSetChange(set, event.getAddedResources(), this.getAllResources(event));
    }

    private IResource[] getAllResources(ISyncInfoSetChangeEvent event) {
        HashSet<IResource> allResources = new HashSet<IResource>();
        SyncInfo[] addedResources = event.getAddedResources();
        int i = 0;
        while (i < addedResources.length) {
            SyncInfo info = addedResources[i];
            allResources.add(info.getLocal());
            ++i;
        }
        SyncInfo[] changedResources = event.getChangedResources();
        int i2 = 0;
        while (i2 < changedResources.length) {
            SyncInfo info = changedResources[i2];
            allResources.add(info.getLocal());
            ++i2;
        }
        allResources.addAll(Arrays.asList(event.getRemovedResources()));
        return allResources.toArray(new IResource[allResources.size()]);
    }

    private void handleAddedResources(ChangeSet set, SyncInfo[] infos) {
        if (this.isSingleSetPerResource()) {
            IResource[] resources = new IResource[infos.length];
            int i = 0;
            while (i < infos.length) {
                resources[i] = infos[i].getLocal();
                ++i;
            }
            ChangeSet[] sets = this.getSets();
            int i2 = 0;
            while (i2 < sets.length) {
                ChangeSet otherSet = sets[i2];
                if (otherSet != set) {
                    otherSet.remove(resources);
                }
                ++i2;
            }
        }
    }

    private void handleSyncSetChange(SyncInfoSet set, SyncInfo[] addedInfos, IResource[] allAffectedResources) {
        ChangeSet changeSet = this.getChangeSet(set);
        if (set.isEmpty() && changeSet != null) {
            this.remove(changeSet);
        }
        this.fireResourcesChangedEvent(changeSet, allAffectedResources);
        this.handleAddedResources(changeSet, addedInfos);
    }

    public void syncInfoSetErrors(SyncInfoSet set, ITeamStatus[] errors, IProgressMonitor monitor) {
    }

    protected ISyncInfoSetChangeListener getChangeSetChangeListener() {
        return this;
    }

    public void waitUntilDone(IProgressMonitor monitor) {
        monitor.worked(1);
        while (this.handler.getEventHandlerJob().getState() != 0) {
            monitor.worked(1);
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
            Policy.checkCanceled(monitor);
        }
        monitor.worked(1);
    }

    private class EventHandler
    extends BackgroundEventHandler {
        private List dispatchEvents = new ArrayList();

        protected EventHandler(String jobName, String errorTitle) {
            super(jobName, errorTitle);
        }

        protected void processEvent(BackgroundEventHandler.Event event, IProgressMonitor monitor) throws CoreException {
            if (this.isShutdown()) {
                throw new OperationCanceledException();
            }
            this.dispatchEvents.add(event);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Lifted jumps to return sites
         */
        protected boolean doDispatchEvents(IProgressMonitor monitor) throws TeamException {
            if (this.dispatchEvents.isEmpty()) {
                return false;
            }
            if (this.isShutdown()) {
                throw new OperationCanceledException();
            }
            SyncInfoTree[] locked = null;
            try {
                locked = this.beginDispath();
                Iterator iter = this.dispatchEvents.iterator();
                while (iter.hasNext()) {
                    BackgroundEventHandler.Event event = (BackgroundEventHandler.Event)iter.next();
                    switch (event.getType()) {
                        case 1: {
                            this.handleRemove(event.getResource());
                            break;
                        }
                        case 2: {
                            this.handleChange(event.getResource(), ((BackgroundEventHandler.ResourceEvent)event).getDepth());
                            break;
                        }
                    }
                    if (!this.isShutdown()) continue;
                    throw new OperationCanceledException();
                }
                Object var5_7 = null;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                try {
                    this.endDispatch(locked, monitor);
                    Object var7_11 = null;
                    this.dispatchEvents.clear();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    this.dispatchEvents.clear();
                    throw throwable2;
                }
            }
            try {}
            catch (Throwable throwable) {
                Object var7_12 = null;
                this.dispatchEvents.clear();
                throw throwable;
            }
            this.endDispatch(locked, monitor);
            Object var7_13 = null;
            this.dispatchEvents.clear();
            return true;
        }

        private SyncInfoTree[] beginDispath() {
            ChangeSet[] sets = SubscriberChangeSetCollector.this.getSets();
            ArrayList<SyncInfoTree> lockedSets = new ArrayList<SyncInfoTree>();
            try {
                int i = 0;
                while (i < sets.length) {
                    ChangeSet set = sets[i];
                    SyncInfoTree syncInfoSet = set.getSyncInfoSet();
                    lockedSets.add(syncInfoSet);
                    syncInfoSet.beginInput();
                    ++i;
                }
                return lockedSets.toArray(new SyncInfoTree[lockedSets.size()]);
            }
            catch (RuntimeException e) {
                try {
                    Iterator iter = lockedSets.iterator();
                    while (iter.hasNext()) {
                        SyncInfoTree tree = (SyncInfoTree)iter.next();
                        try {
                            tree.endInput(null);
                        }
                        catch (Throwable throwable) {}
                    }
                }
                catch (Throwable throwable) {}
            }
            throw e;
        }

        private void endDispatch(SyncInfoTree[] locked, IProgressMonitor monitor) {
            if (locked == null) {
                return;
            }
            monitor.beginTask(null, 100 * locked.length);
            int i = 0;
            while (i < locked.length) {
                SyncInfoTree tree = locked[i];
                try {
                    tree.endInput(Policy.subMonitorFor(monitor, 100));
                }
                catch (RuntimeException e) {
                    TeamPlugin.log(4, Messages.SubscriberChangeSetCollector_0, e);
                    throw e;
                }
                ++i;
            }
            monitor.done();
        }

        protected synchronized void queueEvent(BackgroundEventHandler.Event event, boolean front) {
            super.queueEvent(event, front);
        }

        private void handleRemove(IResource resource) {
            ChangeSet[] sets = SubscriberChangeSetCollector.this.getSets();
            int i = 0;
            while (i < sets.length) {
                ChangeSet set = sets[i];
                if (!set.isEmpty()) {
                    set.rootRemoved(resource, 2);
                    if (set.isEmpty()) {
                        SubscriberChangeSetCollector.this.remove(set);
                    }
                }
                ++i;
            }
        }

        private void handleChange(IResource resource, int depth) throws TeamException {
            int i;
            SyncInfo syncInfo = SubscriberChangeSetCollector.this.getSyncInfo(resource);
            if (SubscriberChangeSetCollector.this.isModified(syncInfo)) {
                ActiveChangeSet[] containingSets = this.getContainingSets(resource);
                if (containingSets.length == 0) {
                    if (SubscriberChangeSetCollector.this.defaultSet != null) {
                        SubscriberChangeSetCollector.this.defaultSet.add(syncInfo);
                    }
                } else {
                    i = 0;
                    while (i < containingSets.length) {
                        ActiveChangeSet set = containingSets[i];
                        set.getSyncInfoSet().add(syncInfo);
                        ++i;
                    }
                }
            } else {
                this.removeFromAllSets(resource);
            }
            if (depth != 0) {
                IResource[] members = SubscriberChangeSetCollector.this.getSubscriber().members(resource);
                i = 0;
                while (i < members.length) {
                    IResource member = members[i];
                    this.handleChange(member, depth == 1 ? 0 : 2);
                    ++i;
                }
            }
        }

        private void removeFromAllSets(IResource resource) {
            ChangeSet set;
            ArrayList<ChangeSet> toRemove = new ArrayList<ChangeSet>();
            ChangeSet[] sets = SubscriberChangeSetCollector.this.getSets();
            int i = 0;
            while (i < sets.length) {
                set = sets[i];
                if (set.contains(resource)) {
                    set.remove(resource);
                    if (set.isEmpty()) {
                        toRemove.add(set);
                    }
                }
                ++i;
            }
            Iterator iter = toRemove.iterator();
            while (iter.hasNext()) {
                set = (ActiveChangeSet)iter.next();
                SubscriberChangeSetCollector.this.remove(set);
            }
        }

        private ActiveChangeSet[] getContainingSets(IResource resource) {
            HashSet<ChangeSet> result = new HashSet<ChangeSet>();
            ChangeSet[] sets = SubscriberChangeSetCollector.this.getSets();
            int i = 0;
            while (i < sets.length) {
                ChangeSet set = sets[i];
                if (set.contains(resource)) {
                    result.add(set);
                }
                ++i;
            }
            return result.toArray(new ActiveChangeSet[result.size()]);
        }
    }

    private class ResourceCollector
    extends SubscriberResourceCollector {
        public ResourceCollector(Subscriber subscriber) {
            super(subscriber);
        }

        protected void remove(IResource resource) {
            SubscriberChangeSetCollector.this.handler.queueEvent(new BackgroundEventHandler.ResourceEvent(resource, 1, 2), false);
        }

        protected void change(IResource resource, int depth) {
            SubscriberChangeSetCollector.this.handler.queueEvent(new BackgroundEventHandler.ResourceEvent(resource, 2, depth), false);
        }

        protected boolean hasMembers(IResource resource) {
            return SubscriberChangeSetCollector.this.hasMembers(resource);
        }
    }
}

