/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.IHelpContentProducer;
import org.eclipse.help.internal.util.ResourceLocator;
import org.eclipse.help.internal.xhtml.UAContentParser;
import org.eclipse.help.internal.xhtml.UATransformManager;
import org.eclipse.help.internal.xhtml.XHTMLSupport;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;

public class DynamicContentProducer
implements IHelpContentProducer {
    public InputStream getInputStream(String pluginID, String href, Locale locale) {
        String extension;
        int loc;
        int qloc = href.indexOf(63);
        if (qloc != -1) {
            href = href.substring(0, qloc);
        }
        if ((loc = href.lastIndexOf(46)) != -1 && "xhtml".equals(extension = href.substring(loc + 1).toLowerCase())) {
            return this.openXHTMLFromPlugin(pluginID, href, locale.toString());
        }
        return null;
    }

    private InputStream openXHTMLFromPlugin(String pluginID, String file, String locale) {
        InputStream inputStream = DynamicContentProducer.openStreamFromPlugin(pluginID, file, locale);
        if (inputStream != null) {
            UAContentParser parser = new UAContentParser(inputStream);
            Document dom = parser.getDocument();
            XHTMLSupport support = new XHTMLSupport(pluginID, file, dom, locale);
            dom = support.processDOM();
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
            return UATransformManager.getAsInputStream(dom);
        }
        return null;
    }

    public static InputStream openStreamFromPlugin(String pluginID, String file, String locale) {
        ArrayList pathPrefix = ResourceLocator.getPathPrefix(locale);
        Bundle pluginDesc = Platform.getBundle((String)pluginID);
        URL flatFileURL = ResourceLocator.find(pluginDesc, (IPath)new Path(file), pathPrefix);
        if (flatFileURL != null) {
            try {
                return flatFileURL.openStream();
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return null;
    }
}

