/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.composite.explorer;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.cheatsheets.ICompositeCheatSheetTask;
import org.eclipse.ui.internal.cheatsheets.CheatSheetPlugin;
import org.eclipse.ui.internal.cheatsheets.composite.explorer.OverlayIcon;
import org.eclipse.ui.internal.cheatsheets.composite.views.TaskEditorManager;
import org.osgi.framework.Bundle;

public class TreeLabelProvider
extends LabelProvider {
    private static int BLOCKED = -1;
    private Image defaultImage = null;
    private Map imageMap = new HashMap();

    public String getText(Object obj) {
        if (obj instanceof ICompositeCheatSheetTask) {
            return ((ICompositeCheatSheetTask)obj).getName();
        }
        return obj.toString();
    }

    public Image getImage(Object obj) {
        if (obj instanceof ICompositeCheatSheetTask) {
            ICompositeCheatSheetTask task = (ICompositeCheatSheetTask)obj;
            return this.lookupImage(task.getKind(), task.getState(), task.isStartable());
        }
        return super.getImage(obj);
    }

    private Image getDefaultImage() {
        if (this.defaultImage == null) {
            ImageDescriptor desc = this.createImageDescriptor("icons/obj16/info_task.gif");
            this.defaultImage = desc.createImage();
        }
        return this.defaultImage;
    }

    public Image lookupImage(String kind, int state, boolean isStartable) {
        if (kind == null) {
            return this.getDefaultImage();
        }
        ImageSet images = (ImageSet)this.imageMap.get(kind);
        if (images == null) {
            images = this.createImages(kind);
            this.imageMap.put(kind, images);
        }
        if (isStartable) {
            return images.getImage(state);
        }
        return images.getImage(BLOCKED);
    }

    private ImageSet createImages(String kind) {
        ImageSet images = new ImageSet();
        ImageDescriptor desc = TaskEditorManager.getInstance().getImageDescriptor(kind);
        if (desc != null) {
            images.put(0, desc.createImage());
            ImageDescriptor inProgress = this.createImageDescriptor("icons/ovr16/task_in_progress.gif");
            OverlayIcon icon = new OverlayIcon(desc, new ImageDescriptor[][]{new ImageDescriptor[0], {inProgress}});
            images.put(1, icon.createImage());
            ImageDescriptor complete = this.createImageDescriptor("icons/ovr16/task_complete.gif");
            icon = new OverlayIcon(desc, new ImageDescriptor[][]{new ImageDescriptor[0], {complete}});
            images.put(2, icon.createImage());
            ImageDescriptor blocked = this.createImageDescriptor("icons/ovr16/task_blocked.gif");
            icon = new OverlayIcon(desc, new ImageDescriptor[][]{new ImageDescriptor[0], {blocked}});
            images.put(BLOCKED, icon.createImage());
        }
        return images;
    }

    private ImageDescriptor createImageDescriptor(String relativePath) {
        Bundle bundle = CheatSheetPlugin.getPlugin().getBundle();
        URL url = Platform.find((Bundle)bundle, (IPath)new Path(relativePath));
        try {
            url = Platform.resolve((URL)url);
            return ImageDescriptor.createFromURL((URL)url);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void dispose() {
        if (this.imageMap != null) {
            Iterator iter = this.imageMap.values().iterator();
            while (iter.hasNext()) {
                ImageSet nextImages = (ImageSet)iter.next();
                nextImages.dispose();
            }
            this.imageMap = null;
        }
        if (this.defaultImage != null) {
            this.defaultImage.dispose();
            this.defaultImage = null;
        }
    }

    private class ImageSet {
        Map images = new HashMap();

        ImageSet() {
        }

        public void put(int index, Image image) {
            this.images.put(Integer.toString(index), image);
        }

        public Image getImage(int index) {
            return (Image)this.images.get(Integer.toString(index));
        }

        void dispose() {
            Iterator iter = this.images.values().iterator();
            while (iter.hasNext()) {
                Image nextImage = (Image)iter.next();
                nextImage.dispose();
            }
        }
    }
}

