/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.TextEditBasedChange;
import org.eclipse.ltk.core.refactoring.TextEditBasedChangeGroup;
import org.eclipse.ltk.core.refactoring.TextEditChangeGroup;
import org.eclipse.ltk.internal.core.refactoring.Changes;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditCopier;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.text.edits.TextEditProcessor;
import org.eclipse.text.edits.UndoEdit;

public abstract class TextChange
extends TextEditBasedChange {
    private TextEdit fEdit;
    private TextEditCopier fCopier;

    protected TextChange(String name) {
        super(name);
    }

    public void setEdit(TextEdit edit) {
        Assert.isTrue((this.fEdit == null ? 1 : 0) != 0, (String)"Root edit can only be set once");
        Assert.isTrue((edit != null ? 1 : 0) != 0);
        this.fEdit = edit;
    }

    public TextEdit getEdit() {
        return this.fEdit;
    }

    public void addTextEditGroup(TextEditGroup group) {
        this.addTextEditChangeGroup(new TextEditChangeGroup(this, group));
    }

    public void addTextEditChangeGroup(TextEditChangeGroup group) {
        Assert.isTrue((this.fEdit != null ? 1 : 0) != 0, (String)"Can only add a description if a root edit exists");
        this.addChangeGroup(group);
    }

    public TextEditChangeGroup[] getTextEditChangeGroups() {
        TextEditBasedChangeGroup[] groups = this.getChangeGroups();
        TextEditChangeGroup[] result = new TextEditChangeGroup[groups.length];
        System.arraycopy(groups, 0, result, 0, groups.length);
        return result;
    }

    public void addEdit(TextEdit edit) throws MalformedTreeException {
        Assert.isTrue((this.fEdit != null ? 1 : 0) != 0, (String)"root must exist to add an edit");
        this.fEdit.addChild(edit);
    }

    protected abstract IDocument acquireDocument(IProgressMonitor var1) throws CoreException;

    protected abstract void commit(IDocument var1, IProgressMonitor var2) throws CoreException;

    protected abstract void releaseDocument(IDocument var1, IProgressMonitor var2) throws CoreException;

    protected abstract Change createUndoChange(UndoEdit var1);

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Change perform(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 3);
        document = null;
        session = null;
        try {
            try {
                document = this.acquireDocument((IProgressMonitor)new SubProgressMonitor(pm, 1));
                if (document instanceof IDocumentExtension4) {
                    session = ((IDocumentExtension4)document).startRewriteSession(DocumentRewriteSessionType.UNRESTRICTED);
                }
                processor = this.createTextEditProcessor(document, 1, false);
                undo = processor.performEdits();
                this.commit(document, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                var8_7 = this.createUndoChange(undo);
                var6_8 = null;
                if (document == null) ** GOTO lbl47
                ** GOTO lbl-1000
            }
            catch (BadLocationException e) {
                throw Changes.asCoreException(e);
            }
        }
        catch (Throwable var7_14) {
            var6_9 = null;
            if (document == null) {
                pm.done();
                throw var7_14;
            }
            try {
                if (session != null) {
                    ((IDocumentExtension4)document).stopRewriteSession(session);
                }
                ** GOTO lbl49
            }
            catch (Throwable var10_11) {
                v0 = null;
lbl31:
                // 2 sources

                while (true) {
                    var9_13 = v0;
                    this.releaseDocument(document, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                    throw var7_14;
                }
            }
lbl-1000:
            // 1 sources

            try {}
            catch (Throwable var10_10) {
                v1 = null;
lbl38:
                // 2 sources

                while (true) {
                    var9_12 = v1;
                    this.releaseDocument(document, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                    return var8_7;
                }
            }
            if (session != null) {
                ((IDocumentExtension4)document).stopRewriteSession(session);
            }
            {
                v1 = null;
                ** continue;
lbl47:
                // 1 sources

                pm.done();
                return var8_7;
lbl49:
                // 1 sources

                v0 = null;
                ** continue;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IDocument getCurrentDocument(IProgressMonitor pm) throws CoreException {
        IDocument result;
        block5: {
            if (pm == null) {
                pm = new NullProgressMonitor();
            }
            result = null;
            pm.beginTask("", 2);
            try {
                result = this.acquireDocument((IProgressMonitor)new SubProgressMonitor(pm, 1));
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                if (result != null) {
                    this.releaseDocument(result, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                }
                throw throwable;
            }
            {
                Object var3_5 = null;
                if (result == null) break block5;
            }
            this.releaseDocument(result, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        }
        pm.done();
        return result;
    }

    public String getCurrentContent(IProgressMonitor pm) throws CoreException {
        return this.getCurrentDocument(pm).get();
    }

    public String getCurrentContent(IRegion region, boolean expandRegionToFullLine, int surroundingLines, IProgressMonitor pm) throws CoreException {
        Assert.isNotNull((Object)region);
        Assert.isTrue((surroundingLines >= 0 ? 1 : 0) != 0);
        IDocument document = this.getCurrentDocument(pm);
        Assert.isTrue((document.getLength() >= region.getOffset() + region.getLength() ? 1 : 0) != 0);
        return this.getContent(document, region, expandRegionToFullLine, surroundingLines);
    }

    public TextEdit getPreviewEdit(TextEdit original) {
        Assert.isTrue((this.getKeepPreviewEdits() && this.fCopier != null && original != null ? 1 : 0) != 0);
        return this.fCopier.getCopy(original);
    }

    public TextEdit[] getPreviewEdits(TextEdit[] originals) {
        Assert.isTrue((this.getKeepPreviewEdits() && this.fCopier != null && originals != null ? 1 : 0) != 0);
        if (originals.length == 0) {
            return new TextEdit[0];
        }
        ArrayList<TextEdit> result = new ArrayList<TextEdit>(originals.length);
        int i = 0;
        while (i < originals.length) {
            TextEdit copy = this.fCopier.getCopy(originals[i]);
            if (copy != null) {
                result.add(copy);
            }
            ++i;
        }
        return result.toArray(new TextEdit[result.size()]);
    }

    public IDocument getPreviewDocument(IProgressMonitor pm) throws CoreException {
        TextEditBasedChange.PreviewAndRegion result = this.getPreviewDocument(ALL_EDITS, pm);
        return result.document;
    }

    public String getPreviewContent(IProgressMonitor pm) throws CoreException {
        return this.getPreviewDocument(pm).get();
    }

    public String getPreviewContent(TextEditChangeGroup[] changeGroups, IRegion region, boolean expandRegionToFullLine, int surroundingLines, IProgressMonitor pm) throws CoreException {
        return this.getPreviewContent((TextEditBasedChangeGroup[])changeGroups, region, expandRegionToFullLine, surroundingLines, pm);
    }

    public String getPreviewContent(TextEditBasedChangeGroup[] changeGroups, IRegion region, boolean expandRegionToFullLine, int surroundingLines, IProgressMonitor pm) throws CoreException {
        IRegion currentRegion = this.getRegion(changeGroups);
        Assert.isTrue((region.getOffset() <= currentRegion.getOffset() && currentRegion.getOffset() + currentRegion.getLength() <= region.getOffset() + region.getLength() ? 1 : 0) != 0);
        TextEdit root = this.getEdit();
        Assert.isNotNull((Object)root, (String)"No root edit");
        int c = 0;
        while (c < changeGroups.length) {
            TextEditBasedChangeGroup group = changeGroups[c];
            TextEdit[] edits = group.getTextEdits();
            int e = 0;
            while (e < edits.length) {
                Assert.isTrue((root == edits[e].getRoot() ? 1 : 0) != 0, (String)"Wrong root edit");
                ++e;
            }
            ++c;
        }
        TextEditBasedChange.PreviewAndRegion result = this.getPreviewDocument(changeGroups, pm);
        int delta = result.region == null ? -currentRegion.getLength() : result.region.getLength() - currentRegion.getLength();
        return this.getContent(result.document, (IRegion)new Region(region.getOffset(), region.getLength() + delta), expandRegionToFullLine, surroundingLines);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TextEditBasedChange.PreviewAndRegion getPreviewDocument(TextEditBasedChangeGroup[] changes, IProgressMonitor pm) throws CoreException {
        Document document = new Document(this.getCurrentDocument(pm).get());
        boolean trackChanges = this.getKeepPreviewEdits();
        this.setKeepPreviewEdits(true);
        TextEditProcessor processor = changes == ALL_EDITS ? this.createTextEditProcessor((IDocument)document, 0, true) : this.createTextEditProcessor((IDocument)document, 0, changes);
        try {
            try {
                processor.performEdits();
                TextEditBasedChange.PreviewAndRegion previewAndRegion = new TextEditBasedChange.PreviewAndRegion((IDocument)document, this.getNewRegion(changes));
                Object var7_7 = null;
                this.setKeepPreviewEdits(trackChanges);
                return previewAndRegion;
            }
            catch (BadLocationException e) {
                throw Changes.asCoreException(e);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.setKeepPreviewEdits(trackChanges);
            throw throwable;
        }
    }

    private TextEditProcessor createTextEditProcessor(IDocument document, int flags, boolean preview) {
        if (this.fEdit == null) {
            return new TextEditProcessor(document, (TextEdit)new MultiTextEdit(0, 0), flags);
        }
        ArrayList<TextEdit> excludes = new ArrayList<TextEdit>(0);
        TextEditBasedChangeGroup[] groups = this.getChangeGroups();
        int index = 0;
        while (index < groups.length) {
            TextEditBasedChangeGroup edit = groups[index];
            if (!edit.isEnabled()) {
                excludes.addAll(Arrays.asList(edit.getTextEditGroup().getTextEdits()));
            }
            ++index;
        }
        if (preview) {
            this.fCopier = new TextEditCopier(this.fEdit);
            TextEdit copiedEdit = this.fCopier.perform();
            boolean keep = this.getKeepPreviewEdits();
            if (keep) {
                flags |= 2;
            }
            TextEditBasedChange.LocalTextEditProcessor result = new TextEditBasedChange.LocalTextEditProcessor(document, copiedEdit, flags);
            result.setExcludes(this.mapEdits(excludes.toArray(new TextEdit[excludes.size()]), this.fCopier));
            if (!keep) {
                this.fCopier = null;
            }
            return result;
        }
        TextEditBasedChange.LocalTextEditProcessor result = new TextEditBasedChange.LocalTextEditProcessor(document, this.fEdit, flags | 2);
        result.setExcludes(excludes.toArray(new TextEdit[excludes.size()]));
        return result;
    }

    private TextEditProcessor createTextEditProcessor(IDocument document, int flags, TextEditBasedChangeGroup[] changes) {
        if (this.fEdit == null) {
            return new TextEditProcessor(document, (TextEdit)new MultiTextEdit(0, 0), flags);
        }
        ArrayList<TextEdit> includes = new ArrayList<TextEdit>(0);
        int c = 0;
        while (c < changes.length) {
            TextEditBasedChangeGroup change = changes[c];
            Assert.isTrue((change.getTextEditChange() == this ? 1 : 0) != 0);
            if (change.isEnabled()) {
                includes.addAll(Arrays.asList(change.getTextEditGroup().getTextEdits()));
            }
            ++c;
        }
        this.fCopier = new TextEditCopier(this.fEdit);
        TextEdit copiedEdit = this.fCopier.perform();
        boolean keep = this.getKeepPreviewEdits();
        if (keep) {
            flags |= 2;
        }
        TextEditBasedChange.LocalTextEditProcessor result = new TextEditBasedChange.LocalTextEditProcessor(document, copiedEdit, flags);
        result.setIncludes(this.mapEdits(includes.toArray(new TextEdit[includes.size()]), this.fCopier));
        if (!keep) {
            this.fCopier = null;
        }
        return result;
    }

    private IRegion getRegion(TextEditBasedChangeGroup[] changes) {
        if (changes == ALL_EDITS) {
            if (this.fEdit == null) {
                return null;
            }
            return this.fEdit.getRegion();
        }
        ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
        int i = 0;
        while (i < changes.length) {
            edits.addAll(Arrays.asList(changes[i].getTextEditGroup().getTextEdits()));
            ++i;
        }
        if (edits.size() == 0) {
            return null;
        }
        return TextEdit.getCoverage((TextEdit[])edits.toArray(new TextEdit[edits.size()]));
    }

    private IRegion getNewRegion(TextEditBasedChangeGroup[] changes) {
        if (changes == ALL_EDITS) {
            if (this.fEdit == null) {
                return null;
            }
            return this.fCopier.getCopy(this.fEdit).getRegion();
        }
        ArrayList<TextEdit> result = new ArrayList<TextEdit>();
        int c = 0;
        while (c < changes.length) {
            TextEdit[] edits = changes[c].getTextEditGroup().getTextEdits();
            int e = 0;
            while (e < edits.length) {
                TextEdit copy = this.fCopier.getCopy(edits[e]);
                if (copy != null) {
                    result.add(copy);
                }
                ++e;
            }
            ++c;
        }
        if (result.size() == 0) {
            return null;
        }
        return TextEdit.getCoverage((TextEdit[])result.toArray(new TextEdit[result.size()]));
    }

    public void setKeepPreviewEdits(boolean keep) {
        super.setKeepPreviewEdits(keep);
        if (!keep) {
            this.fCopier = null;
        }
    }
}

