/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.launching;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.launching.JREContainer;
import org.eclipse.jdt.internal.launching.LaunchingMessages;
import org.eclipse.jdt.internal.launching.LaunchingPlugin;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.LibraryLocation;
import org.eclipse.jdt.launching.VMStandin;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.launching.environments.IExecutionEnvironmentsManager;

public class JREContainerInitializer
extends ClasspathContainerInitializer {
    public void initialize(IPath containerPath, IJavaProject project) throws CoreException {
        int size = containerPath.segmentCount();
        if (size > 0 && containerPath.segment(0).equals(JavaRuntime.JRE_CONTAINER)) {
            IVMInstall vm = JREContainerInitializer.resolveVM(containerPath);
            JREContainer container = null;
            if (vm != null) {
                container = new JREContainer(vm, containerPath);
            }
            JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])new IJavaProject[]{project}, (IClasspathContainer[])new IClasspathContainer[]{container}, null);
        }
    }

    public static IVMInstall resolveVM(IPath containerPath) {
        IVMInstall vm = null;
        if (containerPath.segmentCount() > 1) {
            if (JREContainerInitializer.isExecutionEnvironment(containerPath)) {
                String id = JREContainerInitializer.getExecutionEnvironmentId(containerPath);
                IExecutionEnvironmentsManager manager = JavaRuntime.getExecutionEnvironmentsManager();
                IExecutionEnvironment environment = manager.getEnvironment(id);
                if (environment != null && (vm = environment.getDefaultVM()) == null) {
                    IVMInstall[] installs = environment.getCompatibleVMs();
                    int i = 0;
                    while (i < installs.length) {
                        IVMInstall install = installs[i];
                        if (environment.isStrictlyCompatible(install)) {
                            vm = install;
                            break;
                        }
                        ++i;
                    }
                    if (vm == null && installs.length > 0) {
                        vm = installs[0];
                    }
                }
            } else {
                String vmTypeId = JREContainerInitializer.getVMTypeId(containerPath);
                String vmName = JREContainerInitializer.getVMName(containerPath);
                IVMInstallType vmType = JavaRuntime.getVMInstallType(vmTypeId);
                if (vmType != null) {
                    vm = vmType.findVMInstallByName(vmName);
                }
            }
        } else {
            vm = JavaRuntime.getDefaultVMInstall();
        }
        return vm;
    }

    public static String getExecutionEnvironmentId(IPath path) {
        return path.removeFirstSegments(2).toString();
    }

    public static boolean isExecutionEnvironment(IPath path) {
        return "executionEnvironments".equals(path.segment(1));
    }

    public static String getVMTypeId(IPath path) {
        return path.segment(1);
    }

    public static String getVMName(IPath path) {
        return path.removeFirstSegments(2).toString();
    }

    public boolean canUpdateClasspathContainer(IPath containerPath, IJavaProject project) {
        if (containerPath != null && containerPath.segmentCount() > 0 && JavaRuntime.JRE_CONTAINER.equals(containerPath.segment(0))) {
            return JREContainerInitializer.resolveVM(containerPath) != null;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public void requestClasspathContainerUpdate(IPath containerPath, IJavaProject project, IClasspathContainer containerSuggestion) throws CoreException {
        vm = JREContainerInitializer.resolveVM(containerPath);
        if (vm == null) {
            status = new Status(4, LaunchingPlugin.getUniqueIdentifier(), 105, MessageFormat.format(LaunchingMessages.JREContainerInitializer_JRE_referenced_by_classpath_container__0__does_not_exist__1, new String[]{containerPath.toString()}), null);
            throw new CoreException((IStatus)status);
        }
        entries = containerSuggestion.getClasspathEntries();
        libs = new LibraryLocation[entries.length];
        i = 0;
        while (i < entries.length) {
            entry = entries[i];
            if (entry.getEntryKind() != 1) ** GOTO lbl35
            path = entry.getPath();
            lib = path.toFile();
            if (lib.exists() && lib.isFile()) {
                srcPath = entry.getSourceAttachmentPath();
                if (srcPath == null) {
                    srcPath = Path.EMPTY;
                }
                if ((rootPath = entry.getSourceAttachmentRootPath()) == null) {
                    rootPath = Path.EMPTY;
                }
                javadocLocation = null;
                extraAttributes = entry.getExtraAttributes();
                j = 0;
                while (j < extraAttributes.length) {
                    attribute = extraAttributes[j];
                    if (attribute.getName().equals("javadoc_location") && (url = attribute.getValue()) != null && url.trim().length() > 0) {
                        try {
                            javadocLocation = new URL(url);
                        }
                        catch (MalformedURLException e) {
                            LaunchingPlugin.log(e);
                        }
                    }
                    ++j;
                }
            } else {
                status = new Status(4, LaunchingPlugin.getUniqueIdentifier(), 150, MessageFormat.format(LaunchingMessages.JREContainerInitializer_Classpath_entry__0__does_not_refer_to_an_existing_library__2, new String[]{entry.getPath().toString()}), null);
                throw new CoreException((IStatus)status);
lbl35:
                // 1 sources

                status = new Status(4, LaunchingPlugin.getUniqueIdentifier(), 150, MessageFormat.format(LaunchingMessages.JREContainerInitializer_Classpath_entry__0__does_not_refer_to_a_library__3, new String[]{entry.getPath().toString()}), null);
                throw new CoreException((IStatus)status);
            }
            libs[i] = new LibraryLocation(path, srcPath, rootPath, javadocLocation);
            ++i;
        }
        standin = new VMStandin(vm);
        standin.setLibraryLocations(libs);
        standin.convertToRealVM();
        JavaRuntime.saveVMConfiguration();
    }

    public String getDescription(IPath containerPath, IJavaProject project) {
        String tag = JREContainerInitializer.getExecutionEnvironmentId(containerPath);
        if (tag == null && containerPath.segmentCount() > 2) {
            tag = JREContainerInitializer.getVMName(containerPath);
        }
        if (tag != null) {
            return MessageFormat.format(LaunchingMessages.JREContainer_JRE_System_Library_1, tag);
        }
        return LaunchingMessages.JREContainerInitializer_Default_System_Library_1;
    }
}

