/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.launching;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferenceNodeVisitor;
import org.eclipse.core.runtime.preferences.PreferenceModifyListener;
import org.eclipse.jdt.internal.launching.LaunchingPlugin;
import org.eclipse.jdt.internal.launching.VMDefinitionsContainer;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.osgi.service.prefs.BackingStoreException;

public class JREPreferenceModifyListener
extends PreferenceModifyListener {
    public IEclipsePreferences preApply(IEclipsePreferences node) {
        try {
            JavaRuntime.getVMInstallTypes();
            node.accept((IPreferenceNodeVisitor)new Visitor());
        }
        catch (BackingStoreException e) {
            LaunchingPlugin.log(e);
        }
        return node;
    }

    class Visitor
    implements IPreferenceNodeVisitor {
        Visitor() {
        }

        public boolean visit(IEclipsePreferences node) throws BackingStoreException {
            if (node.name().equals(LaunchingPlugin.getUniqueIdentifier())) {
                String jresXML = node.get(JavaRuntime.PREF_VM_XML, null);
                if (jresXML != null) {
                    VMDefinitionsContainer vms = new VMDefinitionsContainer();
                    String pref = LaunchingPlugin.getDefault().getPluginPreferences().getString(JavaRuntime.PREF_VM_XML);
                    HashSet<String> names = new HashSet<String>();
                    HashSet<File> locations = new HashSet<File>();
                    if (pref.length() > 0) {
                        try {
                            VMDefinitionsContainer container = VMDefinitionsContainer.parseXMLIntoContainer(new ByteArrayInputStream(pref.getBytes()));
                            List validVMList = container.getValidVMList();
                            Iterator iterator = validVMList.iterator();
                            while (iterator.hasNext()) {
                                IVMInstall vm = (IVMInstall)iterator.next();
                                names.add(vm.getName());
                                locations.add(vm.getInstallLocation());
                                vms.addVM(vm);
                            }
                            vms.setDefaultVMInstallCompositeID(container.getDefaultVMInstallCompositeID());
                            vms.setDefaultVMInstallConnectorTypeID(container.getDefaultVMInstallConnectorTypeID());
                        }
                        catch (IOException e) {
                            LaunchingPlugin.log(e);
                            return false;
                        }
                    }
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(jresXML.getBytes());
                    try {
                        VMDefinitionsContainer container = VMDefinitionsContainer.parseXMLIntoContainer(inputStream);
                        List validVMList = container.getValidVMList();
                        Iterator iterator = validVMList.iterator();
                        while (iterator.hasNext()) {
                            IVMInstall vm = (IVMInstall)iterator.next();
                            if (names.contains(vm.getName()) || locations.contains(vm.getInstallLocation())) continue;
                            vms.addVM(vm);
                        }
                        String defaultVMInstallCompositeID = container.getDefaultVMInstallCompositeID();
                        validVMList = vms.getValidVMList();
                        iterator = validVMList.iterator();
                        while (iterator.hasNext()) {
                            IVMInstall vm = (IVMInstall)iterator.next();
                            if (!JavaRuntime.getCompositeIdFromVM(vm).equals(defaultVMInstallCompositeID)) continue;
                            vms.setDefaultVMInstallCompositeID(defaultVMInstallCompositeID);
                            break;
                        }
                    }
                    catch (IOException e) {
                        LaunchingPlugin.log(e);
                        return false;
                    }
                    try {
                        String xml = vms.getAsXML();
                        node.put(JavaRuntime.PREF_VM_XML, xml);
                    }
                    catch (ParserConfigurationException e) {
                        LaunchingPlugin.log(e);
                        return false;
                    }
                    catch (IOException e) {
                        LaunchingPlugin.log(e);
                        return false;
                    }
                    catch (TransformerException e) {
                        LaunchingPlugin.log(e);
                        return false;
                    }
                }
                return false;
            }
            return true;
        }
    }
}

