/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions.context;

import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.internal.ui.actions.context.AbstractDebugContextActionDelegate;
import org.eclipse.debug.internal.ui.contexts.DebugContextManager;
import org.eclipse.debug.internal.ui.contexts.provisional.IDebugContextListener;
import org.eclipse.debug.internal.ui.contexts.provisional.IDebugContextManager;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public abstract class AbstractDebugContextAction
extends Action
implements IDebugContextListener {
    private IStructuredSelection fActiveContext;
    private IWorkbenchSiteProgressService fProgressService = null;
    private DebugRequestJob fRequestJob = null;
    private UpdateEnablementJob fUpdateJob = null;
    private IWorkbenchWindow fWindow;
    private AbstractDebugContextActionDelegate fDelegate;
    static /* synthetic */ Class class$0;

    public AbstractDebugContextAction() {
        String helpContextId = this.getHelpContextId();
        if (helpContextId != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, helpContextId);
        }
        this.setEnabled(false);
    }

    public void setDelegate(AbstractDebugContextActionDelegate delegate) {
        this.fDelegate = delegate;
    }

    protected abstract void doAction(Object var1) throws DebugException;

    public AbstractDebugContextAction(String text) {
        super(text);
    }

    public AbstractDebugContextAction(String text, ImageDescriptor image) {
        super(text, image);
    }

    public AbstractDebugContextAction(String text, int style) {
        super(text, style);
    }

    public void contextActivated(ISelection context, IWorkbenchPart part) {
        if (part != null) {
            IWorkbenchPartSite iWorkbenchPartSite = part.getSite();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.progress.IWorkbenchSiteProgressService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.fProgressService = (IWorkbenchSiteProgressService)iWorkbenchPartSite.getAdapter((Class)clazz);
        } else {
            this.fProgressService = null;
        }
        this.fActiveContext = null;
        if (this.fUpdateJob == null) {
            this.fUpdateJob = new UpdateEnablementJob();
        }
        this.fUpdateJob.setContext(context);
        this.schedule(this.fUpdateJob);
    }

    private void schedule(Job job) {
        if (this.fProgressService == null) {
            job.schedule();
        } else {
            this.fProgressService.schedule(job);
        }
    }

    public void contextChanged(ISelection context, IWorkbenchPart part) {
        this.contextActivated(context, part);
    }

    protected void update(ISelection context) {
        if (context instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)context;
            this.setEnabled(this.getEnableStateForContext(ss));
            this.fActiveContext = (IStructuredSelection)context;
        } else {
            this.setEnabled(false);
            this.fActiveContext = StructuredSelection.EMPTY;
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.fDelegate != null) {
            this.fDelegate.setEnabled(enabled);
        }
    }

    protected boolean getEnableStateForContext(IStructuredSelection selection) {
        if (selection.size() == 0) {
            return false;
        }
        Iterator itr = selection.iterator();
        while (itr.hasNext()) {
            Object element = itr.next();
            Object target = this.getTarget(element);
            if (target != null && this.isEnabledFor(target)) continue;
            return false;
        }
        return true;
    }

    protected Object getTarget(Object selectee) {
        return selectee;
    }

    protected boolean isEnabledFor(Object element) {
        return true;
    }

    public void init(IWorkbenchWindow window) {
        this.setWindow(window);
        IDebugContextManager manager = DebugContextManager.getDefault();
        manager.addDebugContextListener(this, window);
        ISelection activeContext = manager.getActiveContext(window);
        if (activeContext != null) {
            this.contextActivated(activeContext, null);
            try {
                this.fUpdateJob.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected void setWindow(IWorkbenchWindow window) {
        this.fWindow = window;
    }

    protected IStructuredSelection getContext() {
        return this.fActiveContext;
    }

    public void run() {
        IStructuredSelection selection = this.getContext();
        if (selection != null && this.isEnabled()) {
            this.setEnabled(false);
            if (this.fRequestJob == null) {
                this.fRequestJob = new DebugRequestJob();
            }
            this.fRequestJob.setElements(selection.toArray());
            this.schedule(this.fRequestJob);
        }
    }

    public void runWithEvent(Event event) {
        this.run();
    }

    public void dispose() {
        IWorkbenchWindow window = this.getWindow();
        if (this.getWindow() != null) {
            DebugContextManager.getDefault().removeDebugContextListener(this, window);
        }
    }

    protected IWorkbenchWindow getWindow() {
        return this.fWindow;
    }

    protected String getErrorDialogMessage() {
        return null;
    }

    protected String getStatusMessage() {
        return "";
    }

    public abstract String getHelpContextId();

    public abstract String getId();

    public abstract String getText();

    public abstract String getToolTipText();

    public abstract ImageDescriptor getDisabledImageDescriptor();

    public abstract ImageDescriptor getHoverImageDescriptor();

    public abstract ImageDescriptor getImageDescriptor();

    class DebugRequestJob
    extends Job {
        private Object[] fElements = null;

        public DebugRequestJob() {
            super(DebugUIPlugin.removeAccelerators(AbstractDebugContextAction.this.getText()));
            this.setPriority(10);
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            MultiStatus status = new MultiStatus(DebugUIPlugin.getUniqueIdentifier(), 5012, AbstractDebugContextAction.this.getStatusMessage(), null);
            Object[] targets = null;
            DebugRequestJob debugRequestJob = this;
            synchronized (debugRequestJob) {
                targets = this.fElements;
                this.fElements = null;
            }
            int i = 0;
            while (i < targets.length) {
                Object element = targets[i];
                Object target = AbstractDebugContextAction.this.getTarget(element);
                try {
                    if (target != null && AbstractDebugContextAction.this.isEnabledFor(target)) {
                        AbstractDebugContextAction.this.doAction(target);
                    }
                }
                catch (DebugException e) {
                    status.merge(e.getStatus());
                }
                ++i;
            }
            return status;
        }

        protected synchronized void setElements(Object[] elements) {
            this.fElements = elements;
        }
    }

    class UpdateEnablementJob
    extends Job {
        ISelection targetSelection = null;

        public UpdateEnablementJob() {
            super(ActionMessages.AbstractDebugActionDelegate_1);
            this.setPriority(10);
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            ISelection context = null;
            UpdateEnablementJob updateEnablementJob = this;
            synchronized (updateEnablementJob) {
                context = this.targetSelection;
                this.targetSelection = null;
            }
            AbstractDebugContextAction.this.update(context);
            return Status.OK_STATUS;
        }

        protected synchronized void setContext(ISelection context) {
            this.targetSelection = context;
        }
    }
}

