/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions.context;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.internal.ui.actions.context.AbstractDebugContextAction;
import org.eclipse.jface.resource.ImageDescriptor;

public class ResumeAction
extends AbstractDebugContextAction {
    static /* synthetic */ Class class$0;

    protected void doAction(Object object) throws DebugException {
        if (this.isEnabledFor(object)) {
            ISuspendResume resume = (ISuspendResume)object;
            resume.resume();
        } else {
            this.doActionForAllThreads(object);
        }
    }

    protected void doActionForAllThreads(Object object) throws DebugException {
        if (this.isEnabledForAllThreads(object)) {
            IDebugElement debugElement = (IDebugElement)object;
            IThread[] threads = debugElement.getDebugTarget().getThreads();
            int i = 0;
            while (i < threads.length) {
                IThread thread = threads[i];
                if (thread.canResume()) {
                    thread.resume();
                }
                ++i;
            }
        }
    }

    protected boolean isEnabledFor(Object element) {
        return element instanceof ISuspendResume && ((ISuspendResume)element).canResume();
    }

    protected boolean isEnabledForAllThreads(Object element) {
        if (element instanceof IDebugElement) {
            IDebugElement debugElement = (IDebugElement)element;
            try {
                IThread[] threads = debugElement.getDebugTarget().getThreads();
                int i = 0;
                while (i < threads.length) {
                    if (threads[i].canResume()) {
                        return true;
                    }
                    ++i;
                }
            }
            catch (DebugException debugException) {}
        }
        return false;
    }

    protected String getStatusMessage() {
        return ActionMessages.ResumeActionDelegate_Exceptions_occurred_attempting_to_resume__2;
    }

    protected String getErrorDialogMessage() {
        return ActionMessages.ResumeActionDelegate_Resume_failed__1;
    }

    protected Object getTarget(Object selectee) {
        if (selectee instanceof ISuspendResume) {
            return selectee;
        }
        if (selectee instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)selectee;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.debug.core.model.ISuspendResume");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return iAdaptable.getAdapter((Class)clazz);
        }
        return null;
    }

    public String getText() {
        return ActionMessages.ResumeAction_0;
    }

    public String getHelpContextId() {
        return "resume_action_context";
    }

    public String getId() {
        return "org.eclipse.debug.ui.debugview.toolbar.resume";
    }

    public String getToolTipText() {
        return ActionMessages.ResumeAction_3;
    }

    public ImageDescriptor getDisabledImageDescriptor() {
        return DebugPluginImages.getImageDescriptor("IMG_DLCL_RESUME");
    }

    public ImageDescriptor getHoverImageDescriptor() {
        return DebugPluginImages.getImageDescriptor("IMG_ELCL_RESUME");
    }

    public ImageDescriptor getImageDescriptor() {
        return DebugPluginImages.getImageDescriptor("IMG_ELCL_RESUME");
    }
}

