/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions.context;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.internal.ui.actions.RelaunchActionDelegate;
import org.eclipse.debug.internal.ui.actions.context.AbstractDebugContextAction;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.jface.resource.ImageDescriptor;

public class TerminateAndRelaunchAction
extends AbstractDebugContextAction {
    protected void doAction(Object element) throws DebugException {
        final ILaunch launch = RelaunchActionDelegate.getLaunch(element);
        if (launch == null || !(element instanceof ITerminate)) {
            return;
        }
        ((ITerminate)element).terminate();
        DebugUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

            public void run() {
                RelaunchActionDelegate.relaunch(launch.getLaunchConfiguration(), launch.getLaunchMode());
            }
        });
    }

    protected boolean isEnabledFor(Object element) {
        ILaunch launch = RelaunchActionDelegate.getLaunch(element);
        return element instanceof ITerminate && ((ITerminate)element).canTerminate() && launch != null && LaunchConfigurationManager.isVisible(launch.getLaunchConfiguration());
    }

    public String getActionDefinitionId() {
        return ActionMessages.TerminateAndRelaunchAction_0;
    }

    public String getHelpContextId() {
        return "terminate_and_relaunch_action_context";
    }

    public String getId() {
        return "org.eclipse.debug.ui.debugview.popupMenu.TerminateAndRelaunch";
    }

    public String getText() {
        return ActionMessages.TerminateAndRelaunchAction_3;
    }

    public String getToolTipText() {
        return ActionMessages.TerminateAndRelaunchAction_4;
    }

    public ImageDescriptor getDisabledImageDescriptor() {
        return DebugPluginImages.getImageDescriptor("IMG_DLCL_TERMINATE_AND_RELAUNCH");
    }

    public ImageDescriptor getHoverImageDescriptor() {
        return DebugPluginImages.getImageDescriptor("IMG_ELCL_TERMINATE_AND_RELAUNCH");
    }

    public ImageDescriptor getImageDescriptor() {
        return DebugPluginImages.getImageDescriptor("IMG_ELCL_TERMINATE_AND_RELAUNCH");
    }
}

