/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.elements.adapters;

import java.math.BigInteger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.viewers.provisional.AsynchronousLabelAdapter;
import org.eclipse.debug.internal.ui.viewers.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.views.launch.DebugElementHelper;
import org.eclipse.debug.internal.ui.views.memory.renderings.AbstractAsyncTableRendering;
import org.eclipse.debug.internal.ui.views.memory.renderings.AbstractBaseTableRendering;
import org.eclipse.debug.internal.ui.views.memory.renderings.MemorySegment;
import org.eclipse.debug.internal.ui.views.memory.renderings.TableRenderingContentDescriptor;
import org.eclipse.debug.internal.ui.views.memory.renderings.TableRenderingPresentationContext;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.debug.ui.memory.IMemoryBlockTablePresentation;
import org.eclipse.debug.ui.memory.MemoryRenderingElement;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;

public class MemorySegmentLabelAdapter
extends AsynchronousLabelAdapter {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    protected String[] getLabels(Object element, IPresentationContext context) throws CoreException {
        TableRenderingPresentationContext tableRenderingContext;
        if (context instanceof TableRenderingPresentationContext && (tableRenderingContext = (TableRenderingPresentationContext)context).getTableRendering() != null) {
            AbstractAsyncTableRendering tableRendering = tableRenderingContext.getTableRendering();
            String addressStr = this.getColumnText(element, 0, tableRendering, tableRenderingContext.getContentDescriptor());
            int numColumns = tableRendering.getAddressableUnitPerLine() / tableRendering.getAddressableUnitPerColumn();
            String[] labels = new String[numColumns + 2];
            labels[0] = addressStr;
            int i = 0;
            while (i <= numColumns) {
                labels[i + 1] = this.getColumnText(element, i + 1, tableRendering, tableRenderingContext.getContentDescriptor());
                ++i;
            }
            labels[labels.length - 1] = "";
            return labels;
        }
        return new String[0];
    }

    private String getColumnText(Object element, int columnIndex, AbstractAsyncTableRendering tableRendering, TableRenderingContentDescriptor descriptor) {
        String columnLabel = null;
        if (columnIndex == 0) {
            String rowLabel;
            IMemoryBlockTablePresentation presentation;
            IMemoryBlock iMemoryBlock = tableRendering.getMemoryBlock();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.debug.ui.memory.IMemoryBlockTablePresentation");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((presentation = (IMemoryBlockTablePresentation)iMemoryBlock.getAdapter((Class)clazz)) != null && (rowLabel = presentation.getRowLabel(tableRendering.getMemoryBlock(), ((MemorySegment)((Object)element)).getAddress())) != null) {
                return rowLabel;
            }
            columnLabel = ((MemorySegment)((Object)element)).getAddress().toString(16).toUpperCase();
            int addressSize = descriptor.getAddressSize();
            int prefillLength = addressSize * 2 - columnLabel.length();
            StringBuffer buf = new StringBuffer();
            if (prefillLength > 0) {
                int i = 0;
                while (i < prefillLength) {
                    buf.append("0");
                    ++i;
                }
            }
            buf.append(columnLabel);
            return buf.toString();
        }
        if (columnIndex > tableRendering.getBytesPerLine() / tableRendering.getBytesPerColumn()) {
            columnLabel = " ";
        } else {
            String label;
            MemoryRenderingElement renderingElement;
            ILabelProvider labelProvider;
            MemorySegment segment;
            if (element instanceof MemorySegment && (segment = (MemorySegment)((Object)element)).getBytes().length != tableRendering.getBytesPerLine()) {
                return "";
            }
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.jface.viewers.ILabelProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((labelProvider = (ILabelProvider)tableRendering.getAdapter(clazz)) != null && columnIndex > 0 && (renderingElement = this.getMemoryRenderingElement(element, columnIndex, tableRendering)) != null && (label = labelProvider.getText((Object)renderingElement)) != null) {
                return label;
            }
            int start = (columnIndex - 1) * tableRendering.getBytesPerColumn();
            MemoryByte[] bytes = ((MemorySegment)((Object)element)).getBytes(start, tableRendering.getBytesPerColumn());
            BigInteger address = ((MemorySegment)((Object)element)).getAddress();
            address = address.add(BigInteger.valueOf(start));
            columnLabel = tableRendering.getString(tableRendering.getRenderingId(), address, bytes);
        }
        return columnLabel;
    }

    protected ImageDescriptor[] getImageDescriptors(Object element, IPresentationContext context) throws CoreException {
        TableRenderingPresentationContext tableRenderingContext;
        if (context instanceof TableRenderingPresentationContext && (tableRenderingContext = (TableRenderingPresentationContext)context).getTableRendering() != null) {
            AbstractAsyncTableRendering tableRendering = tableRenderingContext.getTableRendering();
            int numColumns = tableRendering.getAddressableUnitPerLine() / tableRendering.getAddressableUnitPerColumn();
            ImageDescriptor[] images = new ImageDescriptor[numColumns + 2];
            int i = 0;
            while (i <= numColumns) {
                images[i] = this.getColumnImageDescriptor(element, i, tableRendering);
                ++i;
            }
            images[images.length - 1] = null;
            return images;
        }
        return new ImageDescriptor[0];
    }

    private ImageDescriptor getColumnImageDescriptor(Object element, int columnIndex, AbstractAsyncTableRendering tableRendering) {
        if (columnIndex == 0) {
            return DebugPluginImages.getImageDescriptor("IMG_OBJECT_MEMORY");
        }
        if (element instanceof MemorySegment) {
            Image image;
            MemoryRenderingElement renderingElement;
            ILabelProvider labelProvider;
            MemorySegment segment = (MemorySegment)((Object)element);
            if (segment.getBytes().length != tableRendering.getBytesPerLine()) {
                return null;
            }
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.jface.viewers.ILabelProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((labelProvider = (ILabelProvider)tableRendering.getAdapter(clazz)) != null && columnIndex > 0 && (renderingElement = this.getMemoryRenderingElement(element, columnIndex, tableRendering)) != null && (image = labelProvider.getImage((Object)renderingElement)) != null) {
                return DebugElementHelper.getImageDescriptor(image);
            }
            int start = (columnIndex - 1) * tableRendering.getBytesPerColumn();
            MemoryByte[] bytes = ((MemorySegment)((Object)element)).getBytes(start, tableRendering.getBytesPerColumn());
            boolean allKnown = true;
            boolean unchanged = true;
            int i = 0;
            while (i < bytes.length) {
                if (!bytes[i].isHistoryKnown()) {
                    allKnown = false;
                }
                if (bytes[i].isChanged()) {
                    unchanged = false;
                }
                ++i;
            }
            if (allKnown && !unchanged) {
                return DebugPluginImages.getImageDescriptor("IMG_OBJECT_MEMORY_CHANGED");
            }
        }
        return DebugPluginImages.getImageDescriptor("IMG_OBJECT_MEMORY");
    }

    protected FontData[] getFontDatas(Object element, IPresentationContext context) throws CoreException {
        TableRenderingPresentationContext tableRenderingContext;
        if (context instanceof TableRenderingPresentationContext && (tableRenderingContext = (TableRenderingPresentationContext)context).getTableRendering() != null) {
            AbstractAsyncTableRendering tableRendering = tableRenderingContext.getTableRendering();
            int numColumns = tableRendering.getAddressableUnitPerLine() / tableRendering.getAddressableUnitPerColumn();
            FontData[] fontData = new FontData[numColumns + 2];
            int i = 0;
            while (i < fontData.length - 1) {
                fontData[i] = this.getColumnFontData(element, i, tableRendering);
                ++i;
            }
            return fontData;
        }
        return new FontData[0];
    }

    private FontData getColumnFontData(Object element, int columnIndex, AbstractAsyncTableRendering tableRendering) {
        if (element instanceof MemorySegment) {
            Font font;
            MemoryRenderingElement renderingElement;
            IFontProvider fontProvider;
            MemorySegment segment = (MemorySegment)((Object)element);
            if (segment.getBytes().length != tableRendering.getBytesPerLine()) {
                return null;
            }
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.jface.viewers.IFontProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((fontProvider = (IFontProvider)tableRendering.getAdapter(clazz)) != null && columnIndex > 0 && (renderingElement = this.getMemoryRenderingElement(element, columnIndex, tableRendering)) != null && (font = fontProvider.getFont((Object)renderingElement)) != null) {
                return font.getFontData()[0];
            }
        }
        return null;
    }

    protected RGB[] getForegrounds(Object element, IPresentationContext context) throws CoreException {
        TableRenderingPresentationContext tableRenderingContext;
        if (context instanceof TableRenderingPresentationContext && (tableRenderingContext = (TableRenderingPresentationContext)context).getTableRendering() != null) {
            AbstractAsyncTableRendering tableRendering = tableRenderingContext.getTableRendering();
            int numColumns = tableRendering.getAddressableUnitPerLine() / tableRendering.getAddressableUnitPerColumn();
            RGB[] colors = new RGB[numColumns + 2];
            int i = 0;
            while (i < colors.length - 1) {
                colors[i] = this.getColumnForeground(element, i, tableRendering);
                ++i;
            }
            colors[colors.length - 1] = null;
            return colors;
        }
        return new RGB[0];
    }

    private RGB getColumnBackground(Object element, int columnIndex, AbstractAsyncTableRendering tableRendering) {
        if (columnIndex == 0) {
            return null;
        }
        if (element instanceof MemorySegment) {
            Color color;
            MemoryRenderingElement renderingElement;
            IColorProvider colorProvider;
            MemorySegment segment = (MemorySegment)((Object)element);
            if (segment.getBytes().length != tableRendering.getBytesPerLine()) {
                return null;
            }
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("org.eclipse.jface.viewers.IColorProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((colorProvider = (IColorProvider)tableRendering.getAdapter(clazz)) != null && columnIndex > 0 && (renderingElement = this.getMemoryRenderingElement(element, columnIndex, tableRendering)) != null && (color = colorProvider.getBackground((Object)renderingElement)) != null) {
                return color.getRGB();
            }
        }
        return null;
    }

    private RGB getColumnForeground(Object element, int columnIndex, AbstractAsyncTableRendering tableRendering) {
        if (columnIndex == 0) {
            return null;
        }
        if (element instanceof MemorySegment) {
            Color color;
            MemoryRenderingElement renderingElement;
            IColorProvider colorProvider;
            MemorySegment segment = (MemorySegment)((Object)element);
            if (segment.getBytes().length != tableRendering.getBytesPerLine()) {
                return null;
            }
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("org.eclipse.jface.viewers.IColorProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((colorProvider = (IColorProvider)tableRendering.getAdapter(clazz)) != null && columnIndex > 0 && (renderingElement = this.getMemoryRenderingElement(element, columnIndex, tableRendering)) != null && (color = colorProvider.getForeground((Object)renderingElement)) != null) {
                return color.getRGB();
            }
            int start = (columnIndex - 1) * tableRendering.getBytesPerColumn();
            MemoryByte[] bytes = segment.getBytes(start, tableRendering.getBytesPerColumn());
            boolean allKnown = true;
            boolean unchanged = true;
            int i = 0;
            while (i < bytes.length) {
                if (!bytes[i].isHistoryKnown()) {
                    allKnown = false;
                }
                if (bytes[i].isChanged()) {
                    unchanged = false;
                }
                ++i;
            }
            if (allKnown) {
                if (!unchanged) {
                    return DebugUIPlugin.getPreferenceColor("org.eclipse.debug.ui.changedDebugElement").getRGB();
                }
                return DebugUIPlugin.getPreferenceColor(IDebugUIConstants.PREF_MEMORY_HISTORY_KNOWN_COLOR).getRGB();
            }
            return DebugUIPlugin.getPreferenceColor(IDebugUIConstants.PREF_MEMORY_HISTORY_UNKNOWN_COLOR).getRGB();
        }
        return null;
    }

    protected RGB[] getBackgrounds(Object element, IPresentationContext context) throws CoreException {
        TableRenderingPresentationContext tableRenderingContext;
        if (context instanceof TableRenderingPresentationContext && (tableRenderingContext = (TableRenderingPresentationContext)context).getTableRendering() != null) {
            AbstractAsyncTableRendering tableRendering = tableRenderingContext.getTableRendering();
            int numColumns = tableRendering.getAddressableUnitPerLine() / tableRendering.getAddressableUnitPerColumn();
            RGB[] colors = new RGB[numColumns + 2];
            int i = 0;
            while (i < colors.length - 1) {
                colors[i] = this.getColumnBackground(element, i, tableRendering);
                ++i;
            }
            colors[colors.length - 1] = null;
            return colors;
        }
        return new RGB[0];
    }

    private MemoryRenderingElement getMemoryRenderingElement(Object element, int columnIndex, AbstractBaseTableRendering rendering) {
        if (element instanceof MemorySegment) {
            MemorySegment line = (MemorySegment)((Object)element);
            BigInteger address = line.getAddress();
            int offset = (columnIndex - 1) * rendering.getBytesPerColumn();
            if (offset < rendering.getBytesPerLine() && offset + rendering.getBytesPerColumn() <= rendering.getBytesPerLine()) {
                return this.getMemoryRenderingElement(line, address, offset, rendering);
            }
        }
        return null;
    }

    private MemoryRenderingElement getMemoryRenderingElement(MemorySegment line, BigInteger lineAddress, int offset, AbstractBaseTableRendering rendering) {
        BigInteger cellAddress = lineAddress.add(BigInteger.valueOf(offset));
        MemoryByte[] bytes = line.getBytes(offset, rendering.getBytesPerColumn());
        MemoryByte[] copy = new MemoryByte[bytes.length];
        System.arraycopy(bytes, 0, copy, 0, bytes.length);
        MemoryRenderingElement renderingElement = new MemoryRenderingElement(rendering, cellAddress, copy);
        return renderingElement;
    }
}

