/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.elements.adapters;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.internal.ui.InstructionPointerManager;
import org.eclipse.debug.internal.ui.contexts.provisional.ISourceDisplayAdapter;
import org.eclipse.debug.internal.ui.sourcelookup.SourceLookupResult;
import org.eclipse.debug.internal.ui.views.launch.DecorationManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.sourcelookup.ISourceLookupResult;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.progress.UIJob;

public class StackFrameSourceDisplayAdapter
implements ISourceDisplayAdapter {
    private IStackFrame fPrevFrame;
    private SourceLookupResult fPrevResult;

    public StackFrameSourceDisplayAdapter() {
        DebugPlugin.getDefault().addDebugEventListener(new IDebugEventSetListener(){

            public void handleDebugEvents(DebugEvent[] events) {
                int i = 0;
                while (i < events.length) {
                    DebugEvent event = events[i];
                    switch (event.getKind()) {
                        case 1: 
                        case 8: {
                            if (event.isEvaluation()) break;
                            StackFrameSourceDisplayAdapter.this.clearSourceSelection(event.getSource());
                        }
                    }
                    ++i;
                }
            }
        });
    }

    public synchronized void displaySource(Object context, IWorkbenchPage page, boolean force) {
        IStackFrame frame = (IStackFrame)context;
        if (!force && frame.equals(this.fPrevFrame)) {
            this.fPrevResult.updateArtifact(context);
            new SourceDisplayJob(this.fPrevResult, page).schedule();
        } else {
            new SourceLookupJob(frame, frame.getLaunch().getSourceLocator(), page).schedule();
        }
    }

    private void clearSourceSelection(Object source) {
        if (source instanceof IThread) {
            IThread thread = (IThread)source;
            DecorationManager.removeDecorations(thread);
            InstructionPointerManager.getDefault().removeAnnotations(thread);
        } else if (source instanceof IDebugTarget) {
            IDebugTarget target = (IDebugTarget)source;
            DecorationManager.removeDecorations(target);
            InstructionPointerManager.getDefault().removeAnnotations(target);
        }
    }

    class SourceLookupJob
    extends Job {
        private IStackFrame fTarget;
        private ISourceLocator fLocator;
        private IWorkbenchPage fPage;

        public SourceLookupJob(IStackFrame frame, ISourceLocator locator, IWorkbenchPage page) {
            super("Debug Source Lookup");
            this.setPriority(10);
            this.setSystem(true);
            this.fTarget = frame;
            this.fLocator = locator;
            this.fPage = page;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            if (!monitor.isCanceled()) {
                ISourceLookupResult result = null;
                result = DebugUITools.lookupSource(this.fTarget, this.fLocator);
                StackFrameSourceDisplayAdapter stackFrameSourceDisplayAdapter = StackFrameSourceDisplayAdapter.this;
                synchronized (stackFrameSourceDisplayAdapter) {
                    StackFrameSourceDisplayAdapter.this.fPrevResult = (SourceLookupResult)result;
                    StackFrameSourceDisplayAdapter.this.fPrevFrame = this.fTarget;
                }
                if (!monitor.isCanceled()) {
                    SourceDisplayJob job = new SourceDisplayJob(result, this.fPage);
                    job.schedule();
                }
            }
            return Status.OK_STATUS;
        }
    }

    class SourceDisplayJob
    extends UIJob {
        private ISourceLookupResult fResult;
        private IWorkbenchPage fPage;

        public SourceDisplayJob(ISourceLookupResult result, IWorkbenchPage page) {
            super("Debug Source Display");
            this.setSystem(true);
            this.setPriority(10);
            this.fResult = result;
            this.fPage = page;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (!monitor.isCanceled()) {
                DebugUITools.displaySource(this.fResult, this.fPage);
            }
            return Status.OK_STATUS;
        }
    }
}

