/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.importexport.breakpoints;

import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointContainer;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointsContentProvider;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointsLabelProvider;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointsSorter;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointsView;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointsViewer;
import org.eclipse.debug.internal.ui.views.breakpoints.IBreakpointOrganizer;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewPart;

public class EmbeddedBreakpointsViewer {
    private IStructuredSelection fSelection = null;
    private BreakpointsView fView = null;
    private BreakpointsContentProvider fProvider = null;
    private Tree fTree = null;
    private BreakpointsViewer fViewer = null;
    private ICheckStateListener fCheckListener = new ICheckStateListener(){

        public void checkStateChanged(CheckStateChangedEvent event) {
            EmbeddedBreakpointsViewer.this.updateCheckedState(event.getElement(), event.getChecked());
        }
    };
    private static final int HEIGHT_HINT = 150;

    public EmbeddedBreakpointsViewer(Composite parent, Object input) {
        Assert.isNotNull((Object)parent);
        Assert.isNotNull((Object)input);
        this.createControl(parent, input, null);
    }

    public EmbeddedBreakpointsViewer(Composite parent, Object input, IStructuredSelection selection) {
        Assert.isNotNull((Object)parent);
        Assert.isNotNull((Object)input);
        this.createControl(parent, input, selection);
    }

    private void createControl(Composite parent, Object input, IStructuredSelection selection) {
        this.fSelection = selection;
        if (this.fSelection == null) {
            IViewPart fViewpart = DebugUIPlugin.getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.debug.ui.BreakpointView");
            this.fSelection = fViewpart != null ? (IStructuredSelection)fViewpart.getViewSite().getSelectionProvider().getSelection() : new StructuredSelection();
        }
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        GridData grid = new GridData(1808);
        grid.heightHint = 150;
        composite.setLayoutData((Object)grid);
        composite.setFont(font);
        this.fTree = new Tree(composite, 2850);
        this.fProvider = new BreakpointsContentProvider();
        this.fView = (BreakpointsView)DebugUIPlugin.getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.debug.ui.BreakpointView");
        this.fTree.setLayoutData((Object)new GridData(1808));
        this.fViewer = new BreakpointsViewer(this.fTree);
        BreakpointsLabelProvider labelProvider = null;
        labelProvider = this.fView == null ? new BreakpointsLabelProvider() : this.fView.getCheckboxViewer().getLabelProvider();
        this.fViewer.setSorter(new BreakpointsSorter());
        this.fViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.fViewer.addCheckStateListener(this.fCheckListener);
        IBreakpointOrganizer[] orgs = null;
        if (this.fView != null) {
            orgs = this.fView.getBreakpointOrganizers();
        }
        this.fViewer.setContentProvider((IContentProvider)this.fProvider);
        this.fViewer.setInput(input);
        this.fProvider.setOrganizers(orgs);
        this.initViewerState();
    }

    private void initViewerState() {
        Object[] items = this.fSelection.toArray();
        this.fViewer.setGrayedElements(new Object[0]);
        this.fViewer.setCheckedElements(new Object[0]);
        ArrayList<Object> list = new ArrayList<Object>();
        int i = 0;
        while (i < items.length) {
            if (items[i] instanceof IBreakpoint) {
                list.add(items[i]);
            } else {
                this.getBreakpointsFromContainers((BreakpointContainer)((Object)items[i]), list);
            }
            ++i;
        }
        i = 0;
        while (i < list.size()) {
            this.updateCheckedState(list.get(i), true);
            ++i;
        }
    }

    private void getBreakpointsFromContainers(BreakpointContainer container, ArrayList list) {
        Object[] elements = container.getChildren();
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof IBreakpoint) {
                list.add(elements[i]);
            } else {
                this.getBreakpointsFromContainers((BreakpointContainer)((Object)elements[i]), list);
            }
            ++i;
        }
    }

    public IStructuredSelection getCheckedElements() {
        Object[] list = this.fViewer.getCheckedElements();
        Vector<Object> selected = new Vector<Object>();
        int i = 0;
        while (i < list.length) {
            if (!selected.contains(list[i])) {
                selected.addElement(list[i]);
            }
            ++i;
        }
        return new StructuredSelection(selected);
    }

    public BreakpointsViewer getViewer() {
        return this.fViewer;
    }

    private Widget[] searchItems(Object element) {
        ArrayList list = new ArrayList();
        TreeItem[] items = this.fTree.getItems();
        int i = 0;
        while (i < items.length) {
            this.findAllOccurrences(items[i], element, list);
            ++i;
        }
        return list.toArray(new Widget[0]);
    }

    private void findAllOccurrences(TreeItem item, Object element, ArrayList list) {
        if (element.equals(item.getData())) {
            list.add(item);
        }
        TreeItem[] items = item.getItems();
        int i = 0;
        while (i < items.length) {
            this.findAllOccurrences(items[i], element, list);
            ++i;
        }
    }

    private void updateCheckedState(Object obj, boolean enable) {
        block3: {
            block2: {
                if (!(obj instanceof IBreakpoint)) break block2;
                Widget[] list = this.searchItems(obj);
                TreeItem item = null;
                int i = 0;
                while (i < list.length) {
                    item = (TreeItem)list[i];
                    item.setChecked(enable);
                    this.refreshParents(item);
                    ++i;
                }
                break block3;
            }
            if (!(obj instanceof BreakpointContainer)) break block3;
            ArrayList bps = new ArrayList();
            this.getBreakpointsFromContainers((BreakpointContainer)((Object)obj), bps);
            int j = 0;
            while (j < bps.size()) {
                this.updateCheckedState(bps.get(j), enable);
                ++j;
            }
        }
    }

    private void refreshParents(TreeItem item) {
        TreeItem parent = item.getParentItem();
        while (parent != null) {
            int checked = this.getNumberChildrenChecked(parent);
            if (checked == 0) {
                parent.setGrayed(false);
                parent.setChecked(false);
            } else if (checked == parent.getItemCount()) {
                if (this.getNumberChildrenGrayed(parent) > 0) {
                    parent.setGrayed(true);
                } else {
                    parent.setGrayed(false);
                }
                parent.setChecked(true);
            } else {
                parent.setGrayed(true);
                parent.setChecked(true);
            }
            parent = parent.getParentItem();
        }
    }

    private int getNumberChildrenGrayed(TreeItem parent) {
        TreeItem[] children = parent.getItems();
        int count = 0;
        int i = 0;
        while (i < children.length) {
            if (children[i].getGrayed()) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    private int getNumberChildrenChecked(TreeItem parent) {
        TreeItem[] children = parent.getItems();
        int count = 0;
        int i = 0;
        while (i < children.length) {
            if (children[i].getChecked()) {
                ++count;
            }
            ++i;
        }
        return count;
    }
}

