/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsDialog;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.progress.WorkbenchJob;

public class LaunchConfigurationFilteredTree
extends FilteredTree {
    private final ILaunchConfigurationDialog fDialog = LaunchConfigurationsDialog.getCurrentlyVisibleLaunchConfigurationDialog();
    private Job fRefreshJob;

    public LaunchConfigurationFilteredTree(Composite parent, int treeStyle, PatternFilter filter) {
        super(parent, treeStyle, filter);
        this.createRefreshJob();
    }

    private void createRefreshJob() {
        this.fRefreshJob = new WorkbenchJob("Refresh Filter"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (!LaunchConfigurationFilteredTree.this.treeViewer.getControl().isDisposed()) {
                    boolean initial;
                    String text = LaunchConfigurationFilteredTree.this.getFilterString();
                    if (text == null) {
                        return Status.OK_STATUS;
                    }
                    boolean bl = initial = LaunchConfigurationFilteredTree.this.initialText != null && LaunchConfigurationFilteredTree.this.initialText.equals(text);
                    if (initial) {
                        LaunchConfigurationFilteredTree.this.getPatternFilter().setPattern(null);
                    } else {
                        LaunchConfigurationFilteredTree.this.getPatternFilter().setPattern(text);
                    }
                    boolean update = text.length() > 0 && !initial;
                    LaunchConfigurationFilteredTree.this.updateToolbar(update);
                    LaunchConfigurationFilteredTree.this.treeViewer.refresh(true);
                    if (LaunchConfigurationFilteredTree.this.fDialog != null && LaunchConfigurationFilteredTree.this.fDialog instanceof LaunchConfigurationsDialog) {
                        LaunchConfigurationFilteredTree.this.treeViewer.expandAll();
                        ((LaunchConfigurationsDialog)LaunchConfigurationFilteredTree.this.fDialog).refreshFilteringLabel();
                    }
                    return Status.OK_STATUS;
                }
                return Status.CANCEL_STATUS;
            }
        };
        this.fRefreshJob.setSystem(true);
    }

    protected void textChanged() {
        if (this.fRefreshJob != null) {
            this.fRefreshJob.schedule();
        }
    }
}

