/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.IDebugHelpContextIds;
import org.eclipse.debug.internal.ui.launchConfigurations.CreateLaunchConfigurationAction;
import org.eclipse.debug.internal.ui.launchConfigurations.DeleteLaunchConfigurationAction;
import org.eclipse.debug.internal.ui.launchConfigurations.DuplicateLaunchConfigurationAction;
import org.eclipse.debug.internal.ui.launchConfigurations.FilterLaunchConfigurationAction;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationFilteredTree;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationPresentationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationTreeContentProvider;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchGroupExtension;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchGroupFilter;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IContext;
import org.eclipse.help.IContextProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.model.WorkbenchViewerSorter;

public class LaunchConfigurationView
extends AbstractDebugView
implements ILaunchConfigurationListener {
    private Viewer fViewer;
    private LaunchConfigurationFilteredTree fTree;
    private ILaunchManager fLaunchManager = DebugPlugin.getDefault().getLaunchManager();
    private LaunchGroupExtension fLaunchGroup;
    private CreateLaunchConfigurationAction fCreateAction;
    private DeleteLaunchConfigurationAction fDeleteAction;
    private DuplicateLaunchConfigurationAction fDuplicateAction;
    private FilterLaunchConfigurationAction fFilterAction;
    private boolean fAutoSelect = true;
    static /* synthetic */ Class class$0;

    public LaunchConfigurationView(LaunchGroupExtension launchGroup) {
        this.fLaunchGroup = launchGroup;
    }

    protected LaunchGroupExtension getLaunchGroup() {
        return this.fLaunchGroup;
    }

    protected Viewer createViewer(Composite parent) {
        this.fTree = new LaunchConfigurationFilteredTree(parent, 770, new PatternFilter());
        this.fTree.setBackground(new Color((Device)parent.getDisplay(), 255, 255, 255));
        TreeViewer treeViewer = this.fTree.getViewer();
        treeViewer.setLabelProvider((IBaseLabelProvider)DebugUITools.newDebugModelPresentation());
        treeViewer.setSorter((ViewerSorter)new WorkbenchViewerSorter());
        treeViewer.setContentProvider((IContentProvider)new LaunchConfigurationTreeContentProvider(this.fLaunchGroup.getMode(), parent.getShell()));
        treeViewer.addFilter((ViewerFilter)new LaunchGroupFilter(this.getLaunchGroup()));
        treeViewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        treeViewer.expandAll();
        treeViewer.getControl().addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent evt) {
                LaunchConfigurationView.this.handleHelpRequest(evt);
            }
        });
        this.getLaunchManager().addLaunchConfigurationListener((ILaunchConfigurationListener)this);
        return treeViewer;
    }

    protected void handleHelpRequest(HelpEvent evt) {
        if (this.getTreeViewer().getTree() != evt.getSource()) {
            return;
        }
        String id = this.computeContextId();
        if (id != null) {
            PlatformUI.getWorkbench().getHelpSystem().displayHelp(id);
        }
    }

    public Object getAdapter(Class key) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.help.IContextProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key == clazz) {
            return new IContextProvider(){

                public int getContextChangeMask() {
                    return 1;
                }

                public IContext getContext(Object target) {
                    String id = LaunchConfigurationView.this.computeContextId();
                    if (id != null) {
                        return HelpSystem.getContext((String)id);
                    }
                    return null;
                }

                public String getSearchExpression(Object target) {
                    return null;
                }
            };
        }
        return super.getAdapter(key);
    }

    public Text getFilteringTextControl() {
        return this.fTree.getFilterControl();
    }

    private String computeContextId() {
        try {
            ISelection selection = this.getViewer().getSelection();
            if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
                String helpContextId;
                IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                Object firstSelected = structuredSelection.getFirstElement();
                ILaunchConfigurationType configType = null;
                if (firstSelected instanceof ILaunchConfigurationType) {
                    configType = (ILaunchConfigurationType)firstSelected;
                } else if (firstSelected instanceof ILaunchConfiguration) {
                    configType = ((ILaunchConfiguration)firstSelected).getType();
                }
                if (configType != null && (helpContextId = LaunchConfigurationPresentationManager.getDefault().getHelpContext(configType, this.getLaunchGroup().getMode())) != null) {
                    return helpContextId;
                }
            }
        }
        catch (CoreException ce) {
            DebugUIPlugin.log(ce);
        }
        return null;
    }

    protected void createActions() {
        this.fCreateAction = new CreateLaunchConfigurationAction(this.getViewer(), this.getLaunchGroup().getMode());
        this.setAction(CreateLaunchConfigurationAction.ID_CREATE_ACTION, (IAction)this.fCreateAction);
        this.fDeleteAction = new DeleteLaunchConfigurationAction(this.getViewer(), this.getLaunchGroup().getMode());
        this.setAction(DeleteLaunchConfigurationAction.ID_DELETE_ACTION, (IAction)this.fDeleteAction);
        this.setAction("Remove_ActionId", (IAction)this.fDeleteAction);
        this.fDuplicateAction = new DuplicateLaunchConfigurationAction(this.getViewer(), this.getLaunchGroup().getMode());
        this.setAction(DuplicateLaunchConfigurationAction.ID_DUPLICATE_ACTION, (IAction)this.fDuplicateAction);
        this.fFilterAction = new FilterLaunchConfigurationAction();
        this.setAction(FilterLaunchConfigurationAction.ID_FILTER_ACTION, (IAction)this.fFilterAction);
    }

    protected String getHelpContextId() {
        return IDebugHelpContextIds.LAUNCH_CONFIGURATION_VIEW;
    }

    protected void fillContextMenu(IMenuManager menu) {
        menu.add((IAction)this.fCreateAction);
        menu.add((IAction)this.fDuplicateAction);
        menu.add((IAction)this.fDeleteAction);
        menu.add((IContributionItem)new Separator());
    }

    protected void configureToolBar(IToolBarManager tbm) {
    }

    protected TreeViewer getTreeViewer() {
        return (TreeViewer)this.getViewer();
    }

    public void dispose() {
        this.fCreateAction.dispose();
        this.fDeleteAction.dispose();
        this.fDuplicateAction.dispose();
        this.fFilterAction = null;
        this.getLaunchManager().removeLaunchConfigurationListener((ILaunchConfigurationListener)this);
    }

    public void launchConfigurationAdded(final ILaunchConfiguration configuration) {
        try {
            if (configuration.getAttribute(IDebugUIConstants.ATTR_PRIVATE, false)) {
                return;
            }
        }
        catch (CoreException e) {
            DebugUIPlugin.log(e);
            return;
        }
        Display display = DebugUIPlugin.getStandardDisplay();
        if (display.getThread() == Thread.currentThread()) {
            this.handleConfigurationAdded(configuration);
        } else {
            display.asyncExec(new Runnable(){

                public void run() {
                    LaunchConfigurationView.this.handleConfigurationAdded(configuration);
                }
            });
        }
    }

    private void handleConfigurationAdded(ILaunchConfiguration configuration) {
        TreeViewer viewer = this.getTreeViewer();
        if (viewer != null) {
            try {
                viewer.add((Object)configuration.getType(), (Object)configuration);
                ILaunchConfiguration from = this.getLaunchManager().getMovedFrom(configuration);
                if (from != null) {
                    viewer.remove((Object)from);
                }
                if (this.isAutoSelect()) {
                    viewer.setSelection((ISelection)new StructuredSelection((Object)configuration), true);
                }
            }
            catch (CoreException coreException) {}
        }
    }

    public void launchConfigurationChanged(ILaunchConfiguration configuration) {
    }

    public void launchConfigurationRemoved(final ILaunchConfiguration configuration) {
        ILaunchConfiguration to = this.getLaunchManager().getMovedTo(configuration);
        if (to != null) {
            return;
        }
        Display display = DebugUIPlugin.getStandardDisplay();
        if (display.getThread() == Thread.currentThread()) {
            this.handleConfigurationRemoved(configuration);
        } else {
            display.asyncExec(new Runnable(){

                public void run() {
                    LaunchConfigurationView.this.handleConfigurationRemoved(configuration);
                }
            });
        }
    }

    private void handleConfigurationRemoved(ILaunchConfiguration configuration) {
        ILaunchConfigurationType type = null;
        TreeViewer viewer = this.getTreeViewer();
        int typeIndex = -1;
        int configIndex = -1;
        TreeItem[] items = viewer.getTree().getItems();
        int i = 0;
        int numTypes = items.length;
        while (i < numTypes && type == null) {
            TreeItem typeItem = items[i];
            typeIndex = i;
            TreeItem[] configs = typeItem.getItems();
            int j = 0;
            int numConfigs = configs.length;
            while (j < numConfigs) {
                if (configuration.equals(configs[j].getData())) {
                    configIndex = j;
                    type = (ILaunchConfigurationType)typeItem.getData();
                    break;
                }
                ++j;
            }
            ++i;
        }
        viewer.remove((Object)configuration);
        if (this.getViewer().getSelection().isEmpty()) {
            StructuredSelection newSelection = null;
            if (typeIndex != -1 && configIndex != -1) {
                TreeItem[] configItems = viewer.getTree().getItems()[typeIndex].getItems();
                int numItems = configItems.length;
                Object data = null;
                if (numItems > configIndex) {
                    data = configItems[configIndex].getData();
                } else if (numItems > 0) {
                    data = configItems[numItems - 1].getData();
                }
                if (data != null) {
                    newSelection = new StructuredSelection(data);
                }
            }
            if (newSelection == null && type != null) {
                newSelection = new StructuredSelection(type);
            }
            if (this.isAutoSelect()) {
                viewer.setSelection(newSelection);
            }
        }
    }

    public void createLaunchDialogControl(Composite parent) {
        this.fViewer = this.createViewer(parent);
        this.createActions();
        this.createContextMenu(this.getViewer().getControl());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.getHelpContextId());
        this.getViewer().getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                LaunchConfigurationView.this.handleKeyPressed(e);
            }
        });
        if (this.getViewer() instanceof StructuredViewer) {
            ((StructuredViewer)this.getViewer()).addDoubleClickListener((IDoubleClickListener)this);
        }
    }

    public Viewer getViewer() {
        return this.fViewer;
    }

    protected ILaunchManager getLaunchManager() {
        return this.fLaunchManager;
    }

    public void setAutoSelect(boolean select) {
        this.fAutoSelect = select;
    }

    protected boolean isAutoSelect() {
        return this.fAutoSelect;
    }
}

