/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.console;

import java.io.IOException;
import java.util.Map;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.debug.core.model.IStreamsProxy2;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.console.ConsoleRemoveAllTerminatedAction;
import org.eclipse.debug.internal.ui.views.console.ConsoleRemoveLaunchAction;
import org.eclipse.debug.internal.ui.views.console.ConsoleTerminateAction;
import org.eclipse.debug.internal.ui.views.console.ProcessConsole;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.AbstractHandler;
import org.eclipse.ui.commands.ExecutionException;
import org.eclipse.ui.commands.HandlerSubmission;
import org.eclipse.ui.commands.IHandler;
import org.eclipse.ui.commands.IWorkbenchCommandSupport;
import org.eclipse.ui.commands.Priority;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsolePageParticipant;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.contexts.EnabledSubmission;
import org.eclipse.ui.contexts.IWorkbenchContextSupport;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.ShowInContext;

public class ProcessConsolePageParticipant
implements IConsolePageParticipant,
IShowInSource,
IShowInTargetList,
IDebugEventSetListener,
ISelectionListener {
    private ConsoleTerminateAction fTerminate;
    private ConsoleRemoveLaunchAction fRemoveTerminated;
    private ConsoleRemoveAllTerminatedAction fRemoveAllTerminated;
    private ProcessConsole fConsole;
    private IPageBookViewPage fPage;
    private IConsoleView fView;
    private EOFHandler fEOFHandler;
    private EnabledSubmission fEnabledSubmission;
    private HandlerSubmission fHandlerSubmission;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public void init(IPageBookViewPage page, IConsole console) {
        this.fPage = page;
        this.fConsole = (ProcessConsole)console;
        this.fRemoveTerminated = new ConsoleRemoveLaunchAction(this.fConsole.getProcess().getLaunch());
        this.fRemoveAllTerminated = new ConsoleRemoveAllTerminatedAction();
        this.fTerminate = new ConsoleTerminateAction(this.fConsole);
        this.fView = (IConsoleView)this.fPage.getSite().getPage().findView("org.eclipse.ui.console.ConsoleView");
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        this.fPage.getSite().getPage().addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        IActionBars actionBars = this.fPage.getSite().getActionBars();
        this.configureToolBar(actionBars.getToolBarManager());
        this.fEOFHandler = new EOFHandler();
        this.fEnabledSubmission = new EnabledSubmission("org.eclipse.ui.console.ConsoleView", page.getSite().getShell(), null, "org.eclipse.debug.ui.console");
        this.fHandlerSubmission = new HandlerSubmission("org.eclipse.ui.console.ConsoleView", page.getSite().getShell(), null, "org.eclipse.debug.ui.commands.eof", (IHandler)this.fEOFHandler, Priority.MEDIUM);
    }

    public void dispose() {
        this.deactivated();
        this.fPage.getSite().getPage().removeSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        if (this.fRemoveTerminated != null) {
            this.fRemoveTerminated.dispose();
            this.fRemoveTerminated = null;
        }
        if (this.fRemoveAllTerminated != null) {
            this.fRemoveAllTerminated.dispose();
            this.fRemoveAllTerminated = null;
        }
        if (this.fTerminate != null) {
            this.fTerminate.dispose();
            this.fTerminate = null;
        }
        this.fConsole = null;
    }

    protected void configureToolBar(IToolBarManager mgr) {
        mgr.appendToGroup("launchGroup", (IAction)this.fTerminate);
        mgr.appendToGroup("launchGroup", (IAction)this.fRemoveTerminated);
        mgr.appendToGroup("launchGroup", (IAction)this.fRemoveAllTerminated);
    }

    public Object getAdapter(Class required) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.part.IShowInSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(required)) {
            return this;
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.ui.part.IShowInTargetList");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.equals(required)) {
            return this;
        }
        return null;
    }

    public ShowInContext getShowInContext() {
        IProcess process = this.getProcess();
        if (process == null) {
            return null;
        }
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.debug.core.model.IDebugTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IDebugTarget target = (IDebugTarget)process.getAdapter((Class)clazz);
        StructuredSelection selection = null;
        selection = target == null ? new StructuredSelection((Object)process) : new StructuredSelection((Object)target);
        return new ShowInContext(null, (ISelection)selection);
    }

    public String[] getShowInTargetIds() {
        return new String[]{"org.eclipse.debug.ui.DebugView"};
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            DebugEvent event = events[i];
            if (event.getSource().equals(this.getProcess())) {
                Runnable r = new Runnable(){

                    public void run() {
                        if (ProcessConsolePageParticipant.this.fTerminate != null) {
                            ProcessConsolePageParticipant.this.fTerminate.update();
                        }
                    }
                };
                DebugUIPlugin.getStandardDisplay().asyncExec(r);
            }
            ++i;
        }
    }

    protected IProcess getProcess() {
        return this.fConsole != null ? this.fConsole.getProcess() : null;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (this.fView != null && this.getProcess().equals(DebugUITools.getCurrentProcess())) {
            this.fView.display((IConsole)this.fConsole);
        }
    }

    public void activated() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchCommandSupport commandSupport = workbench.getCommandSupport();
        IWorkbenchContextSupport contextSupport = workbench.getContextSupport();
        contextSupport.addEnabledSubmission(this.fEnabledSubmission);
        commandSupport.addHandlerSubmission(this.fHandlerSubmission);
    }

    public void deactivated() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchCommandSupport commandSupport = workbench.getCommandSupport();
        IWorkbenchContextSupport contextSupport = workbench.getContextSupport();
        commandSupport.removeHandlerSubmission(this.fHandlerSubmission);
        contextSupport.removeEnabledSubmission(this.fEnabledSubmission);
    }

    private class EOFHandler
    extends AbstractHandler {
        EOFHandler() {
        }

        public Object execute(Map parameter) throws ExecutionException {
            IStreamsProxy proxy = ProcessConsolePageParticipant.this.getProcess().getStreamsProxy();
            if (proxy instanceof IStreamsProxy2) {
                IStreamsProxy2 proxy2 = (IStreamsProxy2)proxy;
                try {
                    proxy2.closeInputStream();
                }
                catch (IOException iOException) {}
            }
            return null;
        }
    }
}

