/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory.renderings;

import java.math.BigInteger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.IInternalDebugUIConstants;
import org.eclipse.debug.internal.ui.memory.IPersistableDebugElement;
import org.eclipse.debug.internal.ui.viewers.provisional.IAsynchronousRequestMonitor;
import org.eclipse.debug.internal.ui.viewers.provisional.IModelChangedListener;
import org.eclipse.debug.internal.ui.viewers.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewUtil;
import org.eclipse.debug.internal.ui.views.memory.renderings.AbstractAsyncTableRendering;
import org.eclipse.debug.internal.ui.views.memory.renderings.AbstractBaseTableRendering;
import org.eclipse.debug.internal.ui.views.memory.renderings.AbstractVirtualContentTableModel;
import org.eclipse.debug.internal.ui.views.memory.renderings.AsyncTableRenderingCellModifier;
import org.eclipse.debug.internal.ui.views.memory.renderings.AsyncTableRenderingViewer;
import org.eclipse.debug.internal.ui.views.memory.renderings.AsyncVirtualContentTableViewer;
import org.eclipse.debug.internal.ui.views.memory.renderings.CopyTableRenderingToClipboardAction;
import org.eclipse.debug.internal.ui.views.memory.renderings.FormatTableRenderingAction;
import org.eclipse.debug.internal.ui.views.memory.renderings.FormatTableRenderingDialog;
import org.eclipse.debug.internal.ui.views.memory.renderings.GoToAddressAction;
import org.eclipse.debug.internal.ui.views.memory.renderings.IPresentationErrorListener;
import org.eclipse.debug.internal.ui.views.memory.renderings.IVirtualContentListener;
import org.eclipse.debug.internal.ui.views.memory.renderings.MemorySegment;
import org.eclipse.debug.internal.ui.views.memory.renderings.PendingPropertyChanges;
import org.eclipse.debug.internal.ui.views.memory.renderings.PrintTableRenderingAction;
import org.eclipse.debug.internal.ui.views.memory.renderings.ReformatAction;
import org.eclipse.debug.internal.ui.views.memory.renderings.ResetToBaseAddressAction;
import org.eclipse.debug.internal.ui.views.memory.renderings.TableRenderingContentDescriptor;
import org.eclipse.debug.internal.ui.views.memory.renderings.TableRenderingPresentationContext;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.debug.ui.memory.IMemoryBlockTablePresentation;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.debug.ui.memory.IMemoryRenderingContainer;
import org.eclipse.debug.ui.memory.IMemoryRenderingSite;
import org.eclipse.debug.ui.memory.IMemoryRenderingSynchronizationService;
import org.eclipse.debug.ui.memory.IResettableMemoryRendering;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.progress.UIJob;

public abstract class AbstractAsyncTableRendering
extends AbstractBaseTableRendering
implements IPropertyChangeListener,
IResettableMemoryRendering {
    private PageBook fPageBook;
    private AsyncTableRenderingViewer fTableViewer;
    private TextViewer fTextViewer;
    private Shell fToolTipShell;
    private TableRenderingPresentationContext fPresentationContext;
    private int fAddressableSize;
    private TableRenderingContentDescriptor fContentDescriptor;
    private int fBytePerLine;
    private int fColumnSize;
    private boolean fShowMessage = false;
    private String fLabel;
    private IWorkbenchAdapter fWorkbenchAdapter;
    private int fPageSize;
    private GoToAddressAction fGoToAddressAction;
    private PrintTableRenderingAction fPrintViewTabAction;
    private CopyTableRenderingToClipboardAction fCopyToClipboardAction;
    private FormatTableRenderingAction fFormatRenderingAction;
    private ReformatAction fReformatAction;
    private ToggleAddressColumnAction fToggleAddressColumnAction;
    private ResetToBaseAddressAction fResetMemoryBlockAction;
    private PropertyDialogAction fPropertiesDialogAction;
    private NextPageAction fNextAction;
    private PrevPageAction fPrevAction;
    private boolean fIsCreated = false;
    private boolean fIsDisposed = false;
    private boolean fIsShowAddressColumn = true;
    private PendingPropertyChanges fPendingSyncProperties;
    public static final String EMPTY_MEMORY_GROUP = "popUpBegin";
    public static final String EMPTY_NAVIGATION_GROUP = "navigationGroup";
    public static final String EMPTY_NON_AUTO_LOAD_GROUP = "nonAutoLoadGroup";
    public static final String EMPTY_PROPERTY_GROUP = "propertyGroup";
    private ISelectionChangedListener fViewerSelectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            AbstractAsyncTableRendering.this.updateSyncTopAddress(AbstractAsyncTableRendering.this.getTopVisibleAddress());
            AbstractAsyncTableRendering.this.updateSyncSelectedAddress(AbstractAsyncTableRendering.this.getSelectedAddress());
        }
    };
    private SelectionAdapter fScrollBarSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            AbstractAsyncTableRendering.this.updateSyncTopAddress(AbstractAsyncTableRendering.this.getTopVisibleAddress());
        }
    };
    private IModelChangedListener fModelChangedListener = new IModelChangedListener(){

        public void modelChanged(IModelDelta delta) {
            if (delta.getElement() == AbstractAsyncTableRendering.this.getMemoryBlock()) {
                AbstractAsyncTableRendering.this.showTable();
                AbstractAsyncTableRendering.this.updateRenderingLabel(AbstractAsyncTableRendering.this.isVisible());
            }
        }
    };
    private IVirtualContentListener fViewerListener = new IVirtualContentListener(){

        public void handledAtBufferStart() {
            BigInteger address;
            if (AbstractAsyncTableRendering.this.getMemoryBlock() instanceof IMemoryBlockExtension && AbstractAsyncTableRendering.this.isDynamicLoad() && (address = AbstractAsyncTableRendering.this.getTopVisibleAddress()) != null && !AbstractAsyncTableRendering.this.isAtTopLimit()) {
                AbstractAsyncTableRendering.this.reloadTable(address);
            }
        }

        public void handleAtBufferEnd() {
            BigInteger address;
            if (AbstractAsyncTableRendering.this.getMemoryBlock() instanceof IMemoryBlockExtension && AbstractAsyncTableRendering.this.isDynamicLoad() && (address = AbstractAsyncTableRendering.this.getTopVisibleAddress()) != null && !AbstractAsyncTableRendering.this.isAtBottomLimit()) {
                AbstractAsyncTableRendering.this.reloadTable(address);
            }
        }

        public int getThreshold() {
            return 3;
        }
    };
    private IPresentationErrorListener fPresentationErrorListener = new IPresentationErrorListener(){

        public void handlePresentationFailure(IAsynchronousRequestMonitor monitor, IStatus status) {
            AbstractAsyncTableRendering.this.showMessage(status.getMessage());
        }
    };
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;

    public AbstractAsyncTableRendering(String renderingId) {
        super(renderingId);
    }

    public void resetRendering() throws DebugException {
        BigInteger baseAddress = this.fContentDescriptor.getContentBaseAddress();
        this.goToAddress(baseAddress);
        this.fTableViewer.setSelection(baseAddress);
        this.fTableViewer.setTopIndex(baseAddress);
    }

    public Control createControl(Composite parent) {
        this.fPageBook = new PageBook(parent, 0);
        this.createMessagePage((Composite)this.fPageBook);
        this.createTableViewer((Composite)this.fPageBook);
        this.addListeners();
        return this.fPageBook;
    }

    private void createMessagePage(Composite parent) {
        if (this.fTextViewer == null) {
            this.fTextViewer = new TextViewer(parent, 64);
            this.fTextViewer.setDocument((IDocument)new Document());
            StyledText styleText = this.fTextViewer.getTextWidget();
            styleText.setEditable(false);
            styleText.setEnabled(false);
        }
    }

    private void createTableViewer(final Composite parent) {
        Job job = new Job("Create Table Viewer"){

            protected IStatus run(IProgressMonitor monitor) {
                AbstractAsyncTableRendering.this.showMessage(DebugUIMessages.AbstractAsyncTableRendering_0);
                AbstractAsyncTableRendering.this.initAddressableSize();
                BigInteger topVisibleAddress = AbstractAsyncTableRendering.this.getInitialTopVisibleAddress();
                BigInteger mbBaseAddress = null;
                try {
                    mbBaseAddress = AbstractAsyncTableRendering.this.getMemoryBlockBaseAddress();
                }
                catch (DebugException e) {
                    AbstractAsyncTableRendering.this.showMessage(e.getMessage());
                }
                BigInteger finalMbBaseAddress = mbBaseAddress;
                BigInteger initialSelectedAddress = AbstractAsyncTableRendering.this.getInitialSelectedAddress();
                AbstractAsyncTableRendering.this.createContentDescriptor(topVisibleAddress);
                UIJob uiJob = new UIJob(this, "Create Table Viewer UI Job", parent, finalMbBaseAddress, topVisibleAddress, initialSelectedAddress){
                    final /* synthetic */ 6 this$1;
                    private final /* synthetic */ Composite val$parent;
                    private final /* synthetic */ BigInteger val$finalMbBaseAddress;
                    private final /* synthetic */ BigInteger val$topVisibleAddress;
                    private final /* synthetic */ BigInteger val$initialSelectedAddress;
                    {
                        this.this$1 = var1_1;
                        this.val$parent = composite;
                        this.val$finalMbBaseAddress = bigInteger;
                        this.val$topVisibleAddress = bigInteger2;
                        this.val$initialSelectedAddress = bigInteger3;
                    }

                    public IStatus runInUIThread(IProgressMonitor progressMonitor) {
                        AbstractAsyncTableRendering.access$19(6.access$0(this.this$1), new AsyncTableRenderingViewer(6.access$0(this.this$1), this.val$parent, 268471044));
                        AbstractAsyncTableRendering.access$20(6.access$0(this.this$1), new TableRenderingPresentationContext(6.access$0(this.this$1).getMemoryRenderingContainer().getMemoryRenderingSite().getSite().getPart()));
                        AbstractAsyncTableRendering.access$21(6.access$0(this.this$1)).setContainerId(6.access$0(this.this$1).getMemoryRenderingContainer().getId());
                        AbstractAsyncTableRendering.access$21(6.access$0(this.this$1)).setRendering(6.access$0(this.this$1));
                        AbstractAsyncTableRendering.access$10(6.access$0(this.this$1)).setContext(AbstractAsyncTableRendering.access$21(6.access$0(this.this$1)));
                        AbstractAsyncTableRendering.access$22(6.access$0(this.this$1));
                        AbstractAsyncTableRendering.access$23(6.access$0(this.this$1));
                        int numberOfLines = AbstractAsyncTableRendering.access$24(6.access$0(this.this$1));
                        AbstractAsyncTableRendering.access$11(6.access$0(this.this$1)).setNumLines(numberOfLines);
                        BigInteger baseAddress = this.val$finalMbBaseAddress;
                        if (baseAddress == null) {
                            baseAddress = BigInteger.ZERO;
                        }
                        if (!(6.access$0(this.this$1).getMemoryBlock() instanceof IMemoryBlockExtension) || !AbstractAsyncTableRendering.access$3(6.access$0(this.this$1))) {
                            AbstractAsyncTableRendering.access$11(6.access$0(this.this$1)).setPreBuffer(0);
                            AbstractAsyncTableRendering.access$11(6.access$0(this.this$1)).setPostBuffer(0);
                        }
                        AbstractAsyncTableRendering.access$21(6.access$0(this.this$1)).setContentDescriptor(AbstractAsyncTableRendering.access$11(6.access$0(this.this$1)));
                        AbstractAsyncTableRendering.access$25(6.access$0(this.this$1));
                        AbstractAsyncTableRendering.access$10(6.access$0(this.this$1)).setCellModifier(AbstractAsyncTableRendering.access$26(6.access$0(this.this$1)));
                        AbstractAsyncTableRendering.access$10(6.access$0(this.this$1)).getTable().setHeaderVisible(true);
                        AbstractAsyncTableRendering.access$10(6.access$0(this.this$1)).getTable().setLinesVisible(true);
                        AbstractAsyncTableRendering.access$10(6.access$0(this.this$1)).addPresentationErrorListener(AbstractAsyncTableRendering.access$27(6.access$0(this.this$1)));
                        AbstractAsyncTableRendering.access$10(6.access$0(this.this$1)).setInput(6.access$0(this.this$1).getMemoryBlock());
                        AbstractAsyncTableRendering.access$10(6.access$0(this.this$1)).resizeColumnsToPreferredSize();
                        AbstractAsyncTableRendering.access$10(6.access$0(this.this$1)).setTopIndex(this.val$topVisibleAddress);
                        AbstractAsyncTableRendering.access$10(6.access$0(this.this$1)).setSelection(this.val$initialSelectedAddress);
                        AbstractAsyncTableRendering.access$10(6.access$0(this.this$1)).getTable().setFont(JFaceResources.getFont((String)IInternalDebugUIConstants.FONT_NAME));
                        if (this.val$finalMbBaseAddress != null) {
                            6.access$0(this.this$1).showTable();
                        }
                        AbstractAsyncTableRendering.access$10(6.access$0(this.this$1)).addVirtualContentListener(AbstractAsyncTableRendering.access$28(6.access$0(this.this$1)));
                        6.access$0(this.this$1).createActions();
                        IMenuListener listener = new IMenuListener(this){
                            final /* synthetic */ 7 this$2;
                            {
                                this.this$2 = var1_1;
                            }

                            public void menuAboutToShow(IMenuManager mgr) {
                                6.access$0(7.access$0(this.this$2)).fillContextMenu(mgr);
                            }
                        };
                        AbstractAsyncTableRendering.access$29(6.access$0(this.this$1), AbstractAsyncTableRendering.access$10(6.access$0(this.this$1)).getControl(), listener);
                        AbstractAsyncTableRendering.access$29(6.access$0(this.this$1), (Control)AbstractAsyncTableRendering.access$10(6.access$0(this.this$1)).getCursor(), listener);
                        AbstractAsyncTableRendering.access$10(6.access$0(this.this$1)).addSelectionChangedListener(AbstractAsyncTableRendering.access$30(6.access$0(this.this$1)));
                        AbstractAsyncTableRendering.access$10(6.access$0(this.this$1)).getTable().getVerticalBar().addSelectionListener((SelectionListener)AbstractAsyncTableRendering.access$31(6.access$0(this.this$1)));
                        AbstractAsyncTableRendering.access$32(6.access$0(this.this$1));
                        AbstractAsyncTableRendering.access$33(6.access$0(this.this$1), true);
                        return Status.OK_STATUS;
                    }

                    static /* synthetic */ 6 access$0(7 var0) {
                        return var0.this$1;
                    }
                };
                uiJob.setSystem(true);
                uiJob.schedule();
                return Status.OK_STATUS;
            }

            static /* synthetic */ AbstractAsyncTableRendering access$0(6 var0) {
                return var0.AbstractAsyncTableRendering.this;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    private void createPopupMenu(Control control, IMenuListener menuListener) {
        IMemoryRenderingContainer container = this.getMemoryRenderingContainer();
        MenuManager popupMenuMgr = this.getPopupMenuManager();
        if (popupMenuMgr == null) {
            popupMenuMgr = new MenuManager("#PopupMenu");
            popupMenuMgr.setRemoveAllWhenShown(true);
            IMemoryRenderingSite site = container.getMemoryRenderingSite();
            String menuId = container.getId();
            ISelectionProvider selProvider = site.getSite().getSelectionProvider();
            popupMenuMgr.addMenuListener(menuListener);
            site.getSite().registerContextMenu(menuId, popupMenuMgr, selProvider);
        }
        Menu popupMenu = popupMenuMgr.createContextMenu(control);
        control.setMenu(popupMenu);
    }

    private BigInteger getInitialSelectedAddress() {
        BigInteger selectedAddress = (BigInteger)this.getSynchronizedProperty("selectedAddress");
        if (selectedAddress == null) {
            if (this.getMemoryBlock() instanceof IMemoryBlockExtension) {
                try {
                    selectedAddress = ((IMemoryBlockExtension)this.getMemoryBlock()).getBigBaseAddress();
                }
                catch (DebugException debugException) {
                    selectedAddress = BigInteger.ZERO;
                }
                if (selectedAddress == null) {
                    selectedAddress = BigInteger.ZERO;
                }
            } else {
                long address = this.getMemoryBlock().getStartAddress();
                selectedAddress = BigInteger.valueOf(address);
            }
        }
        return selectedAddress;
    }

    private void addListeners() {
        DebugUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.addRenderingToSyncService();
        JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
    }

    private void removeListeners() {
        DebugUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        this.removeRenderingFromSyncService();
        JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this);
    }

    private void addRenderingToSyncService() {
        IMemoryRenderingSynchronizationService syncService = this.getMemoryRenderingContainer().getMemoryRenderingSite().getSynchronizationService();
        if (syncService == null) {
            return;
        }
        syncService.addPropertyChangeListener(this, null);
    }

    private void removeRenderingFromSyncService() {
        IMemoryRenderingSynchronizationService syncService = this.getMemoryRenderingContainer().getMemoryRenderingSite().getSynchronizationService();
        if (syncService == null) {
            return;
        }
        syncService.removePropertyChangeListener(this);
    }

    private void initAddressableSize() {
        this.fAddressableSize = -1;
        try {
            this.fAddressableSize = this.getMemoryBlock() instanceof IMemoryBlockExtension ? ((IMemoryBlockExtension)this.getMemoryBlock()).getAddressableSize() : 1;
        }
        catch (DebugException e1) {
            DebugUIPlugin.log(e1);
            this.fAddressableSize = 1;
            return;
        }
        if (this.fAddressableSize < 1) {
            DebugUIPlugin.logErrorMessage("Invalid addressable size");
            this.fAddressableSize = 1;
        }
    }

    private BigInteger getInitialTopVisibleAddress() {
        BigInteger topVisibleAddress = (BigInteger)this.getSynchronizedProperty("topAddress");
        if (topVisibleAddress == null) {
            if (this.getMemoryBlock() instanceof IMemoryBlockExtension) {
                try {
                    topVisibleAddress = ((IMemoryBlockExtension)this.getMemoryBlock()).getBigBaseAddress();
                }
                catch (DebugException debugException) {
                    topVisibleAddress = new BigInteger("0");
                }
            } else {
                topVisibleAddress = BigInteger.valueOf(this.getMemoryBlock().getStartAddress());
            }
        }
        return topVisibleAddress;
    }

    private void setupInitialFormat() {
        boolean validated = this.validateInitialFormat();
        if (!validated) {
            StringBuffer msgBuffer = new StringBuffer(DebugUIMessages.AbstractTableRendering_20);
            msgBuffer.append(" ");
            msgBuffer.append(this.getLabel());
            msgBuffer.append("\n\n");
            msgBuffer.append(DebugUIMessages.AbstractTableRendering_16);
            msgBuffer.append("\n");
            msgBuffer.append(DebugUIMessages.AbstractTableRendering_18);
            msgBuffer.append("\n\n");
            int bytePerLine = this.fBytePerLine;
            int columnSize = this.fColumnSize;
            this.fBytePerLine = this.getDefaultRowSize() / this.getAddressableSize();
            this.fColumnSize = this.getDefaultColumnSize() / this.getAddressableSize();
            FormatTableRenderingDialog dialog = new FormatTableRenderingDialog(this, DebugUIPlugin.getShell());
            dialog.openError(msgBuffer.toString());
            this.fBytePerLine = bytePerLine;
            this.fColumnSize = columnSize;
            bytePerLine = dialog.getRowSize() * this.getAddressableSize();
            columnSize = dialog.getColumnSize() * this.getAddressableSize();
            this.format(bytePerLine, columnSize);
        } else {
            int columnSize;
            int bytePerLine = this.getDefaultRowSize();
            boolean ok = this.format(bytePerLine, columnSize = this.getDefaultColumnSize());
            if (!ok) {
                this.format(bytePerLine, bytePerLine);
            }
        }
    }

    private boolean validateInitialFormat() {
        int columnSize;
        int rowSize = this.getDefaultRowSize();
        return rowSize >= (columnSize = this.getDefaultColumnSize()) && rowSize % columnSize == 0 && rowSize != 0 && columnSize != 0;
    }

    public Control getControl() {
        return this.fPageBook;
    }

    public void propertyChange(PropertyChangeEvent event) {
        IMemoryRendering rendering;
        IMemoryBlock memoryBlock;
        if (!this.fIsCreated) {
            return;
        }
        if (event.getProperty().equals(IInternalDebugUIConstants.FONT_NAME)) {
            if (!this.fIsDisposed) {
                Font memoryViewFont = JFaceResources.getFont((String)IInternalDebugUIConstants.FONT_NAME);
                this.setFont(memoryViewFont);
            }
            return;
        }
        Object evtSrc = event.getSource();
        if (event.getProperty().equals("org.eclispe.debug.ui.memory.pageSize")) {
            this.getPageSizeFromPreference();
        }
        if (this.isDisplayingError() || !this.isVisible()) {
            this.handlePropertiesChangeWhenHidden(event);
            return;
        }
        if (event.getProperty().equals(IDebugUIConstants.PREF_PADDED_STR) || event.getProperty().equals("org.eclipse.debug.ui.changedDebugElement") || event.getProperty().equals(IDebugUIConstants.PREF_MEMORY_HISTORY_KNOWN_COLOR) || event.getProperty().equals(IDebugUIConstants.PREF_MEMORY_HISTORY_UNKNOWN_COLOR)) {
            if (!this.fIsDisposed) {
                this.fTableViewer.refresh(false);
            }
            return;
        }
        if (event.getProperty().equals("org.eclpise.debug.ui.memory.dynamicLoad")) {
            this.handleDyanicLoadChanged();
            return;
        }
        if (event.getProperty().equals("org.eclispe.debug.ui.memory.pageSize")) {
            if (!this.isDynamicLoad()) {
                int pageSize = DebugUIPlugin.getDefault().getPreferenceStore().getInt("org.eclispe.debug.ui.memory.pageSize");
                this.handlePageSizeChanged(pageSize);
            }
            return;
        }
        if (evtSrc == this) {
            return;
        }
        if (evtSrc instanceof IMemoryRendering && (memoryBlock = (rendering = (IMemoryRendering)evtSrc).getMemoryBlock()) != this.getMemoryBlock()) {
            return;
        }
        String propertyName = event.getProperty();
        Object value = event.getNewValue();
        if (propertyName.equals("selectedAddress") && value instanceof BigInteger) {
            this.selectedAddressChanged((BigInteger)value);
        } else if (propertyName.equals("columnSize") && value instanceof Integer) {
            this.columnSizeChanged((Integer)value);
        } else if (propertyName.equals("rowSize") && value instanceof Integer) {
            this.rowSizeChanged((Integer)value);
        } else if (propertyName.equals("topAddress") && value instanceof BigInteger) {
            this.topVisibleAddressChanged((BigInteger)value);
        } else if (propertyName.equals("pageStart") && value instanceof BigInteger) {
            this.handlePageStartAddressChanged((BigInteger)value);
        }
    }

    private void handlePageSizeChanged(int pageSize) {
        this.fPageSize = pageSize;
        this.fContentDescriptor.setNumLines(pageSize);
        this.refresh();
    }

    private void handlePropertiesChangeWhenHidden(PropertyChangeEvent event) {
        IMemoryRendering rendering;
        if (this.fPendingSyncProperties == null) {
            return;
        }
        String propertyName = event.getProperty();
        Object value = event.getNewValue();
        if (event.getSource() instanceof IMemoryRendering && ((rendering = (IMemoryRendering)event.getSource()) == this || rendering.getMemoryBlock() != this.getMemoryBlock())) {
            return;
        }
        if (propertyName.equals("columnSize") && value instanceof Integer) {
            this.fPendingSyncProperties.setColumnSize((Integer)value);
        } else if (propertyName.equals("rowSize") && value instanceof Integer) {
            this.fPendingSyncProperties.setRowSize((Integer)value);
        } else if (propertyName.equals("selectedAddress") && value instanceof BigInteger) {
            this.fPendingSyncProperties.setSelectedAddress((BigInteger)value);
        } else if (propertyName.equals("topAddress") && value instanceof BigInteger) {
            this.fPendingSyncProperties.setTopVisibleAddress((BigInteger)value);
        } else if (propertyName.equals("pageStart") && value instanceof BigInteger) {
            this.fPendingSyncProperties.setPageStartAddress((BigInteger)value);
        } else if (event.getProperty().equals("org.eclispe.debug.ui.memory.pageSize")) {
            int pageSize = DebugUIPlugin.getDefault().getPreferenceStore().getInt("org.eclispe.debug.ui.memory.pageSize");
            this.fPendingSyncProperties.setPageSize(pageSize);
        }
    }

    private void topVisibleAddressChanged(final BigInteger address) {
        Runnable runnable = new Runnable(){

            public void run() {
                AbstractAsyncTableRendering.this.doTopVisibleAddressChanged(address);
            }
        };
        this.runOnUIThread(runnable);
    }

    private void doTopVisibleAddressChanged(BigInteger address) {
        if (this.fIsDisposed) {
            return;
        }
        if (!this.isDynamicLoad()) {
            this.fTableViewer.setTopIndex(address);
            this.fTableViewer.topIndexChanged();
            Object selection = this.fTableViewer.getSelectionKey();
            this.fTableViewer.setSelection(selection);
            return;
        }
        if (!this.isAtTopBuffer(address) && !this.isAtBottomBuffer(address)) {
            this.fTableViewer.setTopIndex(address);
            this.fTableViewer.topIndexChanged();
        } else {
            this.reloadTable(address);
        }
    }

    private boolean isAtBottomBuffer(BigInteger address) {
        int idx = this.fTableViewer.indexOf(address);
        if (idx < 0) {
            return true;
        }
        int bottomIdx = idx + this.getNumberOfVisibleLines();
        int elementsCnt = this.fTableViewer.getVirtualContentModel().getElements().length;
        int numLinesLeft = elementsCnt - bottomIdx;
        return numLinesLeft <= 3;
    }

    private boolean isAtTopBuffer(BigInteger address) {
        int topIdx = this.fTableViewer.indexOf(address);
        return topIdx <= 3;
    }

    private void runOnUIThread(final Runnable runnable) {
        if (Display.getCurrent() != null) {
            runnable.run();
        } else {
            UIJob job = new UIJob("Async Table Rendering UI Job"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    runnable.run();
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }
    }

    private void selectedAddressChanged(final BigInteger address) {
        Runnable runnable = new Runnable(){

            public void run() {
                int i = AbstractAsyncTableRendering.this.fTableViewer.indexOf(address);
                if (i < 0) {
                    AbstractAsyncTableRendering.this.topVisibleAddressChanged(address);
                }
                AbstractAsyncTableRendering.this.fTableViewer.setSelection(address);
            }
        };
        this.runOnUIThread(runnable);
    }

    private void setFont(Font font) {
        this.fTableViewer.getTable().setFont(font);
        this.fTableViewer.getCursor().setFont(font);
    }

    private int getDefaultColumnSize() {
        IPreferenceStore prefStore = DebugUITools.getPreferenceStore();
        int columnSize = prefStore.getInt("org.eclipse.debug.ui.memory.columnSize");
        columnSize *= this.getAddressableSize();
        Integer colSize = (Integer)this.getSynchronizedProperty("columnSize");
        if (colSize != null) {
            int syncColSize = colSize;
            if (syncColSize > 0) {
                columnSize = syncColSize;
            }
        } else {
            IMemoryBlock iMemoryBlock = this.getMemoryBlock();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.debug.internal.ui.memory.IPersistableDebugElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            IPersistableDebugElement elmt = (IPersistableDebugElement)iMemoryBlock.getAdapter((Class)clazz);
            int defaultColSize = -1;
            if (elmt != null && elmt.supportsProperty(this, "org.eclipse.debug.ui.AbstractTableRendering.colSize")) {
                defaultColSize = this.getDefaultFromPersistableElement("org.eclipse.debug.ui.AbstractTableRendering.colSize");
            }
            if (defaultColSize <= 0) {
                defaultColSize = this.getDefaultColumnSizeByModel(this.getMemoryBlock().getModelIdentifier());
            }
            if (defaultColSize > 0) {
                columnSize = defaultColSize * this.getAddressableSize();
            }
        }
        return columnSize;
    }

    private int getDefaultRowSize() {
        int rowSize = DebugUITools.getPreferenceStore().getInt("org.eclipse.debug.ui.memory.rowSize");
        int bytePerLine = rowSize * this.getAddressableSize();
        Integer size = (Integer)this.getSynchronizedProperty("rowSize");
        if (size != null) {
            int syncRowSize = size;
            if (syncRowSize > 0) {
                bytePerLine = syncRowSize;
            }
        } else {
            IPersistableDebugElement elmt;
            int defaultRowSize = -1;
            IMemoryBlock iMemoryBlock = this.getMemoryBlock();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.debug.internal.ui.memory.IPersistableDebugElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((elmt = (IPersistableDebugElement)iMemoryBlock.getAdapter((Class)clazz)) != null && elmt.supportsProperty(this, "org.eclipse.debug.ui.AbstractTableRendering.rowSize")) {
                defaultRowSize = this.getDefaultFromPersistableElement("org.eclipse.debug.ui.AbstractTableRendering.rowSize");
                return defaultRowSize * this.getAddressableSize();
            }
            if (defaultRowSize <= 0) {
                defaultRowSize = this.getDefaultRowSizeByModel(this.getMemoryBlock().getModelIdentifier());
            }
            if (defaultRowSize > 0) {
                bytePerLine = defaultRowSize * this.getAddressableSize();
            }
        }
        return bytePerLine;
    }

    public int getAddressableSize() {
        return this.fAddressableSize;
    }

    private Object getSynchronizedProperty(String propertyId) {
        IMemoryRenderingSynchronizationService syncService = this.getMemoryRenderingContainer().getMemoryRenderingSite().getSynchronizationService();
        if (syncService == null) {
            return null;
        }
        return syncService.getProperty(this.getMemoryBlock(), propertyId);
    }

    private int getDefaultFromPersistableElement(String propertyId) {
        IPersistableDebugElement elmt;
        int defaultValue = -1;
        IMemoryBlock iMemoryBlock = this.getMemoryBlock();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.debug.internal.ui.memory.IPersistableDebugElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((elmt = (IPersistableDebugElement)iMemoryBlock.getAdapter((Class)clazz)) != null) {
            try {
                Object valueMB = elmt.getProperty(this, propertyId);
                if (valueMB != null && !(valueMB instanceof Integer)) {
                    IStatus status = DebugUIPlugin.newErrorStatus("Model returned invalid type on " + propertyId, null);
                    DebugUIPlugin.log(status);
                }
                if (valueMB != null) {
                    Integer value = (Integer)valueMB;
                    defaultValue = value;
                }
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
            }
        }
        return defaultValue;
    }

    private int getDefaultRowSizeByModel(String modelId) {
        int row = DebugUITools.getPreferenceStore().getInt(this.getRowPrefId(modelId));
        if (row == 0) {
            DebugUITools.getPreferenceStore().setValue(this.getRowPrefId(modelId), 16);
        }
        row = DebugUITools.getPreferenceStore().getInt(this.getRowPrefId(modelId));
        return row;
    }

    private int getDefaultColumnSizeByModel(String modelId) {
        int col = DebugUITools.getPreferenceStore().getInt(this.getColumnPrefId(modelId));
        if (col == 0) {
            DebugUITools.getPreferenceStore().setValue(this.getColumnPrefId(modelId), 4);
        }
        col = DebugUITools.getPreferenceStore().getInt(this.getColumnPrefId(modelId));
        return col;
    }

    private String getRowPrefId(String modelId) {
        String rowPrefId = "org.eclipse.debug.ui.memory.rowSize:" + modelId;
        return rowPrefId;
    }

    private String getColumnPrefId(String modelId) {
        String colPrefId = "org.eclipse.debug.ui.memory.columnSize:" + modelId;
        return colPrefId;
    }

    public boolean format(int bytesPerLine, int columnSize) {
        if (bytesPerLine % columnSize != 0) {
            return false;
        }
        if (bytesPerLine < columnSize) {
            return false;
        }
        if (this.fBytePerLine == bytesPerLine && this.fColumnSize == columnSize) {
            return false;
        }
        this.fBytePerLine = bytesPerLine;
        this.fColumnSize = columnSize;
        this.formatViewer();
        this.updateSyncRowSize();
        this.updateSyncColSize();
        return true;
    }

    public int getAddressableUnitPerLine() {
        return this.fBytePerLine / this.getAddressableSize();
    }

    public int getAddressableUnitPerColumn() {
        return this.fColumnSize / this.getAddressableSize();
    }

    private int getNumberOfVisibleLines() {
        int lineHeight;
        int scroll;
        int border;
        int numberOfLines;
        if (this.fTableViewer == null) {
            return -1;
        }
        Table table = this.fTableViewer.getTable();
        int height = this.fTableViewer.getTable().getSize().y;
        if (height == 0) {
            height = this.fTableViewer.getTable().getParent().getSize().y;
        }
        if ((numberOfLines = (height = height - (border = this.fTableViewer.getTable().getHeaderHeight()) - (scroll = this.fTableViewer.getTable().getHorizontalBar().getSize().y)) / (lineHeight = this.getMinTableItemHeight(table))) <= 0) {
            return 20;
        }
        return numberOfLines;
    }

    private int getMinTableItemHeight(Table table) {
        if (MemoryViewUtil.isLinuxGTK()) {
            TableItem[] items = table.getItems();
            int minHeight = table.getItemHeight();
            int i = 0;
            while (i < items.length) {
                minHeight = Math.min(items[i].getBounds((int)0).height, minHeight);
                ++i;
            }
            return minHeight;
        }
        return table.getItemHeight();
    }

    private BigInteger getMemoryBlockBaseAddress() throws DebugException {
        if (this.getMemoryBlock() instanceof IMemoryBlockExtension) {
            return ((IMemoryBlockExtension)this.getMemoryBlock()).getBigBaseAddress();
        }
        return BigInteger.valueOf(this.getMemoryBlock().getStartAddress());
    }

    private void showMessage(final String message) {
        UIJob job = new UIJob("Display Message Job"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                StyledText styleText = null;
                AbstractAsyncTableRendering.this.fShowMessage = true;
                styleText = AbstractAsyncTableRendering.this.fTextViewer.getTextWidget();
                if (styleText != null) {
                    styleText.setText(message);
                }
                AbstractAsyncTableRendering.this.fPageBook.showPage(AbstractAsyncTableRendering.this.fTextViewer.getControl());
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    public int getBytesPerColumn() {
        return this.fColumnSize;
    }

    public int getBytesPerLine() {
        return this.fBytePerLine;
    }

    public boolean isDisplayingError() {
        return this.fShowMessage;
    }

    public void showTable() {
        UIJob job = new UIJob("Display Table Job"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                AbstractAsyncTableRendering.this.fShowMessage = false;
                AbstractAsyncTableRendering.this.fPageBook.showPage(AbstractAsyncTableRendering.this.fTableViewer.getControl());
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    private BigInteger getTopVisibleAddress() {
        MemorySegment topItem;
        if (this.fTableViewer == null) {
            return BigInteger.valueOf(0L);
        }
        Table table = this.fTableViewer.getTable();
        int topIndex = table.getTopIndex();
        if (topIndex < 0) {
            return null;
        }
        if (table.getItemCount() > topIndex && (topItem = (MemorySegment)((Object)table.getItem(topIndex).getData())) != null) {
            return topItem.getAddress();
        }
        return null;
    }

    private synchronized void reloadTable(BigInteger topAddress) {
        if (AsyncVirtualContentTableViewer.DEBUG_DYNAMIC_LOADING) {
            System.out.println("reload at: " + topAddress.toString(16));
        }
        this.fContentDescriptor.setLoadAddress(topAddress);
        this.fContentDescriptor.setNumLines(this.getNumLinesToLoad());
        this.fTableViewer.setTopIndex(topAddress);
        this.fTableViewer.refresh();
    }

    private boolean isAtTopLimit() {
        Object key;
        BigInteger startAddress = this.fContentDescriptor.getStartAddress();
        startAddress = MemoryViewUtil.alignToBoundary(startAddress, this.getAddressableUnitPerLine());
        AbstractVirtualContentTableModel model = this.fTableViewer.getVirtualContentModel();
        if (model != null && (key = model.getKey(0)) instanceof BigInteger) {
            BigInteger startBufferAddress = (BigInteger)key;
            if (startAddress.compareTo(startBufferAddress = MemoryViewUtil.alignToBoundary(startBufferAddress, this.getAddressableUnitPerLine())) == 0) {
                return true;
            }
        }
        return false;
    }

    private boolean isAtBottomLimit() {
        int numElements;
        Object key;
        BigInteger endAddress = this.fContentDescriptor.getEndAddress();
        endAddress = MemoryViewUtil.alignToBoundary(endAddress, this.getAddressableUnitPerLine());
        AbstractVirtualContentTableModel model = this.fTableViewer.getVirtualContentModel();
        if (model != null && (key = model.getKey((numElements = model.getElements().length) - 1)) instanceof BigInteger) {
            BigInteger endBufferAddress = (BigInteger)key;
            if (endAddress.compareTo(endBufferAddress = MemoryViewUtil.alignToBoundary(endBufferAddress, this.getAddressableUnitPerLine())) == 0) {
                return true;
            }
        }
        return false;
    }

    private void formatViewer() {
        this.fTableViewer.disposeColumns();
        this.fTableViewer.disposeCellEditors();
        this.doFormatTable();
        this.fTableViewer.setColumnHeaders(this.getColumnProperties());
        this.fTableViewer.showColumnHeader(true);
        this.fTableViewer.setCellEditors(this.createCellEditors(this.fTableViewer.getTable()));
        this.fTableViewer.formatViewer();
        UIJob job = new UIJob("resize to fit"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                AbstractAsyncTableRendering.this.resizeColumnsToPreferredSize();
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    private void doFormatTable() {
        int bytesPerLine = this.getBytesPerLine();
        int columnSize = this.getBytesPerColumn();
        int numColumns = bytesPerLine / columnSize;
        Table table = this.fTableViewer.getTable();
        TableColumn column0 = new TableColumn(table, 16384, 0);
        column0.setText(DebugUIMessages.AbstractTableRendering_2);
        TableColumn[] byteColumns = new TableColumn[numColumns];
        int i = 0;
        while (i < byteColumns.length) {
            TableColumn column;
            byteColumns[i] = column = new TableColumn(table, 16384, i + 1);
            ++i;
        }
        TableColumn emptyCol = new TableColumn(table, 16384, byteColumns.length + 1);
        emptyCol.setText(" ");
        emptyCol.setWidth(1);
        emptyCol.setResizable(false);
        table.setHeaderVisible(true);
        this.setColumnHeadings();
    }

    private String[] getColumnProperties() {
        int numColumns = this.getAddressableUnitPerLine() / this.getAddressableUnitPerColumn();
        String[] columnProperties = new String[numColumns + 2];
        columnProperties[0] = "address";
        int addressableUnit = this.getAddressableUnitPerColumn();
        int i = 1;
        while (i < columnProperties.length - 1) {
            columnProperties[i] = Integer.toHexString((i - 1) * addressableUnit);
            ++i;
        }
        columnProperties[columnProperties.length - 1] = " ";
        return columnProperties;
    }

    private CellEditor[] createCellEditors(Table table) {
        CellEditor[] editors = new CellEditor[table.getColumnCount()];
        int i = 0;
        while (i < editors.length) {
            editors[i] = new TextCellEditor((Composite)table);
            ++i;
        }
        return editors;
    }

    private ICellModifier createCellModifier() {
        return new AsyncTableRenderingCellModifier(this);
    }

    public void dispose() {
        if (this.fIsDisposed) {
            return;
        }
        this.removeListeners();
        if (this.fTableViewer != null) {
            if (this.fViewerListener != null) {
                this.fTableViewer.removeVirtualContentListener(this.fViewerListener);
            }
            if (this.fPresentationErrorListener != null) {
                this.fTableViewer.removePresentationErrorListener(this.fPresentationErrorListener);
            }
            this.fTableViewer.removeSelectionChangedListener(this.fViewerSelectionChangedListener);
            this.fTableViewer.getTable().getVerticalBar().removeSelectionListener((SelectionListener)this.fScrollBarSelectionListener);
            this.fTableViewer.dispose();
        }
        this.fIsDisposed = true;
        super.dispose();
    }

    protected void updateRenderingLabel(final boolean showAddress) {
        Job job = new Job("Update Rendering Label"){

            protected IStatus run(IProgressMonitor monitor) {
                AbstractAsyncTableRendering.this.fLabel = AbstractAsyncTableRendering.this.buildLabel(showAddress);
                AbstractAsyncTableRendering.this.firePropertyChangedEvent(new PropertyChangeEvent((Object)AbstractAsyncTableRendering.this, "org.eclipse.jface.text", null, (Object)AbstractAsyncTableRendering.this.fLabel));
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    private String buildLabel(boolean showAddress) {
        String preName;
        String label = "";
        if (this.getMemoryBlock() instanceof IMemoryBlockExtension) {
            label = ((IMemoryBlockExtension)this.getMemoryBlock()).getExpression();
            if (label.startsWith("&")) {
                label = "&" + label;
            }
            if (label == null) {
                label = DebugUIMessages.AbstractTableRendering_8;
            }
            try {
                if (showAddress && ((IMemoryBlockExtension)this.getMemoryBlock()).getBigBaseAddress() != null) {
                    label = String.valueOf(label) + " : 0x";
                    label = String.valueOf(label) + ((IMemoryBlockExtension)this.getMemoryBlock()).getBigBaseAddress().toString(16).toUpperCase();
                }
            }
            catch (DebugException debugException) {}
        } else {
            long address = this.getMemoryBlock().getStartAddress();
            label = Long.toHexString(address).toUpperCase();
        }
        if ((preName = DebugUITools.getMemoryRenderingManager().getRenderingType(this.getRenderingId()).getLabel()) != null) {
            label = String.valueOf(label) + " <" + preName + ">";
        }
        return this.decorateLabel(label);
    }

    public String getLabel() {
        if (this.fLabel == null) {
            this.fLabel = DebugUIMessages.AbstractAsyncTableRendering_1;
            this.updateRenderingLabel(this.isVisible());
        }
        return this.fLabel;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jface.viewers.IColorProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return this.getColorProviderAdapter();
        }
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.eclipse.jface.viewers.ILabelProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz2) {
            return this.getLabelProviderAdapter();
        }
        Class<?> clazz3 = class$3;
        if (clazz3 == null) {
            try {
                clazz3 = class$3 = Class.forName("org.eclipse.jface.viewers.IFontProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz3) {
            return this.getFontProviderAdapter();
        }
        Class<?> clazz4 = class$4;
        if (clazz4 == null) {
            try {
                clazz4 = class$4 = Class.forName("org.eclipse.debug.internal.ui.viewers.provisional.IModelChangedListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz4) {
            return this.fModelChangedListener;
        }
        Class<?> clazz5 = class$5;
        if (clazz5 == null) {
            try {
                clazz5 = class$5 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz5) {
            if (this.fWorkbenchAdapter == null) {
                this.fWorkbenchAdapter = new IWorkbenchAdapter(){

                    public Object[] getChildren(Object o) {
                        return new Object[0];
                    }

                    public ImageDescriptor getImageDescriptor(Object object) {
                        return null;
                    }

                    public String getLabel(Object o) {
                        return AbstractAsyncTableRendering.this.getLabel();
                    }

                    public Object getParent(Object o) {
                        return null;
                    }
                };
            }
            return this.fWorkbenchAdapter;
        }
        return super.getAdapter(adapter);
    }

    public int getNumCharsPerByte() {
        return -1;
    }

    protected void createActions() {
        this.fCopyToClipboardAction = new CopyTableRenderingToClipboardAction(this, this.fTableViewer);
        this.fGoToAddressAction = new GoToAddressAction(this);
        this.fResetMemoryBlockAction = new ResetToBaseAddressAction(this);
        this.fPrintViewTabAction = new PrintTableRenderingAction(this, this.fTableViewer);
        this.fFormatRenderingAction = new FormatTableRenderingAction(this);
        this.fReformatAction = new ReformatAction(this);
        this.fToggleAddressColumnAction = new ToggleAddressColumnAction();
        IMemoryRenderingSite site = this.getMemoryRenderingContainer().getMemoryRenderingSite();
        if (site.getSite().getSelectionProvider() != null) {
            this.fPropertiesDialogAction = new PropertyDialogAction((IShellProvider)site.getSite(), site.getSite().getSelectionProvider());
        }
        this.fNextAction = new NextPageAction();
        this.fPrevAction = new PrevPageAction();
    }

    public BigInteger getSelectedAddress() {
        Object key = this.fTableViewer.getSelectionKey();
        if (key != null && key instanceof BigInteger) {
            return (BigInteger)key;
        }
        return null;
    }

    public MemoryByte[] getSelectedAsBytes() {
        if (this.getSelectedAddress() == null) {
            return new MemoryByte[0];
        }
        TableCursor cursor = this.fTableViewer.getCursor();
        int col = cursor.getColumn();
        TableItem rowItem = cursor.getRow();
        if (col == 0 || col > this.getBytesPerLine() / this.getBytesPerColumn()) {
            return new MemoryByte[0];
        }
        Object data = rowItem.getData();
        if (data == null || !(data instanceof MemorySegment)) {
            return new MemoryByte[0];
        }
        MemorySegment line = (MemorySegment)((Object)data);
        int offset = (col - 1) * (this.getAddressableUnitPerColumn() * this.getAddressableSize());
        MemoryByte[] bytes = line.getBytes(offset, this.getAddressableUnitPerColumn() * this.getAddressableSize());
        MemoryByte[] retBytes = new MemoryByte[bytes.length];
        System.arraycopy(bytes, 0, retBytes, 0, bytes.length);
        return retBytes;
    }

    public String getSelectedAsString() {
        if (this.getSelectedAddress() == null) {
            return "";
        }
        TableCursor cursor = this.fTableViewer.getCursor();
        int col = cursor.getColumn();
        TableItem rowItem = cursor.getRow();
        int row = this.fTableViewer.getTable().indexOf(rowItem);
        if (col == 0) {
            return rowItem.getText(0);
        }
        if (col > this.getBytesPerLine() / this.getBytesPerColumn()) {
            return "";
        }
        TableItem tableItem = this.fTableViewer.getTable().getItem(row);
        return tableItem.getText(col);
    }

    public void goToAddress(BigInteger address) throws DebugException {
        if (this.fTableViewer.getVirtualContentModel() == null) {
            return;
        }
        int i = this.fTableViewer.getVirtualContentModel().indexOfKey(address);
        if (i >= 0) {
            this.fTableViewer.setSelection(address);
            this.updateSyncTopAddress(address);
            this.updateSyncSelectedAddress(address);
        } else {
            if (!(this.getMemoryBlock() instanceof IMemoryBlockExtension)) {
                Status stat = new Status(4, DebugUIPlugin.getUniqueIdentifier(), 5011, DebugUIMessages.AbstractTableRendering_11, null);
                DebugException e = new DebugException((IStatus)stat);
                throw e;
            }
            BigInteger startAdd = this.fContentDescriptor.getStartAddress();
            BigInteger endAdd = this.fContentDescriptor.getEndAddress();
            if (address.compareTo(startAdd) < 0 || address.compareTo(endAdd) > 0) {
                Status stat = new Status(4, DebugUIPlugin.getUniqueIdentifier(), 5011, DebugUIMessages.AbstractTableRendering_11, null);
                DebugException e = new DebugException((IStatus)stat);
                throw e;
            }
            this.fTableViewer.setSelection(address);
            this.reloadTable(address);
            this.updateSyncSelectedAddress(address);
            if (!this.isDynamicLoad()) {
                this.updateSyncPageStartAddress(address);
            }
            this.updateSyncTopAddress(address);
        }
    }

    public void refresh() {
        this.fTableViewer.refresh();
    }

    public void resizeColumnsToPreferredSize() {
        this.fTableViewer.resizeColumnsToPreferredSize();
        if (!this.fIsShowAddressColumn) {
            final TableColumn column = this.fTableViewer.getTable().getColumn(0);
            column.addControlListener(new ControlListener(){

                public void controlMoved(ControlEvent e) {
                }

                public void controlResized(ControlEvent e) {
                    column.removeControlListener((ControlListener)this);
                    column.setWidth(0);
                }
            });
        }
    }

    public void updateLabels() {
        this.updateRenderingLabel(true);
        if (this.fTableViewer != null) {
            this.setColumnHeadings();
            this.fTableViewer.formatViewer();
        }
    }

    protected void fillContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new Separator(EMPTY_MEMORY_GROUP));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.fResetMemoryBlockAction);
        menu.add((IAction)this.fGoToAddressAction);
        menu.add((IContributionItem)new Separator(EMPTY_NAVIGATION_GROUP));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.fFormatRenderingAction);
        if (!this.isDynamicLoad()) {
            menu.add((IContributionItem)new Separator());
            menu.add((IAction)this.fPrevAction);
            menu.add((IAction)this.fNextAction);
            menu.add((IContributionItem)new Separator(EMPTY_NON_AUTO_LOAD_GROUP));
        }
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.fReformatAction);
        menu.add((IAction)this.fToggleAddressColumnAction);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.fCopyToClipboardAction);
        menu.add((IAction)this.fPrintViewTabAction);
        if (this.fPropertiesDialogAction != null) {
            menu.add((IContributionItem)new Separator());
            menu.add((IAction)this.fPropertiesDialogAction);
            menu.add((IContributionItem)new Separator(EMPTY_PROPERTY_GROUP));
        }
        menu.add((IContributionItem)new Separator("additions"));
    }

    private int getPageSizeInUnits() {
        return this.fPageSize * this.getAddressableUnitPerLine();
    }

    private void getPageSizeFromPreference() {
        this.fPageSize = DebugUIPlugin.getDefault().getPreferenceStore().getInt("org.eclispe.debug.ui.memory.pageSize");
    }

    private void updateDynamicLoadProperty() {
        boolean value = DebugUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclpise.debug.ui.memory.dynamicLoad");
        if (value != this.isDynamicLoad()) {
            this.setDynamicLoad(value);
            if (!this.fIsDisposed) {
                if (this.isDynamicLoad()) {
                    this.fContentDescriptor.setPostBuffer(20);
                    this.fContentDescriptor.setPreBuffer(20);
                    this.fContentDescriptor.setNumLines(this.getNumberOfVisibleLines());
                } else {
                    this.fContentDescriptor.setPostBuffer(0);
                    this.fContentDescriptor.setPreBuffer(0);
                    this.fContentDescriptor.setNumLines(this.fPageSize);
                }
            }
        }
    }

    private void getDynamicLoadFromPreference() {
        this.setDynamicLoad(DebugUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclpise.debug.ui.memory.dynamicLoad"));
    }

    private boolean isDynamicLoad() {
        return this.fPresentationContext.isDynamicLoad();
    }

    private int getPageSize() {
        return this.fPageSize;
    }

    private int getNumLinesToLoad() {
        int numberOfLines = -1;
        numberOfLines = this.isDynamicLoad() ? this.getNumberOfVisibleLines() : this.getPageSize();
        return numberOfLines;
    }

    private void setDynamicLoad(boolean load) {
        this.fPresentationContext.setDynamicLoad(load);
    }

    private void handlePageStartAddressChanged(BigInteger address) {
        if (this.isDynamicLoad()) {
            return;
        }
        if (!(this.getMemoryBlock() instanceof IMemoryBlockExtension)) {
            return;
        }
        if (this.isMemoryBlockBaseAddressChanged()) {
            return;
        }
        if (this.fTableViewer.getKey(0).equals(address)) {
            return;
        }
        BigInteger start = this.fContentDescriptor.getStartAddress();
        BigInteger end = this.fContentDescriptor.getEndAddress();
        if (address.compareTo(start) < 0) {
            if (this.isAtTopLimit()) {
                return;
            }
            address = start;
        }
        if (address.compareTo(end) > 0) {
            if (this.isAtBottomLimit()) {
                return;
            }
            address = end.subtract(BigInteger.valueOf(this.getPageSizeInUnits()));
        }
        this.fContentDescriptor.setLoadAddress(address);
        final BigInteger finaladdress = address;
        Runnable runnable = new Runnable(){

            public void run() {
                AbstractAsyncTableRendering.this.fTableViewer.setTopIndex(finaladdress);
                AbstractAsyncTableRendering.this.refresh();
            }
        };
        this.runOnUIThread(runnable);
        this.updateSyncPageStartAddress(address);
        this.updateSyncTopAddress(address);
    }

    private void handleDyanicLoadChanged() {
        BigInteger pageStart = this.getTopVisibleAddress();
        this.updateSyncPageStartAddress(pageStart);
        this.updateDynamicLoadProperty();
        if (this.isDynamicLoad()) {
            this.refresh();
            this.fTableViewer.setTopIndex(pageStart);
        } else {
            this.handlePageStartAddressChanged(pageStart);
        }
    }

    public void becomesHidden() {
        this.fPendingSyncProperties = new PendingPropertyChanges();
        if (!this.fIsCreated) {
            super.becomesHidden();
            return;
        }
        if (!this.isVisible()) {
            super.becomesHidden();
            return;
        }
        super.becomesHidden();
        if (this.getMemoryBlock() instanceof IMemoryBlockExtension) {
            this.updateRenderingLabel(false);
        }
    }

    public void becomesVisible() {
        if (!this.fIsCreated) {
            super.becomesVisible();
            return;
        }
        if (this.isVisible()) {
            super.becomesVisible();
            return;
        }
        super.becomesVisible();
        if (this.fPendingSyncProperties != null) {
            BigInteger selectedAddress;
            boolean format = false;
            int rowSize = this.getBytesPerLine();
            if (this.fPendingSyncProperties.getRowSize() > 0) {
                format = true;
                rowSize = this.fPendingSyncProperties.getRowSize();
            }
            int colSize = this.getBytesPerColumn();
            if (this.fPendingSyncProperties.getColumnSize() > 0) {
                format = true;
                colSize = this.fPendingSyncProperties.getColumnSize();
            }
            if (format) {
                this.format(rowSize, colSize);
            }
            if ((selectedAddress = this.fPendingSyncProperties.getSelectedAddress()) != null) {
                this.fTableViewer.setSelection(selectedAddress);
            }
            this.updateDynamicLoadProperty();
            if (this.isDynamicLoad()) {
                BigInteger topVisibleAddress = this.fPendingSyncProperties.getTopVisibleAddress();
                if (topVisibleAddress != null) {
                    this.fContentDescriptor.setLoadAddress(topVisibleAddress);
                    this.fTableViewer.setTopIndex(topVisibleAddress);
                }
            } else if (!(this.getMemoryBlock() instanceof IMemoryBlockExtension)) {
                BigInteger topVisibleAddress = this.fPendingSyncProperties.getTopVisibleAddress();
                if (topVisibleAddress != null) {
                    this.fTableViewer.setTopIndex(topVisibleAddress);
                }
            } else {
                BigInteger pageStartAddress;
                if (this.fPendingSyncProperties.getPageSize() > 0) {
                    this.fPageSize = this.fPendingSyncProperties.getPageSize();
                    this.fContentDescriptor.setNumLines(this.fPageSize);
                }
                if ((pageStartAddress = this.fPendingSyncProperties.getPageStartAddress()) != null) {
                    this.fContentDescriptor.setLoadAddress(pageStartAddress);
                }
                this.fTableViewer.setTopIndex(pageStartAddress);
            }
            this.refresh();
        }
        this.updateRenderingLabel(true);
        Job job = new Job("becomesVisible"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    AbstractAsyncTableRendering.this.fContentDescriptor.updateContentBaseAddress();
                }
                catch (DebugException e) {
                    AbstractAsyncTableRendering.this.showMessage(e.getMessage());
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
        this.fPendingSyncProperties = null;
    }

    private void columnSizeChanged(final int newColumnSize) {
        if (!this.isVisible()) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                int rowSize = AbstractAsyncTableRendering.this.getBytesPerLine();
                if (rowSize < newColumnSize) {
                    rowSize = newColumnSize;
                }
                AbstractAsyncTableRendering.this.format(rowSize, newColumnSize);
            }
        });
    }

    private void rowSizeChanged(final int newRowSize) {
        if (!this.isVisible()) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                int size = newRowSize;
                if (size < AbstractAsyncTableRendering.this.getBytesPerColumn()) {
                    size = AbstractAsyncTableRendering.this.getBytesPerColumn();
                }
                AbstractAsyncTableRendering.this.format(size, AbstractAsyncTableRendering.this.getBytesPerColumn());
            }
        });
    }

    private void updateSyncSelectedAddress(BigInteger address) {
        if (!this.fIsCreated) {
            return;
        }
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, "selectedAddress", null, (Object)address);
        this.firePropertyChangedEvent(event);
    }

    private void updateSyncColSize() {
        if (!this.fIsCreated) {
            return;
        }
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, "columnSize", null, (Object)new Integer(this.fColumnSize));
        this.firePropertyChangedEvent(event);
    }

    private void updateSyncRowSize() {
        if (!this.fIsCreated) {
            return;
        }
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, "rowSize", null, (Object)new Integer(this.fBytePerLine));
        this.firePropertyChangedEvent(event);
    }

    private void updateSyncTopAddress(BigInteger address) {
        if (!this.fIsCreated) {
            return;
        }
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, "topAddress", null, (Object)address);
        this.firePropertyChangedEvent(event);
    }

    private void updateSyncPageStartAddress(BigInteger address) {
        if (!this.fIsCreated) {
            return;
        }
        if (this.isMemoryBlockBaseAddressChanged()) {
            return;
        }
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, "pageStart", null, (Object)address);
        this.firePropertyChangedEvent(event);
    }

    protected IColorProvider getColorProviderAdapter() {
        IMemoryBlock iMemoryBlock = this.getMemoryBlock();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jface.viewers.IColorProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IColorProvider)iMemoryBlock.getAdapter((Class)clazz);
    }

    protected ILabelProvider getLabelProviderAdapter() {
        IMemoryBlock iMemoryBlock = this.getMemoryBlock();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.jface.viewers.ILabelProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (ILabelProvider)iMemoryBlock.getAdapter((Class)clazz);
    }

    protected IFontProvider getFontProviderAdapter() {
        IMemoryBlock iMemoryBlock = this.getMemoryBlock();
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.jface.viewers.IFontProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IFontProvider)iMemoryBlock.getAdapter((Class)clazz);
    }

    protected IMemoryBlockTablePresentation getTablePresentationAdapter() {
        IMemoryBlock iMemoryBlock = this.getMemoryBlock();
        Class<?> clazz = class$6;
        if (clazz == null) {
            try {
                clazz = class$6 = Class.forName("org.eclipse.debug.ui.memory.IMemoryBlockTablePresentation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IMemoryBlockTablePresentation)iMemoryBlock.getAdapter((Class)clazz);
    }

    private void createToolTip() {
        this.fToolTipShell = new Shell(DebugUIPlugin.getShell(), 16400);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginWidth = 2;
        gridLayout.marginHeight = 0;
        this.fToolTipShell.setLayout((Layout)gridLayout);
        this.fToolTipShell.setBackground(this.fTableViewer.getTable().getDisplay().getSystemColor(29));
        final Control toolTipControl = this.createToolTipControl((Composite)this.fToolTipShell);
        if (toolTipControl == null) {
            this.fToolTipShell.dispose();
            return;
        }
        MouseTrackAdapter listener = new MouseTrackAdapter(){
            private TableItem fTooltipItem = null;
            private int fCol = -1;

            public void mouseExit(MouseEvent e) {
                if (!AbstractAsyncTableRendering.this.fToolTipShell.isDisposed()) {
                    AbstractAsyncTableRendering.this.fToolTipShell.setVisible(false);
                }
                this.fTooltipItem = null;
            }

            public void mouseHover(MouseEvent e) {
                Point hoverPoint = new Point(e.x, e.y);
                Control control = null;
                if (e.widget instanceof Control) {
                    control = (Control)e.widget;
                }
                if (control == null) {
                    return;
                }
                hoverPoint = control.toDisplay(hoverPoint);
                TableItem item = AbstractAsyncTableRendering.this.getItem(hoverPoint);
                int column = AbstractAsyncTableRendering.this.getColumn(hoverPoint);
                if (this.fTooltipItem != item || this.fCol != column) {
                    this.fTooltipItem = item;
                    this.fCol = column;
                    if (item != null) {
                        AbstractAsyncTableRendering.this.toolTipAboutToShow(toolTipControl, this.fTooltipItem, column);
                        Rectangle shellBounds = AbstractAsyncTableRendering.this.fToolTipShell.getBounds();
                        shellBounds.x = hoverPoint.x;
                        shellBounds.y = hoverPoint.y + item.getBounds((int)0).height;
                        AbstractAsyncTableRendering.this.fToolTipShell.setBounds(shellBounds);
                        AbstractAsyncTableRendering.this.fToolTipShell.pack();
                        AbstractAsyncTableRendering.this.fToolTipShell.setVisible(true);
                    } else {
                        AbstractAsyncTableRendering.this.fToolTipShell.setVisible(false);
                    }
                }
            }
        };
        this.fTableViewer.getTable().addMouseTrackListener((MouseTrackListener)listener);
        this.fTableViewer.getCursor().addMouseTrackListener((MouseTrackListener)listener);
    }

    protected Control createToolTipControl(Composite composite) {
        Label fToolTipLabel = new Label(composite, 0);
        fToolTipLabel.setForeground(this.fTableViewer.getTable().getDisplay().getSystemColor(28));
        fToolTipLabel.setBackground(this.fTableViewer.getTable().getDisplay().getSystemColor(29));
        fToolTipLabel.setLayoutData((Object)new GridData(772));
        return fToolTipLabel;
    }

    private TableItem getItem(Point point) {
        TableItem[] items = this.fTableViewer.getTable().getItems();
        int i = 0;
        while (i < items.length) {
            Point start = new Point(items[i].getBounds((int)0).x, items[i].getBounds((int)0).y);
            start = this.fTableViewer.getTable().toDisplay(start);
            Point end = new Point(start.x + items[i].getBounds((int)0).width, start.y + items[i].getBounds((int)0).height);
            if (start.y < point.y && point.y < end.y) {
                return items[i];
            }
            ++i;
        }
        return null;
    }

    private int getColumn(Point point) {
        int colCnt = this.fTableViewer.getTable().getColumnCount();
        TableItem item = this.fTableViewer.getTable().getItem(0);
        int i = 0;
        while (i < colCnt) {
            Point start = new Point(item.getBounds((int)i).x, item.getBounds((int)i).y);
            start = this.fTableViewer.getTable().toDisplay(start);
            Point end = new Point(start.x + item.getBounds((int)i).width, start.y + item.getBounds((int)i).height);
            if (start.x < point.x && end.x > point.x) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected void toolTipAboutToShow(Control toolTipControl, TableItem item, int col) {
        Object data;
        Object address;
        if (toolTipControl instanceof Label && (address = this.fTableViewer.getKey(this.fTableViewer.getTable().indexOf(item), col)) != null && address instanceof BigInteger && (data = item.getData()) instanceof MemorySegment) {
            MemorySegment line = (MemorySegment)((Object)data);
            if (col > 0) {
                int end;
                int start = (col - 1) * this.getBytesPerColumn();
                MemoryByte[] bytes = line.getBytes(start, end = start + this.getBytesPerColumn());
                String str = this.getToolTipText((BigInteger)address, bytes);
                if (str != null) {
                    ((Label)toolTipControl).setText(str);
                }
            } else {
                String str = this.getToolTipText((BigInteger)address, new MemoryByte[0]);
                if (str != null) {
                    ((Label)toolTipControl).setText(str);
                }
            }
        }
    }

    protected String getToolTipText(BigInteger address, MemoryByte[] bytes) {
        StringBuffer buf = new StringBuffer("0x");
        buf.append(address.toString(16).toUpperCase());
        return buf.toString();
    }

    private void setColumnHeadings() {
        String[] columnLabels = new String[]{};
        IMemoryBlockTablePresentation presentation = this.getTablePresentationAdapter();
        if (presentation != null) {
            columnLabels = presentation.getColumnLabels(this.getMemoryBlock(), this.getBytesPerLine(), this.getBytesPerLine() / this.getBytesPerColumn());
        }
        if (columnLabels == null) {
            columnLabels = new String[]{};
        }
        int numByteColumns = this.fBytePerLine / this.fColumnSize;
        TableColumn[] columns = this.fTableViewer.getTable().getColumns();
        int j = 0;
        int i = 1;
        while (i < columns.length - 1) {
            if (columnLabels.length == numByteColumns) {
                columns[i].setText(columnLabels[j]);
                ++j;
            } else {
                if (this.fColumnSize >= 4) {
                    columns[i].setText(String.valueOf(Integer.toHexString(j * this.fColumnSize).toUpperCase()) + " - " + Integer.toHexString(j * this.fColumnSize + this.fColumnSize - 1).toUpperCase());
                } else {
                    columns[i].setText(Integer.toHexString(j * this.fColumnSize).toUpperCase());
                }
                ++j;
            }
            ++i;
        }
    }

    public StructuredViewer getViewer() {
        return this.fTableViewer;
    }

    private boolean isMemoryBlockBaseAddressChanged() {
        try {
            BigInteger address = this.getMemoryBlockBaseAddress();
            BigInteger oldBaseAddress = this.fContentDescriptor.getContentBaseAddress();
            if (!oldBaseAddress.equals(address)) {
                return true;
            }
        }
        catch (DebugException debugException) {}
        return false;
    }

    public abstract String getString(String var1, BigInteger var2, MemoryByte[] var3);

    public abstract byte[] getBytes(String var1, BigInteger var2, MemoryByte[] var3, String var4);

    /*
     * Exception decompiling
     */
    private void createContentDescriptor(BigInteger topVisibleAddress) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 182->186)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static /* synthetic */ void access$19(AbstractAsyncTableRendering abstractAsyncTableRendering, AsyncTableRenderingViewer asyncTableRenderingViewer) {
        abstractAsyncTableRendering.fTableViewer = asyncTableRenderingViewer;
    }

    static /* synthetic */ void access$20(AbstractAsyncTableRendering abstractAsyncTableRendering, TableRenderingPresentationContext tableRenderingPresentationContext) {
        abstractAsyncTableRendering.fPresentationContext = tableRenderingPresentationContext;
    }

    static /* synthetic */ TableRenderingPresentationContext access$21(AbstractAsyncTableRendering abstractAsyncTableRendering) {
        return abstractAsyncTableRendering.fPresentationContext;
    }

    static /* synthetic */ void access$22(AbstractAsyncTableRendering abstractAsyncTableRendering) {
        abstractAsyncTableRendering.getDynamicLoadFromPreference();
    }

    static /* synthetic */ void access$23(AbstractAsyncTableRendering abstractAsyncTableRendering) {
        abstractAsyncTableRendering.getPageSizeFromPreference();
    }

    static /* synthetic */ int access$24(AbstractAsyncTableRendering abstractAsyncTableRendering) {
        return abstractAsyncTableRendering.getNumLinesToLoad();
    }

    static /* synthetic */ void access$25(AbstractAsyncTableRendering abstractAsyncTableRendering) {
        abstractAsyncTableRendering.setupInitialFormat();
    }

    static /* synthetic */ ICellModifier access$26(AbstractAsyncTableRendering abstractAsyncTableRendering) {
        return abstractAsyncTableRendering.createCellModifier();
    }

    static /* synthetic */ IPresentationErrorListener access$27(AbstractAsyncTableRendering abstractAsyncTableRendering) {
        return abstractAsyncTableRendering.fPresentationErrorListener;
    }

    static /* synthetic */ IVirtualContentListener access$28(AbstractAsyncTableRendering abstractAsyncTableRendering) {
        return abstractAsyncTableRendering.fViewerListener;
    }

    static /* synthetic */ void access$29(AbstractAsyncTableRendering abstractAsyncTableRendering, Control control, IMenuListener iMenuListener) {
        abstractAsyncTableRendering.createPopupMenu(control, iMenuListener);
    }

    static /* synthetic */ ISelectionChangedListener access$30(AbstractAsyncTableRendering abstractAsyncTableRendering) {
        return abstractAsyncTableRendering.fViewerSelectionChangedListener;
    }

    static /* synthetic */ SelectionAdapter access$31(AbstractAsyncTableRendering abstractAsyncTableRendering) {
        return abstractAsyncTableRendering.fScrollBarSelectionListener;
    }

    static /* synthetic */ void access$32(AbstractAsyncTableRendering abstractAsyncTableRendering) {
        abstractAsyncTableRendering.createToolTip();
    }

    static /* synthetic */ void access$33(AbstractAsyncTableRendering abstractAsyncTableRendering, boolean bl) {
        abstractAsyncTableRendering.fIsCreated = bl;
    }

    private class ToggleAddressColumnAction
    extends Action {
        public ToggleAddressColumnAction() {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, String.valueOf(IDebugUIConstants.PLUGIN_ID) + ".ShowAddressColumnAction_context");
            this.updateActionLabel();
        }

        public void run() {
            AbstractAsyncTableRendering.this.fIsShowAddressColumn = !AbstractAsyncTableRendering.this.fIsShowAddressColumn;
            if (!AbstractAsyncTableRendering.this.fIsShowAddressColumn) {
                AbstractAsyncTableRendering.this.fTableViewer.getTable().getColumn(0).setWidth(0);
            } else {
                AbstractAsyncTableRendering.this.fTableViewer.getTable().getColumn(0).pack();
            }
            this.updateActionLabel();
        }

        private void updateActionLabel() {
            if (AbstractAsyncTableRendering.this.fIsShowAddressColumn) {
                this.setText(DebugUIMessages.ShowAddressColumnAction_0);
            } else {
                this.setText(DebugUIMessages.ShowAddressColumnAction_1);
            }
        }
    }

    private class NextPageAction
    extends Action {
        NextPageAction() {
            this.setText(DebugUIMessages.AbstractTableRendering_4);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, String.valueOf(IDebugUIConstants.PLUGIN_ID) + ".NextPageAction_context");
        }

        public void run() {
            BigInteger address = AbstractAsyncTableRendering.this.fContentDescriptor.getLoadAddress();
            address = address.add(BigInteger.valueOf(AbstractAsyncTableRendering.this.getPageSizeInUnits()));
            AbstractAsyncTableRendering.this.handlePageStartAddressChanged(address);
        }
    }

    private class PrevPageAction
    extends Action {
        PrevPageAction() {
            this.setText(DebugUIMessages.AbstractTableRendering_6);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, String.valueOf(IDebugUIConstants.PLUGIN_ID) + ".PrevPageAction_context");
        }

        public void run() {
            BigInteger address = AbstractAsyncTableRendering.this.fContentDescriptor.getLoadAddress();
            address = address.subtract(BigInteger.valueOf(AbstractAsyncTableRendering.this.getPageSizeInUnits()));
            AbstractAsyncTableRendering.this.handlePageStartAddressChanged(address);
        }
    }
}

