/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory.renderings;

import java.math.BigInteger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.internal.ui.viewers.TableUpdatePolicy;
import org.eclipse.debug.internal.ui.viewers.provisional.IModelChangedListener;
import org.eclipse.debug.internal.ui.viewers.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.views.memory.renderings.AbstractAsyncTableRendering;
import org.eclipse.debug.internal.ui.views.memory.renderings.AbstractVirtualContentTableModel;
import org.eclipse.debug.internal.ui.views.memory.renderings.AsyncTableRenderingViewer;
import org.eclipse.debug.internal.ui.views.memory.renderings.IContentChangeComputer;
import org.eclipse.debug.internal.ui.views.memory.renderings.TableRenderingContentDescriptor;
import org.eclipse.debug.internal.ui.views.memory.renderings.TableRenderingPresentationContext;
import org.eclipse.ui.progress.UIJob;

class AsyncTableRenderingUpdatePolicy
extends TableUpdatePolicy {
    static /* synthetic */ Class class$0;

    AsyncTableRenderingUpdatePolicy() {
    }

    public void modelChanged(IModelDelta node) {
        AbstractVirtualContentTableModel model = this.getTableViewer().getVirtualContentModel();
        if (model != null) {
            IContentChangeComputer computer = null;
            if (model instanceof IContentChangeComputer) {
                computer = (IContentChangeComputer)((Object)model);
            }
            this.clearCache(computer);
            if (!this.containsEvent(node)) {
                return;
            }
            if (node.getElement() instanceof IMemoryBlock && (node.getFlags() & 0x400) != 0) {
                if (computer != null && this.getTableViewer() != null && !this.getTableViewer().getRendering().isDisplayingError()) {
                    computer.cache(model.getElements());
                }
                if (node.getElement() instanceof IMemoryBlock) {
                    this.notifyRendering(node);
                    this.handleMemoryBlockChanged((IMemoryBlock)node.getElement(), node);
                    return;
                }
            }
        }
        super.modelChanged(node);
    }

    protected void clearCache(IContentChangeComputer computer) {
        if (computer != null) {
            computer.clearCache();
        }
    }

    private void notifyRendering(IModelDelta node) {
        if (this.getTableViewer() != null) {
            IModelChangedListener listener;
            AbstractAsyncTableRendering abstractAsyncTableRendering = this.getTableViewer().getRendering();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.debug.internal.ui.viewers.provisional.IModelChangedListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((listener = (IModelChangedListener)abstractAsyncTableRendering.getAdapter(clazz)) != null) {
                listener.modelChanged(node);
            }
        }
    }

    protected void handleMemoryBlockChanged(IMemoryBlock mb, IModelDelta delta) {
        block6: {
            try {
                if (this.getViewer().getPresentationContext() instanceof TableRenderingPresentationContext) {
                    TableRenderingPresentationContext context = (TableRenderingPresentationContext)this.getViewer().getPresentationContext();
                    TableRenderingContentDescriptor descriptor = context.getContentDescriptor();
                    final AbstractAsyncTableRendering rendering = context.getTableRendering();
                    if (rendering != null) {
                        final BigInteger address = this.getMemoryBlockBaseAddress(mb);
                        if (!address.equals(descriptor.getContentBaseAddress())) {
                            descriptor.updateContentBaseAddress();
                            UIJob job = new UIJob("go to address"){

                                public IStatus runInUIThread(IProgressMonitor monitor) {
                                    block2: {
                                        try {
                                            rendering.goToAddress(address);
                                        }
                                        catch (DebugException e) {
                                            if (AsyncTableRenderingUpdatePolicy.this.getTableViewer() == null) break block2;
                                            AsyncTableRenderingUpdatePolicy.this.getTableViewer().handlePresentationFailure(null, e.getStatus());
                                        }
                                    }
                                    return Status.OK_STATUS;
                                }
                            };
                            job.setSystem(true);
                            job.schedule();
                        } else {
                            rendering.refresh();
                        }
                    }
                }
            }
            catch (DebugException e) {
                if (this.getTableViewer() == null) break block6;
                this.getTableViewer().handlePresentationFailure(null, e.getStatus());
            }
        }
    }

    private BigInteger getMemoryBlockBaseAddress(IMemoryBlock mb) throws DebugException {
        if (mb instanceof IMemoryBlockExtension) {
            return ((IMemoryBlockExtension)mb).getBigBaseAddress();
        }
        return BigInteger.valueOf(mb.getStartAddress());
    }

    private AsyncTableRenderingViewer getTableViewer() {
        if (this.getViewer() instanceof AsyncTableRenderingViewer) {
            return (AsyncTableRenderingViewer)this.getViewer();
        }
        return null;
    }

    private boolean containsEvent(IModelDelta delta) {
        AbstractAsyncTableRendering rendering;
        TableRenderingPresentationContext context;
        return !(this.getViewer().getPresentationContext() instanceof TableRenderingPresentationContext) || !((context = (TableRenderingPresentationContext)this.getViewer().getPresentationContext()).getRendering() instanceof AbstractAsyncTableRendering) || (rendering = (AbstractAsyncTableRendering)context.getRendering()).isVisible();
    }
}

