/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory.renderings;

import java.math.BigInteger;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.internal.ui.views.memory.renderings.AbstractAsyncTableRendering;
import org.eclipse.debug.ui.memory.AbstractTableRendering;
import org.eclipse.debug.ui.memory.IMemoryRendering;

public class TableRenderingContentInput
extends PlatformObject {
    private IMemoryRendering fRendering;
    private int fPreBuffer;
    private int fPostBuffer;
    private int fDefaultBufferSize;
    private BigInteger fLoadAddress;
    private int fNumLines;
    private boolean fUpdateDelta;
    private BigInteger fMemoryBlockBaseAddress;
    private BigInteger fStartAddress;
    private BigInteger fEndAddress;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public TableRenderingContentInput(IMemoryRendering rendering, int preBuffer, int postBuffer, int defaultBufferSize, BigInteger loadAddress, int numOfLines, boolean updateDelta, BigInteger contentBaseAddress) {
        this.fRendering = rendering;
        this.fPreBuffer = preBuffer;
        this.fPostBuffer = postBuffer;
        this.fLoadAddress = loadAddress;
        this.fNumLines = numOfLines;
        this.fDefaultBufferSize = defaultBufferSize;
        this.fUpdateDelta = updateDelta;
        if (contentBaseAddress == null) {
            try {
                this.updateContentBaseAddress();
            }
            catch (DebugException debugException) {}
        } else {
            this.fMemoryBlockBaseAddress = contentBaseAddress;
        }
    }

    public int getPostBuffer() {
        return this.fPostBuffer;
    }

    public int getPreBuffer() {
        return this.fPreBuffer;
    }

    public BigInteger getLoadAddress() {
        return this.fLoadAddress;
    }

    public IMemoryBlock getMemoryBlock() {
        return this.fRendering.getMemoryBlock();
    }

    public void setPostBuffer(int postBuffer) {
        this.fPostBuffer = postBuffer;
    }

    public void setPreBuffer(int preBuffer) {
        this.fPreBuffer = preBuffer;
    }

    public int getDefaultBufferSize() {
        return this.fDefaultBufferSize;
    }

    public void setDefaultBufferSize(int defaultBufferSize) {
        this.fDefaultBufferSize = defaultBufferSize;
    }

    public boolean isUpdateDelta() {
        return this.fUpdateDelta;
    }

    public void setUpdateDelta(boolean updateDelta) {
        this.fUpdateDelta = updateDelta;
    }

    public void setLoadAddress(BigInteger address) {
        this.fLoadAddress = address;
    }

    public BigInteger getContentBaseAddress() {
        if (this.fMemoryBlockBaseAddress == null) {
            try {
                this.updateContentBaseAddress();
            }
            catch (DebugException debugException) {
                this.fMemoryBlockBaseAddress = new BigInteger("0");
            }
        }
        return this.fMemoryBlockBaseAddress;
    }

    public void updateContentBaseAddress() throws DebugException {
        IMemoryBlock memoryBlock = this.fRendering.getMemoryBlock();
        this.fMemoryBlockBaseAddress = memoryBlock instanceof IMemoryBlockExtension ? ((IMemoryBlockExtension)memoryBlock).getBigBaseAddress() : BigInteger.valueOf(memoryBlock.getStartAddress());
    }

    public BigInteger getStartAddress() {
        if (this.fStartAddress == null) {
            try {
                BigInteger startAddress;
                IMemoryBlock memoryBlock = this.fRendering.getMemoryBlock();
                if (memoryBlock instanceof IMemoryBlockExtension && (startAddress = ((IMemoryBlockExtension)memoryBlock).getMemoryBlockStartAddress()) != null) {
                    this.fStartAddress = startAddress;
                }
            }
            catch (DebugException debugException) {
                this.fStartAddress = BigInteger.valueOf(0L);
            }
            if (this.fStartAddress == null) {
                this.fStartAddress = BigInteger.valueOf(0L);
            }
        }
        return this.fStartAddress;
    }

    public BigInteger getEndAddress() {
        if (this.fEndAddress == null) {
            IMemoryBlock memoryBlock = this.fRendering.getMemoryBlock();
            if (memoryBlock instanceof IMemoryBlockExtension) {
                BigInteger endAddress;
                try {
                    endAddress = ((IMemoryBlockExtension)memoryBlock).getMemoryBlockEndAddress();
                    if (endAddress != null) {
                        this.fEndAddress = endAddress;
                    }
                }
                catch (DebugException debugException) {
                    this.fEndAddress = null;
                }
                if (this.fEndAddress == null) {
                    int addressSize;
                    try {
                        addressSize = ((IMemoryBlockExtension)memoryBlock).getAddressSize();
                    }
                    catch (DebugException debugException) {
                        addressSize = 4;
                    }
                    endAddress = BigInteger.valueOf(2L);
                    endAddress = endAddress.pow(addressSize * 8);
                    this.fEndAddress = endAddress = endAddress.subtract(BigInteger.valueOf(1L));
                }
            }
            if (this.fEndAddress == null) {
                this.fEndAddress = BigInteger.valueOf(Integer.MAX_VALUE);
            }
        }
        return this.fEndAddress;
    }

    public int getNumLines() {
        return this.fNumLines;
    }

    public void setNumLines(int numLines) {
        this.fNumLines = numLines;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.debug.ui.memory.AbstractTableRendering");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz && this.fRendering instanceof AbstractTableRendering) {
            return this.fRendering;
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.debug.internal.ui.views.memory.renderings.AbstractAsyncTableRendering");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz2 && this.fRendering instanceof AbstractAsyncTableRendering) {
            return this.fRendering;
        }
        return super.getAdapter(adapter);
    }
}

