/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.runtime.registry;

import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.runtime.OverlayIcon;
import org.eclipse.pde.internal.runtime.PDERuntimeMessages;
import org.eclipse.pde.internal.runtime.PDERuntimePluginImages;
import org.eclipse.pde.internal.runtime.registry.IBundleFolder;
import org.eclipse.pde.internal.runtime.registry.IBundleLibrary;
import org.eclipse.pde.internal.runtime.registry.IBundlePrerequisite;
import org.eclipse.pde.internal.runtime.registry.IConfigurationAttribute;
import org.eclipse.pde.internal.runtime.registry.PluginObjectAdapter;
import org.eclipse.pde.internal.runtime.registry.RegistryBrowserContentProvider;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;

public class RegistryBrowserLabelProvider
extends LabelProvider {
    private Image pluginImage;
    private Image activePluginImage;
    private Image unresolvedPluginImage;
    private Image libraryImage;
    private Image runtimeImage;
    private Image genericTagImage;
    private Image genericAttrImage;
    private Image extensionImage;
    private Image extensionsImage;
    private Image extensionPointImage;
    private Image extensionPointsImage;
    private Image requiresImage;
    private Image expReqPluginImage;
    private Image reqPluginImage;
    private Image locationImage;
    private TreeViewer viewer;

    public RegistryBrowserLabelProvider(TreeViewer viewer) {
        this.viewer = viewer;
        this.pluginImage = PDERuntimePluginImages.DESC_PLUGIN_OBJ.createImage();
        this.reqPluginImage = PDERuntimePluginImages.DESC_REQ_PLUGIN_OBJ.createImage();
        this.extensionPointImage = PDERuntimePluginImages.DESC_EXT_POINT_OBJ.createImage();
        this.extensionPointsImage = PDERuntimePluginImages.DESC_EXT_POINTS_OBJ.createImage();
        this.extensionImage = PDERuntimePluginImages.DESC_EXTENSION_OBJ.createImage();
        this.extensionsImage = PDERuntimePluginImages.DESC_EXTENSIONS_OBJ.createImage();
        this.requiresImage = PDERuntimePluginImages.DESC_REQ_PLUGINS_OBJ.createImage();
        this.libraryImage = PDERuntimePluginImages.DESC_JAVA_LIB_OBJ.createImage();
        this.genericTagImage = PDERuntimePluginImages.DESC_GENERIC_XML_OBJ.createImage();
        this.genericAttrImage = PDERuntimePluginImages.DESC_ATTR_XML_OBJ.createImage();
        this.runtimeImage = PDERuntimePluginImages.DESC_RUNTIME_OBJ.createImage();
        this.locationImage = PDERuntimePluginImages.DESC_LOCATION.createImage();
        OverlayIcon activePluginDesc = new OverlayIcon(PDERuntimePluginImages.DESC_PLUGIN_OBJ, new ImageDescriptor[][]{{PDERuntimePluginImages.DESC_RUN_CO}});
        this.activePluginImage = activePluginDesc.createImage();
        OverlayIcon unresolvedPluginDesc = new OverlayIcon(PDERuntimePluginImages.DESC_PLUGIN_OBJ, new ImageDescriptor[][]{{PDERuntimePluginImages.DESC_ERROR_CO}});
        this.unresolvedPluginImage = unresolvedPluginDesc.createImage();
        OverlayIcon exportedRequiresDesc = new OverlayIcon(PDERuntimePluginImages.DESC_REQ_PLUGIN_OBJ, new ImageDescriptor[][]{{PDERuntimePluginImages.DESC_EXPORT_CO}});
        this.expReqPluginImage = exportedRequiresDesc.createImage();
    }

    public void dispose() {
        this.pluginImage.dispose();
        this.activePluginImage.dispose();
        this.unresolvedPluginImage.dispose();
        this.reqPluginImage.dispose();
        this.extensionPointImage.dispose();
        this.extensionPointsImage.dispose();
        this.extensionImage.dispose();
        this.extensionsImage.dispose();
        this.requiresImage.dispose();
        this.expReqPluginImage.dispose();
        this.libraryImage.dispose();
        this.genericTagImage.dispose();
        this.genericAttrImage.dispose();
        this.runtimeImage.dispose();
        this.locationImage.dispose();
    }

    public Image getImage(Object element) {
        if (element instanceof PluginObjectAdapter) {
            element = ((PluginObjectAdapter)((Object)element)).getObject();
        }
        if (element instanceof Bundle) {
            Bundle bundle = (Bundle)element;
            switch (bundle.getState()) {
                case 32: {
                    return this.activePluginImage;
                }
                case 4: {
                    return this.pluginImage;
                }
            }
            return this.unresolvedPluginImage;
        }
        if (element instanceof IBundleFolder) {
            int id = ((IBundleFolder)element).getFolderId();
            switch (id) {
                case 1: {
                    return this.extensionsImage;
                }
                case 2: {
                    return this.extensionPointsImage;
                }
                case 3: {
                    return this.requiresImage;
                }
                case 4: {
                    return this.runtimeImage;
                }
                case 0: {
                    return this.locationImage;
                }
            }
            return null;
        }
        if (element instanceof IExtension) {
            return this.extensionImage;
        }
        if (element instanceof IExtensionPoint) {
            return this.extensionPointImage;
        }
        if (element instanceof IBundlePrerequisite) {
            return ((IBundlePrerequisite)element).isExported() ? this.expReqPluginImage : this.reqPluginImage;
        }
        if (element instanceof IBundleLibrary) {
            return this.libraryImage;
        }
        if (element instanceof IConfigurationElement) {
            return this.genericTagImage;
        }
        if (element instanceof IConfigurationAttribute) {
            return this.genericAttrImage;
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof PluginObjectAdapter) {
            element = ((PluginObjectAdapter)((Object)element)).getObject();
        }
        if (element instanceof Bundle) {
            String id = ((Bundle)element).getSymbolicName();
            String version = (String)((Bundle)element).getHeaders().get("Bundle-Version");
            if (version == null) {
                return id;
            }
            return String.valueOf(id) + " (" + version + ")";
        }
        if (element instanceof IBundleFolder) {
            switch (((IBundleFolder)element).getFolderId()) {
                case 3: {
                    return PDERuntimeMessages.RegistryView_folders_imports;
                }
                case 4: {
                    return PDERuntimeMessages.RegistryView_folders_libraries;
                }
                case 2: {
                    return PDERuntimeMessages.RegistryView_folders_extensionPoints;
                }
                case 1: {
                    return PDERuntimeMessages.RegistryView_folders_extensions;
                }
                case 0: {
                    Bundle bundle = ((IBundleFolder)element).getBundle();
                    URL bundleEntry = bundle.getEntry("/");
                    try {
                        bundleEntry = FileLocator.resolve((URL)bundleEntry);
                    }
                    catch (IOException iOException) {}
                    Path path = new Path(bundleEntry.getFile());
                    String pathString = path.removeTrailingSeparator().toOSString();
                    if (pathString.startsWith("file:")) {
                        pathString = pathString.substring(5);
                    }
                    if (pathString.endsWith("!")) {
                        pathString = pathString.substring(0, pathString.length() - 1);
                    }
                    return pathString;
                }
            }
        }
        if (element instanceof IExtension) {
            if (((RegistryBrowserContentProvider)this.viewer.getContentProvider()).isInExtensionSet) {
                String name = ((IExtension)element).getLabel();
                String id = ((IExtension)element).getExtensionPointUniqueIdentifier();
                if (name != null && name.length() > 0) {
                    return NLS.bind((String)PDERuntimeMessages.RegistryBrowserLabelProvider_nameIdBind, (Object)id, (Object)name);
                }
                return id;
            }
            String contributor = ((IExtension)element).getNamespaceIdentifier();
            return NLS.bind((String)"contributed by: {0}", (Object)contributor);
        }
        if (element instanceof IExtensionPoint) {
            String id = ((IExtensionPoint)element).getUniqueIdentifier();
            String name = ((IExtensionPoint)element).getLabel();
            if (name != null && name.length() > 0) {
                return NLS.bind((String)PDERuntimeMessages.RegistryBrowserLabelProvider_nameIdBind, (Object)id, (Object)name);
            }
            return id;
        }
        if (element instanceof IBundlePrerequisite) {
            return ((IBundlePrerequisite)element).getLabel();
        }
        if (element instanceof IBundleLibrary) {
            return ((IBundleLibrary)element).getLibrary();
        }
        if (element instanceof IConfigurationElement) {
            String label = ((IConfigurationElement)element).getAttribute("label");
            if (label == null) {
                label = ((IConfigurationElement)element).getName();
            }
            if (label == null) {
                label = ((IConfigurationElement)element).getAttribute("name");
            }
            if (label == null && ((IConfigurationElement)element).getAttribute("id") != null) {
                String[] labelSplit = ((IConfigurationElement)element).getAttribute("id").split("\\.");
                label = labelSplit.length == 0 ? null : labelSplit[labelSplit.length - 1];
            }
            return label;
        }
        if (element instanceof IConfigurationAttribute) {
            return ((IConfigurationAttribute)element).getLabel();
        }
        return super.getText(element);
    }
}

