/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.internal.adaptor;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.core.runtime.internal.adaptor.EclipseAdaptorMsg;
import org.eclipse.core.runtime.internal.adaptor.IPluginInfo;
import org.eclipse.core.runtime.internal.adaptor.PluginParser;
import org.eclipse.osgi.framework.adaptor.FrameworkAdaptor;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.internal.baseadaptor.DevClassPathHelper;
import org.eclipse.osgi.service.pluginconversion.PluginConversionException;
import org.eclipse.osgi.service.pluginconversion.PluginConverter;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;

public class PluginConverterImpl
implements PluginConverter {
    public static boolean DEBUG = false;
    public static final byte MANIFEST_TYPE_UNKNOWN = 0;
    public static final byte MANIFEST_TYPE_BUNDLE = 1;
    public static final byte MANIFEST_TYPE_PLUGIN = 2;
    public static final byte MANIFEST_TYPE_FRAGMENT = 4;
    public static final byte MANIFEST_TYPE_JAR = 8;
    private static final String SEMICOLON = "; ";
    private static final String UTF_8 = "UTF-8";
    private static final String LIST_SEPARATOR = ",\n ";
    private static final String LINE_SEPARATOR = "\n ";
    private static final String DOT = ".";
    private static int MAXLINE = 511;
    private BundleContext context;
    private FrameworkAdaptor adaptor;
    private BufferedWriter out;
    private IPluginInfo pluginInfo;
    private File pluginManifestLocation;
    private Dictionary generatedManifest;
    private byte manifestType;
    private Version target;
    private Dictionary devProperties;
    static final Version TARGET31 = new Version(3, 1, 0);
    static final Version TARGET32 = new Version(3, 2, 0);
    private static final String MANIFEST_VERSION = "Manifest-Version";
    private static final String PLUGIN_PROPERTIES_FILENAME = "plugin";
    private static PluginConverterImpl instance;
    private static final String[] ARCH_LIST;
    public static final String FRAGMENT_MANIFEST = "fragment.xml";
    public static final String GENERATED_FROM = "Generated-from";
    public static final String MANIFEST_TYPE_ATTRIBUTE = "type";
    private static final String[] OS_LIST;
    protected static final String PI_RUNTIME = "org.eclipse.core.runtime";
    protected static final String PI_BOOT = "org.eclipse.core.boot";
    protected static final String PI_RUNTIME_COMPATIBILITY = "org.eclipse.core.runtime.compatibility";
    public static final String PLUGIN_MANIFEST = "plugin.xml";
    private static final String COMPATIBILITY_ACTIVATOR = "org.eclipse.core.internal.compatibility.PluginActivator";
    private static final String[] WS_LIST;
    private static final String IGNORE_DOT = "@ignoredot@";

    static {
        ARCH_LIST = new String[]{"PA_RISC", "ppc", "sparc", "x86", "x86_64", "ia64"};
        OS_LIST = new String[]{"aix", "hpux", "linux", "macosx", "qnx", "solaris", "win32"};
        WS_LIST = new String[]{"carbon", "gtk", "motif", "photon", "win32"};
    }

    public static PluginConverterImpl getDefault() {
        return instance;
    }

    public PluginConverterImpl(FrameworkAdaptor adaptor, BundleContext context) {
        this.context = context;
        this.adaptor = adaptor;
        instance = this;
    }

    private void init() {
        this.out = null;
        this.pluginInfo = null;
        this.pluginManifestLocation = null;
        this.generatedManifest = new Hashtable(10);
        this.manifestType = 0;
        this.target = null;
        this.devProperties = null;
    }

    private void fillPluginInfo(File pluginBaseLocation) throws PluginConversionException {
        this.pluginManifestLocation = pluginBaseLocation;
        if (this.pluginManifestLocation == null) {
            throw new IllegalArgumentException();
        }
        URL pluginFile = this.findPluginManifest(pluginBaseLocation);
        if (pluginFile == null) {
            throw new PluginConversionException(NLS.bind(EclipseAdaptorMsg.ECLIPSE_CONVERTER_FILENOTFOUND, pluginBaseLocation.getAbsolutePath()));
        }
        this.pluginInfo = this.parsePluginInfo(pluginFile);
        String validation = this.pluginInfo.validateForm();
        if (validation != null) {
            throw new PluginConversionException(validation);
        }
    }

    private Set filterExport(Collection exportToFilter, Collection filter) {
        if (filter == null || filter.contains("*")) {
            return (Set)exportToFilter;
        }
        HashSet<String> filteredExport = new HashSet<String>(exportToFilter.size());
        Iterator iter = exportToFilter.iterator();
        block0: while (iter.hasNext()) {
            String anExport = (String)iter.next();
            Iterator iter2 = filter.iterator();
            while (iter2.hasNext()) {
                String aFilter = (String)iter2.next();
                int dotStar = aFilter.indexOf(".*");
                if (dotStar != -1) {
                    aFilter = aFilter.substring(0, dotStar);
                }
                if (!anExport.equals(aFilter)) continue;
                filteredExport.add(anExport);
                continue block0;
            }
        }
        return filteredExport;
    }

    private ArrayList findOSJars(File pluginRoot, String path, boolean filter) {
        path = path.substring(4);
        ArrayList<String> found = new ArrayList<String>(0);
        int i = 0;
        while (i < OS_LIST.length) {
            String searchedPath = "os/" + OS_LIST[i] + "/" + path;
            if (new File(pluginRoot, searchedPath).exists()) {
                found.add(String.valueOf(searchedPath) + (filter ? ";(os=" + WS_LIST[i] + ")" : ""));
            }
            int j = 0;
            while (j < ARCH_LIST.length) {
                searchedPath = "os/" + OS_LIST[i] + "/" + ARCH_LIST[j] + "/" + path;
                if (new File(pluginRoot, searchedPath).exists()) {
                    found.add(String.valueOf(searchedPath) + (filter ? ";(& (os=" + WS_LIST[i] + ") (arch=" + ARCH_LIST[j] + ")" : ""));
                }
                ++j;
            }
            ++i;
        }
        return found;
    }

    /*
     * Exception decompiling
     */
    private URL findPluginManifest(File baseLocation) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 6[TRYBLOCK] [6 : 187->190)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ArrayList findWSJars(File pluginRoot, String path, boolean filter) {
        path = path.substring(4);
        ArrayList<String> found = new ArrayList<String>(0);
        int i = 0;
        while (i < WS_LIST.length) {
            String searchedPath = "ws/" + WS_LIST[i] + path;
            if (new File(pluginRoot, searchedPath).exists()) {
                found.add(String.valueOf(searchedPath) + (filter ? ";(ws=" + WS_LIST[i] + ")" : ""));
            }
            ++i;
        }
        return found;
    }

    protected void fillManifest(boolean compatibilityManifest, boolean analyseJars) {
        this.generateManifestVersion();
        this.generateHeaders();
        this.generateClasspath();
        this.generateActivator();
        this.generatePluginClass();
        if (analyseJars) {
            this.generateProvidePackage();
        }
        this.generateRequireBundle();
        this.generateLocalizationEntry();
        this.generateEclipseHeaders();
        if (compatibilityManifest) {
            this.generateTimestamp();
        }
    }

    /*
     * Exception decompiling
     */
    public void writeManifest(File generationLocation, Dictionary manifestToWrite, boolean compatibilityManifest) throws PluginConversionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 451->455)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void generateLocalizationEntry() {
        this.generatedManifest.put("Bundle-Localization", PLUGIN_PROPERTIES_FILENAME);
    }

    private void generateManifestVersion() {
        this.generatedManifest.put(MANIFEST_VERSION, "1.0");
    }

    private boolean requireRuntimeCompatibility() {
        ArrayList requireList = this.pluginInfo.getRequires();
        Iterator iter = requireList.iterator();
        while (iter.hasNext()) {
            if (!((PluginParser.Prerequisite)iter.next()).getName().equalsIgnoreCase(PI_RUNTIME_COMPATIBILITY)) continue;
            return true;
        }
        return false;
    }

    private void generateActivator() {
        if (!this.pluginInfo.isFragment()) {
            if (!this.requireRuntimeCompatibility()) {
                String pluginClass = this.pluginInfo.getPluginClass();
                if (pluginClass != null && !pluginClass.trim().equals("")) {
                    this.generatedManifest.put("Bundle-Activator", pluginClass);
                }
            } else {
                this.generatedManifest.put("Bundle-Activator", COMPATIBILITY_ACTIVATOR);
            }
        }
    }

    private void generateClasspath() {
        String[] classpath = this.pluginInfo.getLibrariesName();
        if (classpath.length != 0) {
            this.generatedManifest.put("Bundle-ClassPath", this.getStringFromArray(classpath, LIST_SEPARATOR));
        }
    }

    private void generateHeaders() {
        if (TARGET31.compareTo(this.target) <= 0) {
            this.generatedManifest.put("Bundle-ManifestVersion", "2");
        }
        this.generatedManifest.put("Bundle-Name", this.pluginInfo.getPluginName());
        this.generatedManifest.put("Bundle-Version", this.pluginInfo.getVersion());
        this.generatedManifest.put("Bundle-SymbolicName", this.getSymbolicNameEntry());
        String provider = this.pluginInfo.getProviderName();
        if (provider != null) {
            this.generatedManifest.put("Bundle-Vendor", provider);
        }
        if (this.pluginInfo.isFragment()) {
            StringBuffer hostBundle = new StringBuffer();
            hostBundle.append(this.pluginInfo.getMasterId());
            String versionRange = this.getVersionRange(this.pluginInfo.getMasterVersion(), this.pluginInfo.getMasterMatch());
            if (versionRange != null) {
                hostBundle.append(versionRange);
            }
            this.generatedManifest.put("Fragment-Host", hostBundle.toString());
        }
    }

    private String getSymbolicNameEntry() {
        if (!this.pluginInfo.isSingleton()) {
            return this.pluginInfo.getUniqueId();
        }
        StringBuffer result = new StringBuffer(this.pluginInfo.getUniqueId());
        result.append(SEMICOLON);
        result.append("singleton");
        String assignment = TARGET31.compareTo(this.target) <= 0 ? ":=" : "=";
        result.append(assignment).append("true");
        return result.toString();
    }

    private void generatePluginClass() {
        String pluginClass;
        if (this.requireRuntimeCompatibility() && (pluginClass = this.pluginInfo.getPluginClass()) != null) {
            this.generatedManifest.put("Plugin-Class", pluginClass);
        }
    }

    private void generateProvidePackage() {
        Set exports = this.getExports();
        if (exports != null && exports.size() != 0) {
            this.generatedManifest.put(TARGET31.compareTo(this.target) <= 0 ? "Export-Package" : "Provide-Package", this.getStringFromCollection(exports, LIST_SEPARATOR));
        }
    }

    private void generateRequireBundle() {
        ArrayList requiredBundles = this.pluginInfo.getRequires();
        if (requiredBundles.size() == 0) {
            return;
        }
        StringBuffer bundleRequire = new StringBuffer();
        Iterator iter = requiredBundles.iterator();
        while (iter.hasNext()) {
            PluginParser.Prerequisite element = (PluginParser.Prerequisite)iter.next();
            StringBuffer modImport = new StringBuffer(element.getName());
            String versionRange = this.getVersionRange(element.getVersion(), element.getMatch());
            if (versionRange != null) {
                modImport.append(versionRange);
            }
            if (element.isExported()) {
                if (TARGET31.compareTo(this.target) <= 0) {
                    modImport.append(';').append("visibility").append(":=").append("reexport");
                } else {
                    modImport.append(';').append("reprovide").append("=true");
                }
            }
            if (element.isOptional()) {
                if (TARGET31.compareTo(this.target) <= 0) {
                    modImport.append(';').append("resolution").append(":=").append("optional");
                } else {
                    modImport.append(';').append("optional").append("=true");
                }
            }
            bundleRequire.append(modImport.toString());
            if (!iter.hasNext()) continue;
            bundleRequire.append(LIST_SEPARATOR);
        }
        this.generatedManifest.put("Require-Bundle", bundleRequire.toString());
    }

    private void generateTimestamp() {
        this.generatedManifest.put(GENERATED_FROM, String.valueOf(Long.toString(PluginConverterImpl.getTimeStamp(this.pluginManifestLocation, this.manifestType))) + ";" + MANIFEST_TYPE_ATTRIBUTE + "=" + this.manifestType);
    }

    private void generateEclipseHeaders() {
        if (this.pluginInfo.isFragment()) {
            return;
        }
        String pluginClass = this.pluginInfo.getPluginClass();
        if (this.pluginInfo.hasExtensionExtensionPoints() || pluginClass != null && !pluginClass.trim().equals("")) {
            this.generatedManifest.put(TARGET32.compareTo(this.target) <= 0 ? "Eclipse-LazyStart" : "Eclipse-AutoStart", "true");
        }
    }

    private Set getExports() {
        Map libs = this.pluginInfo.getLibraries();
        if (libs == null) {
            return null;
        }
        if (this.devProperties != null || DevClassPathHelper.inDevelopmentMode()) {
            String[] devClassPath = DevClassPathHelper.getDevClassPath(this.pluginInfo.getUniqueId(), this.devProperties);
            ArrayList allExportClauses = new ArrayList(libs.size());
            Set libEntries = libs.entrySet();
            Iterator iter = libEntries.iterator();
            while (iter.hasNext()) {
                Map.Entry element = iter.next();
                allExportClauses.addAll((List)element.getValue());
            }
            if (devClassPath != null) {
                String[] ignoreDotProp = DevClassPathHelper.getDevClassPath(IGNORE_DOT, this.devProperties);
                if (devClassPath.length > 0 && ignoreDotProp != null && ignoreDotProp.length > 0 && "true".equals(ignoreDotProp[0])) {
                    libs.remove(DOT);
                }
                int i = 0;
                while (i < devClassPath.length) {
                    libs.put(devClassPath[i], allExportClauses);
                    ++i;
                }
            }
        }
        TreeSet result = new TreeSet();
        Set libEntries = libs.entrySet();
        Iterator iter = libEntries.iterator();
        while (iter.hasNext()) {
            Set exports;
            block10: {
                List filter;
                Map.Entry element;
                block8: {
                    File libraryLocation;
                    block9: {
                        File libEntryAsPath;
                        element = iter.next();
                        filter = (List)element.getValue();
                        if (filter.size() == 0) continue;
                        String libEntryText = ((String)element.getKey()).trim();
                        libraryLocation = libEntryText.equals(DOT) ? this.pluginManifestLocation : ((libEntryAsPath = new File(libEntryText)).isAbsolute() ? libEntryAsPath : new File(this.pluginManifestLocation, libEntryText));
                        exports = null;
                        if (!libraryLocation.exists()) break block8;
                        if (!libraryLocation.isFile()) break block9;
                        exports = this.filterExport(this.getExportsFromJAR(libraryLocation), filter);
                        break block10;
                    }
                    if (!libraryLocation.isDirectory()) break block10;
                    exports = this.filterExport(this.getExportsFromDir(libraryLocation), filter);
                    break block10;
                }
                ArrayList expandedLibs = this.getLibrariesExpandingVariables((String)element.getKey(), false);
                exports = new HashSet();
                Iterator iterator = expandedLibs.iterator();
                while (iterator.hasNext()) {
                    String libName = (String)iterator.next();
                    File libFile = new File(this.pluginManifestLocation, libName);
                    if (!libFile.isFile()) continue;
                    exports.addAll(this.filterExport(this.getExportsFromJAR(libFile), filter));
                }
            }
            if (exports == null) continue;
            result.addAll(exports);
        }
        return result;
    }

    private Set getExportsFromDir(File location) {
        return this.getExportsFromDir(location, "");
    }

    private Set getExportsFromDir(File location, String packageName) {
        String prefix = packageName.length() > 0 ? String.valueOf(packageName) + '.' : "";
        String[] files = location.list();
        HashSet<String> exportedPaths = new HashSet<String>();
        boolean containsFile = false;
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                if (this.isValidPackageName(files[i])) {
                    File pkgFile = new File(location, files[i]);
                    if (pkgFile.isDirectory()) {
                        exportedPaths.addAll(this.getExportsFromDir(pkgFile, String.valueOf(prefix) + files[i]));
                    } else {
                        containsFile = true;
                    }
                }
                ++i;
            }
        }
        if (containsFile) {
            if (packageName.length() > 0) {
                exportedPaths.add(packageName);
            } else {
                exportedPaths.add(DOT);
            }
        }
        return exportedPaths;
    }

    private Set getExportsFromJAR(File jarFile) {
        HashSet<String> names = new HashSet<String>();
        JarFile file = null;
        try {
            file = new JarFile(jarFile);
        }
        catch (IOException e) {
            String message = NLS.bind(EclipseAdaptorMsg.ECLIPSE_CONVERTER_PLUGIN_LIBRARY_IGNORED, jarFile, this.pluginInfo.getUniqueId());
            this.adaptor.getFrameworkLog().log(new FrameworkLogEntry("org.eclipse.osgi", 4, 0, message, 0, e, null));
            return names;
        }
        Enumeration<JarEntry> entriesEnum = file.entries();
        while (entriesEnum.hasMoreElements()) {
            JarEntry entry = entriesEnum.nextElement();
            String name = entry.getName();
            if (!this.isValidPackageName(name)) continue;
            int lastSlash = name.lastIndexOf("/");
            if (lastSlash != -1) {
                if (lastSlash == name.length() - 1 || name.lastIndexOf(32) != -1) continue;
                names.add(name.substring(0, lastSlash).replace('/', '.'));
                continue;
            }
            names.add(DOT);
        }
        try {
            file.close();
        }
        catch (IOException iOException) {}
        return names;
    }

    private ArrayList getLibrariesExpandingVariables(String libraryPath, boolean filter) {
        String var = this.hasPrefix(libraryPath);
        if (var == null) {
            ArrayList<String> returnValue = new ArrayList<String>(1);
            returnValue.add(libraryPath);
            return returnValue;
        }
        if (var.equals("ws")) {
            return this.findWSJars(this.pluginManifestLocation, libraryPath, filter);
        }
        if (var.equals("os")) {
            return this.findOSJars(this.pluginManifestLocation, libraryPath, filter);
        }
        return new ArrayList(0);
    }

    private String hasPrefix(String libPath) {
        if (libPath.startsWith("$ws$")) {
            return "ws";
        }
        if (libPath.startsWith("$os$")) {
            return "os";
        }
        if (libPath.startsWith("$nl$")) {
            return "nl";
        }
        return null;
    }

    private boolean isValidPackageName(String name) {
        return name.indexOf(32) <= 0 && !name.equalsIgnoreCase("META-INF") && !name.startsWith("META-INF/");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IPluginInfo parsePluginInfo(URL pluginLocation) throws PluginConversionException {
        PluginParser.PluginInfo pluginInfo;
        BufferedInputStream input = null;
        try {
            try {
                input = new BufferedInputStream(pluginLocation.openStream());
                pluginInfo = new PluginParser(this.adaptor, this.context, this.target).parsePlugin(input);
                Object var5_4 = null;
                if (input == null) return pluginInfo;
            }
            catch (Exception e) {
                String message = NLS.bind(EclipseAdaptorMsg.ECLIPSE_CONVERTER_ERROR_PARSING_PLUGIN_MANIFEST, this.pluginManifestLocation);
                throw new PluginConversionException(message, e);
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (input == null) throw throwable;
            try {
                ((InputStream)input).close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw throwable;
            }
        }
        try {}
        catch (IOException iOException) {}
        ((InputStream)input).close();
        return pluginInfo;
    }

    /*
     * Exception decompiling
     */
    public static boolean upToDate(File generationLocation, File pluginLocation, byte manifestType) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 85->88)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static long getTimeStamp(File pluginLocation, byte manifestType) {
        if ((manifestType & 8) != 0) {
            return pluginLocation.lastModified();
        }
        if ((manifestType & 2) != 0) {
            return new File(pluginLocation, PLUGIN_MANIFEST).lastModified();
        }
        if ((manifestType & 4) != 0) {
            return new File(pluginLocation, FRAGMENT_MANIFEST).lastModified();
        }
        if ((manifestType & 1) != 0) {
            return new File(pluginLocation, "META-INF/MANIFEST.MF").lastModified();
        }
        return -1L;
    }

    private void writeEntry(String key, String value) throws IOException {
        if (value != null && value.length() > 0) {
            this.out.write(this.splitOnComma(String.valueOf(key) + ": " + value));
            this.out.write(10);
        }
    }

    private String splitOnComma(String value) {
        if (value.length() < MAXLINE || value.indexOf(LINE_SEPARATOR) >= 0) {
            return value;
        }
        String[] values = ManifestElement.getArrayFromList(value);
        if (values == null || values.length == 0) {
            return value;
        }
        StringBuffer sb = new StringBuffer(value.length() + (values.length - 1) * LIST_SEPARATOR.length());
        int i = 0;
        while (i < values.length - 1) {
            sb.append(values[i]).append(LIST_SEPARATOR);
            ++i;
        }
        sb.append(values[values.length - 1]);
        return sb.toString();
    }

    private String getStringFromArray(String[] values, String separator) {
        if (values == null) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < values.length) {
            if (i > 0) {
                result.append(separator);
            }
            result.append(values[i]);
            ++i;
        }
        return result.toString();
    }

    private String getStringFromCollection(Collection collection, String separator) {
        StringBuffer result = new StringBuffer();
        boolean first = true;
        Iterator i = collection.iterator();
        while (i.hasNext()) {
            if (first) {
                first = false;
            } else {
                result.append(separator);
            }
            result.append(i.next());
        }
        return result.toString();
    }

    public synchronized Dictionary convertManifest(File pluginBaseLocation, boolean compatibility, String target, boolean analyseJars, Dictionary devProperties) throws PluginConversionException {
        if (DEBUG) {
            System.out.println("Convert " + pluginBaseLocation);
        }
        this.init();
        this.target = target == null ? TARGET32 : new Version(target);
        this.devProperties = devProperties;
        this.fillPluginInfo(pluginBaseLocation);
        this.fillManifest(compatibility, analyseJars);
        return this.generatedManifest;
    }

    public synchronized File convertManifest(File pluginBaseLocation, File bundleManifestLocation, boolean compatibilityManifest, String target, boolean analyseJars, Dictionary devProperties) throws PluginConversionException {
        this.convertManifest(pluginBaseLocation, compatibilityManifest, target, analyseJars, devProperties);
        if (bundleManifestLocation == null) {
            String cacheLocation = FrameworkProperties.getProperty("osgi.manifest.cache");
            bundleManifestLocation = new File(cacheLocation, String.valueOf(this.pluginInfo.getUniqueId()) + '_' + this.pluginInfo.getVersion() + ".MF");
        }
        if (PluginConverterImpl.upToDate(bundleManifestLocation, this.pluginManifestLocation, this.manifestType)) {
            return bundleManifestLocation;
        }
        this.writeManifest(bundleManifestLocation, this.generatedManifest, compatibilityManifest);
        return bundleManifestLocation;
    }

    private String getVersionRange(String reqVersion, String matchRule) {
        if (reqVersion == null) {
            return null;
        }
        Version minVersion = Version.parseVersion(reqVersion);
        String versionRange = matchRule != null ? (matchRule.equalsIgnoreCase("perfect") ? new VersionRange(minVersion, true, minVersion, true).toString() : (matchRule.equalsIgnoreCase("equivalent") ? new VersionRange(minVersion, true, new Version(minVersion.getMajor(), minVersion.getMinor() + 1, 0, ""), false).toString() : (matchRule.equalsIgnoreCase("compatible") ? new VersionRange(minVersion, true, new Version(minVersion.getMajor() + 1, 0, 0, ""), false).toString() : (matchRule.equalsIgnoreCase("greaterOrEqual") ? reqVersion : new VersionRange(minVersion, true, new Version(minVersion.getMajor() + 1, 0, 0, ""), false).toString())))) : new VersionRange(minVersion, true, new Version(minVersion.getMajor() + 1, 0, 0, ""), false).toString();
        StringBuffer result = new StringBuffer();
        result.append(';').append("bundle-version").append('=');
        result.append('\"').append(versionRange).append('\"');
        return result.toString();
    }
}

