/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui.text2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.search2.internal.ui.SearchMessages;
import org.eclipse.search2.internal.ui.text2.EditorDescriptorLabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;

public class FilePatternSelectionDialog
extends SelectionDialog {
    static final String FILE_PATTERN_SEPERATOR = ",";
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 250;
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 300;
    private String fInitialSelection;
    private CheckboxTableViewer fListViewer;
    private String fResult;
    private Object[] fInput;

    public FilePatternSelectionDialog(Shell parentShell, String string) {
        super(parentShell);
        this.setTitle(SearchMessages.FilePatternSelectionDialog_title);
        this.fInitialSelection = string;
        this.setMessage(SearchMessages.FilePatternSelectionDialog_message);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createMessageArea(composite);
        this.fListViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
        GridData data = new GridData(1808);
        data.heightHint = 250;
        data.widthHint = 300;
        this.fListViewer.getTable().setLayoutData((Object)data);
        this.fListViewer.setLabelProvider((IBaseLabelProvider)EditorDescriptorLabelProvider.INSTANCE);
        this.fListViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.addSelectionButtons(composite);
        this.initializeViewer(this.fInitialSelection);
        FilePatternSelectionDialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void addSelectionButtons(Composite composite) {
        Composite buttonComposite = new Composite(composite, 131072);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        buttonComposite.setLayout((Layout)layout);
        GridData data = new GridData(640);
        data.grabExcessHorizontalSpace = true;
        composite.setData((Object)data);
        Button selectButton = this.createButton(buttonComposite, 18, SearchMessages.FilePatternSelectionDialog_selectAll, false);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilePatternSelectionDialog.this.getListViewer().setAllChecked(true);
            }
        };
        selectButton.addSelectionListener((SelectionListener)listener);
        Button deselectButton = this.createButton(buttonComposite, 19, SearchMessages.FilePatternSelectionDialog_deselectAll, false);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilePatternSelectionDialog.this.getListViewer().setAllChecked(false);
            }
        };
        deselectButton.addSelectionListener((SelectionListener)listener);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
    }

    private void initializeViewer(String initialSelection) {
        IContentTypeManager ctm = Platform.getContentTypeManager();
        IContentType[] cts = ctm.getAllContentTypes();
        IContentType txtCt = ctm.getContentType("org.eclipse.core.runtime.text");
        HashMap<Object, HashSet> editorToExtensions = new HashMap<Object, HashSet>();
        int i = 0;
        while (i < cts.length) {
            IContentType ct = cts[i];
            if (ct.isKindOf(txtCt)) {
                String[] exts = ct.getFileSpecs(8);
                String[] files = ct.getFileSpecs(4);
                if (files.length > 30) {
                    files = new String[]{};
                }
                if (exts.length > 0 || files.length > 0) {
                    int j;
                    IEditorDescriptor editorDescriptor = this.searchForEditor(exts, files, ct);
                    HashSet<String> patterns = (HashSet<String>)editorToExtensions.get(editorDescriptor);
                    if (patterns == null) {
                        patterns = new HashSet<String>();
                        editorToExtensions.put(editorDescriptor, patterns);
                    }
                    if (exts.length > 0) {
                        j = 0;
                        while (j < exts.length) {
                            patterns.add("*." + exts[j]);
                            ++j;
                        }
                    }
                    if (files.length > 0) {
                        j = 0;
                        while (j < files.length) {
                            String file = files[j];
                            int idx = file.lastIndexOf(46);
                            if (idx >= 0) {
                                patterns.add("*" + file.substring(idx));
                            } else {
                                patterns.add(file);
                            }
                            ++j;
                        }
                    }
                }
            }
            ++i;
        }
        HashMap<Object, HashSet> oldMap = editorToExtensions;
        editorToExtensions = new HashMap();
        Iterator iter = oldMap.entrySet().iterator();
        while (iter.hasNext()) {
            boolean ignore = false;
            Map.Entry entry = iter.next();
            HashSet patterns = (HashSet)entry.getValue();
            Iterator iter2 = editorToExtensions.values().iterator();
            while (iter2.hasNext()) {
                HashSet patterns2 = (HashSet)iter2.next();
                if (patterns.size() <= patterns2.size()) {
                    if (!patterns2.containsAll(patterns)) continue;
                    ignore = true;
                    continue;
                }
                if (!patterns.containsAll(patterns2)) continue;
                iter2.remove();
            }
            if (ignore) continue;
            editorToExtensions.put(entry.getKey(), patterns);
        }
        HashSet<String> initialPatterns = new HashSet<String>();
        HashSet<String> remainingPatterns = new HashSet<String>();
        if (initialPatterns != null) {
            List<String> helper = Arrays.asList(initialSelection.split(FILE_PATTERN_SEPERATOR));
            Iterator<String> iter2 = helper.iterator();
            while (iter2.hasNext()) {
                String element = iter2.next();
                if ((element = element.trim()).length() <= 0) continue;
                initialPatterns.add(element);
                remainingPatterns.add(element);
            }
        }
        Comparator stringComparator = new Comparator(){

            public int compare(Object arg0, Object arg1) {
                String s1 = (String)arg0;
                String s2 = (String)arg1;
                int cmp = s1.compareToIgnoreCase(s2);
                if (cmp == 0) {
                    cmp = -s1.compareTo(s2);
                }
                return cmp;
            }
        };
        TreeMap filePatterns = new TreeMap(stringComparator);
        ArrayList checkmark = new ArrayList();
        Iterator iter3 = editorToExtensions.entrySet().iterator();
        while (iter3.hasNext()) {
            Map.Entry entry = iter3.next();
            Collection extensions = (Collection)entry.getValue();
            Object editor = entry.getKey();
            filePatterns.put(this.combineExtensions(extensions, stringComparator), editor);
            if (!initialPatterns.containsAll(extensions)) continue;
            checkmark.add(editor);
            remainingPatterns.removeAll(extensions);
        }
        if (!remainingPatterns.isEmpty()) {
            filePatterns.put(this.combineExtensions(remainingPatterns, stringComparator), null);
            checkmark.add(null);
        }
        this.fInput = filePatterns.entrySet().toArray();
        this.fListViewer.setInput((Object)this.fInput);
        int i2 = 0;
        while (i2 < this.fInput.length) {
            Map.Entry element = (Map.Entry)this.fInput[i2];
            if (checkmark.contains(element.getValue())) {
                this.fListViewer.setChecked((Object)element, true);
            }
            ++i2;
        }
    }

    private IEditorDescriptor searchForEditor(String[] exts, String[] files, IContentType ct) {
        IEditorRegistry reg = PlatformUI.getWorkbench().getEditorRegistry();
        int i = 0;
        while (i < exts.length) {
            String ext = exts[i];
            String sample = "file." + ext;
            IEditorDescriptor ed = reg.getDefaultEditor(sample, ct);
            if (ed != null) {
                return ed;
            }
            ++i;
        }
        i = 0;
        while (i < files.length) {
            String file = files[i];
            IEditorDescriptor ed = reg.getDefaultEditor(file, ct);
            if (ed != null) {
                return ed;
            }
            ++i;
        }
        return null;
    }

    private String combineExtensions(Collection input, Comparator comp) {
        ArrayList extensions = new ArrayList();
        extensions.addAll(input);
        Collections.sort(extensions, comp);
        String last = null;
        boolean needSep = false;
        StringBuffer pattern = new StringBuffer();
        Iterator iterator = extensions.iterator();
        while (iterator.hasNext()) {
            String extension = (String)iterator.next();
            if (extension.equals(last)) continue;
            if (needSep) {
                pattern.append(FILE_PATTERN_SEPERATOR);
            }
            needSep = true;
            pattern.append(extension);
            last = extension;
        }
        return pattern.toString();
    }

    protected void okPressed() {
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < this.fInput.length) {
            Map.Entry element = (Map.Entry)this.fInput[i];
            if (this.fListViewer.getChecked((Object)element)) {
                String pattern = (String)element.getKey();
                list.addAll(Arrays.asList(pattern.split(FILE_PATTERN_SEPERATOR)));
            }
            ++i;
        }
        this.setResult(list);
        this.fResult = this.combineExtensions(list, String.CASE_INSENSITIVE_ORDER);
        super.okPressed();
    }

    protected CheckboxTableViewer getListViewer() {
        return this.fListViewer;
    }

    public String getFilePatterns() {
        return this.fResult;
    }
}

