/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui.text2;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.search.internal.core.text.FileNamePatternSearchScope;
import org.eclipse.search2.internal.ui.SearchMessages;
import org.eclipse.search2.internal.ui.text2.FindInRecentScopeActionDelegate;
import org.eclipse.search2.internal.ui.text2.RetrieverQuery;
import org.eclipse.search2.internal.ui.text2.SelectedResourcesScopeDescription;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class FindInProjectActionDelegate
extends FindInRecentScopeActionDelegate {
    private IEditorPart fEditor = null;

    public FindInProjectActionDelegate() {
        super(SearchMessages.FindInProjectActionDelegate_text);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IEditorPart editor;
        IWorkbenchPart part;
        this.fEditor = null;
        IWorkbenchPage page = this.getWorkbenchPage();
        if (page != null && (part = page.getActivePart()) instanceof IEditorPart && (editor = (IEditorPart)part).getEditorInput() instanceof IFileEditorInput) {
            this.fEditor = editor;
        }
        action.setEnabled(this.fEditor != null);
    }

    public void setActiveEditor(IAction action, IEditorPart editor) {
        this.fEditor = editor != null && editor.getEditorInput() instanceof IFileEditorInput ? editor : null;
        super.setActiveEditor(action, this.fEditor);
    }

    protected boolean modifyQuery(RetrieverQuery query) {
        IProject proj;
        if (super.modifyQuery(query) && (proj = this.getCurrentProject()) != null) {
            query.setSearchScope(new SelectedResourcesScopeDescription(new IResource[]{proj}, false));
            return true;
        }
        return false;
    }

    protected IProject getCurrentProject() {
        IEditorInput ei;
        if (this.fEditor != null && (ei = this.fEditor.getEditorInput()) instanceof IFileEditorInput) {
            return ((IFileEditorInput)ei).getFile().getProject();
        }
        return null;
    }

    protected FileNamePatternSearchScope getOldSearchScope(boolean includeDerived) {
        IProject proj = this.getCurrentProject();
        if (proj != null) {
            return FileNamePatternSearchScope.newSearchScope(SearchMessages.FindInProjectActionDelegate_scope_label, new IResource[]{proj}, includeDerived);
        }
        return FileNamePatternSearchScope.newWorkspaceScope(includeDerived);
    }
}

