/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui.text2;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.search2.internal.ui.text2.IFileSorter;

public class HierarchicalFileSorter
implements IFileSorter {
    private static final Object FILE_KEY = new Object();
    private Collator fCollator;
    private Comparator fFilenameComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            return HierarchicalFileSorter.this.fCollator.compare(((IResource)o1).getName(), ((IResource)o2).getName());
        }
    };

    public HierarchicalFileSorter(Collator collator) {
        this.fCollator = collator;
    }

    public void sortFiles(IFile[] files) {
        HashMap map;
        HashMap all = new HashMap();
        ArrayList roots = new ArrayList();
        int i = 0;
        while (i < files.length) {
            IFile file = files[i];
            map = this.getMap(roots, all, file.getParent());
            ArrayList<IFile> list = (ArrayList<IFile>)map.get(FILE_KEY);
            if (list == null) {
                list = new ArrayList<IFile>();
                map.put(FILE_KEY, list);
            }
            list.add(file);
            ++i;
        }
        int nextIndex = 0;
        Iterator iterator = roots.iterator();
        while (iterator.hasNext()) {
            map = (HashMap)iterator.next();
            nextIndex = this.addToList(map, files, nextIndex);
        }
    }

    private int addToList(HashMap map, IFile[] files, int nextIndex) {
        List localFiles = (List)map.remove(FILE_KEY);
        ArrayList folders = new ArrayList(map.keySet());
        Collections.sort(folders, this.fFilenameComparator);
        int i = 0;
        while (i < folders.size()) {
            Object folder = folders.get(i);
            nextIndex = this.addToList((HashMap)map.get(folder), files, nextIndex);
            ++i;
        }
        if (localFiles != null) {
            Collections.sort(localFiles, this.fFilenameComparator);
            Iterator iter = localFiles.iterator();
            while (iter.hasNext()) {
                files[nextIndex++] = (IFile)iter.next();
            }
        }
        return nextIndex;
    }

    private HashMap getMap(ArrayList roots, HashMap all, IContainer cont) {
        HashMap result = (HashMap)all.get(cont);
        if (result == null) {
            result = new HashMap();
            if (cont.getType() == 4) {
                roots.add(result);
            } else {
                HashMap parentMap = this.getMap(roots, all, cont.getParent());
                parentMap.put(cont, result);
            }
            all.put(cont, result);
        }
        return result;
    }
}

