/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui.text2;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.internal.ui.text.SearchAgainConfirmationDialog;
import org.eclipse.search2.internal.ui.InternalSearchUI;
import org.eclipse.search2.internal.ui.Messages;
import org.eclipse.search2.internal.ui.SearchMessages;
import org.eclipse.search2.internal.ui.text.PositionTracker;
import org.eclipse.search2.internal.ui.text2.RetrieverLine;
import org.eclipse.search2.internal.ui.text2.RetrieverMatch;
import org.eclipse.search2.internal.ui.text2.RetrieverPage;
import org.eclipse.search2.internal.ui.text2.RetrieverResult;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ReplaceAction
extends Action {
    private RetrieverPage fView;
    private Shell fShell;
    private RetrieverResult fSearchResult;
    private String fDialogTitle;
    private boolean fSuccess;
    private Pattern fPattern;
    private String fReplacement;
    private boolean fReplace;
    private RetrieverMatch fMatch;
    private HashSet fFileSet;
    private Map fLineMap;

    public ReplaceAction(RetrieverPage retriever, String action, boolean replace) {
        this.init(retriever, action, replace);
        this.setupReplaceAll();
    }

    public ReplaceAction(RetrieverPage retriever, String action, boolean replace, IStructuredSelection sel) {
        this.init(retriever, action, replace);
        this.setupReplaceSelection(sel);
    }

    public ReplaceAction(RetrieverPage retriever, String action, boolean replace, RetrieverMatch match) {
        this.init(retriever, action, replace);
        this.fMatch = match;
    }

    private void init(RetrieverPage retriever, String action, boolean replace) {
        this.fView = retriever;
        this.fSearchResult = (RetrieverResult)this.fView.getInput();
        this.fShell = this.fView.getSite().getShell();
        this.fDialogTitle = action;
        this.fReplace = replace;
        this.setText(action);
    }

    private void setupReplaceAll() {
        this.fFileSet = new HashSet();
        this.fLineMap = Collections.EMPTY_MAP;
        Object[] lines = this.fSearchResult.getElements();
        int i = 0;
        while (i < lines.length) {
            RetrieverLine line = (RetrieverLine)lines[i];
            if (this.needsReplacement(line)) {
                this.fFileSet.add(line.getParent());
            }
            ++i;
        }
        this.setEnabled(!this.fFileSet.isEmpty());
    }

    private boolean needsReplacement(RetrieverLine line) {
        if (!line.isFiltered()) {
            RetrieverMatch[] matches = line.getMatches(false);
            int j = 0;
            while (j < matches.length) {
                RetrieverMatch match = matches[j];
                if (!match.isFiltered() && match.isReplaced() != this.fReplace) {
                    return true;
                }
                ++j;
            }
        }
        return false;
    }

    private void setupReplaceSelection(IStructuredSelection sel) {
        HashMap selectedResources = new HashMap();
        HashSet selectedLines = new HashSet();
        this.fFileSet = new HashSet();
        this.fLineMap = new HashMap();
        Iterator iter = sel.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (element instanceof IResource) {
                selectedResources.put(element, Boolean.TRUE);
                continue;
            }
            if (!(element instanceof RetrieverLine)) continue;
            selectedLines.add(element);
        }
        Object[] allLines = this.fSearchResult.getElements();
        int i = 0;
        while (i < allLines.length) {
            RetrieverLine line = (RetrieverLine)allLines[i];
            if (this.needsReplacement(line)) {
                IFile file = line.getParent();
                if (this.containsFile(selectedResources, file)) {
                    this.fFileSet.add(file);
                } else if (selectedLines.contains(line)) {
                    this.fFileSet.add(file);
                    this.addToLineMap(file, line);
                }
            }
            ++i;
        }
        this.setEnabled(!this.fFileSet.isEmpty());
    }

    private void addToLineMap(IFile file, RetrieverLine line) {
        ArrayList<RetrieverLine> lines = (ArrayList<RetrieverLine>)this.fLineMap.get(file);
        if (lines == null) {
            lines = new ArrayList<RetrieverLine>();
            this.fLineMap.put(file, lines);
        }
        lines.add(line);
    }

    private boolean containsFile(HashMap resources, IFile file) {
        return this.containsResource(resources, (IResource)file);
    }

    private Boolean containsResource(HashMap resources, IResource res) {
        Boolean result = (Boolean)resources.get(res);
        if (result == null) {
            IContainer parent = res.getParent();
            result = parent == null ? Boolean.FALSE : this.containsResource(resources, (IResource)parent);
            resources.put(res, result);
        }
        return result;
    }

    public void setReplacement(Pattern pattern, String replacement) {
        this.fPattern = pattern;
        this.fReplacement = replacement;
    }

    public void run() {
        this.fSuccess = false;
        if (this.fSearchResult == null) {
            return;
        }
        if (this.fReplace && (this.fPattern == null || this.fReplacement == null)) {
            return;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        ISchedulingRule rule = workspace.getRuleFactory().modifyRule((IResource)workspace.getRoot());
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                ReplaceAction.this.fSuccess = ReplaceAction.this.doPerformReplace(monitor);
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)this.fView.getSite().getWorkbenchWindow(), runnable, rule);
        }
        catch (InvocationTargetException e) {
            SearchPlugin.log(e);
        }
        catch (InterruptedException interruptedException) {}
    }

    protected boolean doPerformReplace(IProgressMonitor monitor) {
        if (this.fMatch != null) {
            return this.doPerformSingleReplace(monitor);
        }
        if (this.fFileSet != null && this.fLineMap != null) {
            return this.doPerformMultiReplace(monitor);
        }
        return false;
    }

    private boolean doPerformSingleReplace(IProgressMonitor monitor) {
        RetrieverMatch match = this.fMatch;
        RetrieverLine line = match.getLine();
        IFile file = line.getParent();
        HashSet searchedAgain = new HashSet();
        if (!this.makeCommitable(Collections.singleton(file), searchedAgain)) {
            return false;
        }
        if (searchedAgain.contains(file)) {
            match = this.mapMatch(match);
        }
        if (match == null) {
            MessageDialog.openError((Shell)this.fShell, (String)this.fDialogTitle, (String)SearchMessages.ReplaceOperation_error_cannotLocateMatch);
            return false;
        }
        ArrayList failures = new ArrayList();
        line = match.getLine();
        this.replaceInFile(monitor, line.getParent(), new RetrieverMatch[]{match}, failures);
        if (!failures.isEmpty()) {
            ErrorDialog.openError((Shell)this.fShell, (String)this.fDialogTitle, (String)SearchMessages.ReplaceOperation_error_operationFailed, (IStatus)((IStatus)failures.get(0)));
            return false;
        }
        this.fView.getTreeViewer().refresh((Object)line);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean doPerformMultiReplace(IProgressMonitor monitor) {
        HashSet searchedAgain = new HashSet();
        if (!this.makeCommitable(this.fFileSet, searchedAgain)) {
            return false;
        }
        Iterator iter = searchedAgain.iterator();
        while (iter.hasNext()) {
            IFile file = (IFile)iter.next();
            ArrayList lines = (ArrayList)this.fLineMap.get(file);
            if (lines == null) continue;
            this.mapLines(file, lines);
        }
        ArrayList failures = new ArrayList();
        monitor.beginTask(SearchMessages.ReplaceOperation_task_performChanges, this.fFileSet.size());
        try {
            Iterator iter2 = this.fFileSet.iterator();
            while (iter2.hasNext()) {
                IFile file = (IFile)iter2.next();
                List<RetrieverLine> lines = (List<RetrieverLine>)this.fLineMap.get(file);
                if (lines == null) {
                    lines = Arrays.asList(this.fSearchResult.getLinesForFile(file, false));
                }
                ArrayList<RetrieverMatch> matches = new ArrayList<RetrieverMatch>(lines.size());
                Iterator<RetrieverLine> iterator = lines.iterator();
                while (iterator.hasNext()) {
                    RetrieverLine line = iterator.next();
                    if (line == null) continue;
                    matches.addAll(Arrays.asList(line.getDisplayedMatches()));
                }
                this.replaceInFile((IProgressMonitor)new SubProgressMonitor(monitor, 1), file, matches.toArray(new RetrieverMatch[matches.size()]), failures);
                if (!monitor.isCanceled()) continue;
                Object var10_10 = null;
                monitor.done();
                return false;
            }
            Object var10_12 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        if (!failures.isEmpty()) {
            this.handleFailures(failures.toArray(new IStatus[failures.size()]));
            return false;
        }
        this.fView.getTreeViewer().refresh();
        return true;
    }

    private void mapLines(IFile file, ArrayList lines) {
        RetrieverLine[] newLines = this.fSearchResult.getLinesForFile(file, false);
        int i = 0;
        while (i < lines.size()) {
            RetrieverLine line = (RetrieverLine)lines.get(i);
            lines.set(i, this.findBestLine(line, newLines));
            ++i;
        }
    }

    private RetrieverMatch mapMatch(RetrieverMatch match) {
        RetrieverLine line = match.getLine();
        RetrieverLine[] newLines = this.fSearchResult.getLinesForFile(line.getParent(), false);
        RetrieverMatch bestMatch = null;
        RetrieverLine bestLine = this.findBestLine(line, newLines);
        if (bestLine != null) {
            int col = match.getLineOffset();
            int nearest = Integer.MAX_VALUE;
            RetrieverMatch[] candidates = bestLine.getDisplayedMatches();
            int i = 0;
            while (i < candidates.length) {
                int dist;
                RetrieverMatch candidate = candidates[i];
                if (!candidate.isFiltered() && candidate.getOriginal().equals(match.getOriginal()) && (dist = Math.abs(candidate.getLineOffset() - col)) < nearest) {
                    dist = nearest;
                    bestMatch = candidate;
                }
                ++i;
            }
        }
        return bestMatch;
    }

    private RetrieverLine findBestLine(RetrieverLine line, RetrieverLine[] newLines) {
        String lineData = line.getLine().trim();
        int lineNumber = line.getLineNumber();
        int nearest = Integer.MAX_VALUE;
        RetrieverLine best = null;
        int i = 0;
        while (i < newLines.length) {
            int dist;
            RetrieverLine test = newLines[i];
            if (lineData.equals(test.getLine().trim()) && (dist = Math.abs(test.getLineNumber() - lineNumber)) < nearest) {
                dist = nearest;
                best = test;
            }
            ++i;
        }
        return best;
    }

    private boolean handleFailures(IStatus[] stati) {
        if (stati.length == 0) {
            return true;
        }
        String message = Messages.format(SearchMessages.ReplaceOperation_error_didNotSucceedForAllMatches, this.fDialogTitle);
        if (stati.length == 1) {
            ErrorDialog.openError((Shell)this.fShell, (String)this.fDialogTitle, (String)message, (IStatus)stati[0]);
        } else {
            MultiStatus mstatus = new MultiStatus(SearchPlugin.getID(), 1, stati, SearchMessages.ReplaceOperation_error_multipleErrors, null);
            ErrorDialog.openError((Shell)this.fShell, (String)this.fDialogTitle, (String)message, (IStatus)mstatus);
        }
        return false;
    }

    private boolean makeCommitable(Collection files, HashSet searchedAgain) {
        if (files.isEmpty()) {
            return true;
        }
        HashSet<IFile> readOnly = new HashSet<IFile>();
        Iterator iter = files.iterator();
        while (iter.hasNext()) {
            IFile file = (IFile)iter.next();
            if (!file.isSynchronized(0)) {
                if (!this.refreshFile(file)) {
                    return false;
                }
                searchedAgain.add(file);
            }
            if (!file.isReadOnly()) continue;
            readOnly.add(file);
        }
        if (!this.validateEdit(readOnly)) {
            return false;
        }
        int readOnlyCount = 0;
        Iterator iter2 = readOnly.iterator();
        while (iter2.hasNext()) {
            IFile rf = (IFile)iter2.next();
            if (rf.isReadOnly()) {
                searchedAgain.remove(rf);
                ++readOnlyCount;
                continue;
            }
            searchedAgain.add(rf);
        }
        if (!this.confirmParialReplacement(files.size(), readOnlyCount)) {
            return false;
        }
        return this.searchAgain(searchedAgain);
    }

    private boolean searchAgain(HashSet outdated) {
        if (outdated.isEmpty() || !this.fReplace) {
            return true;
        }
        SearchAgainConfirmationDialog dialog = new SearchAgainConfirmationDialog(this.fShell, (ILabelProvider)this.fView.getTreeViewer().getLabelProvider(), Collections.EMPTY_LIST, new ArrayList(outdated));
        if (dialog.open() != 0) {
            return false;
        }
        this.fSearchResult.searchAgain(outdated);
        return true;
    }

    private boolean refreshFile(IFile file) {
        try {
            file.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.fShell, (String)this.fDialogTitle, (String)SearchMessages.ReplaceOperation_error_whileRefreshing, (IStatus)e.getStatus());
            return false;
        }
        return true;
    }

    private boolean validateEdit(HashSet readOnly) {
        IStatus s;
        if (!readOnly.isEmpty() && (s = ResourcesPlugin.getWorkspace().validateEdit(readOnly.toArray(new IFile[readOnly.size()]), (Object)this.fShell)).getSeverity() != 0) {
            if (s.getSeverity() != 8 && s.getCode() != 279) {
                ErrorDialog.openError((Shell)this.fShell, (String)this.fDialogTitle, (String)SearchMessages.ReplaceOperation_error_whileValidateEdit, (IStatus)s);
            }
            return false;
        }
        return true;
    }

    private boolean confirmParialReplacement(int writableFiles, int readOnlyFiles) {
        if (readOnlyFiles == 0) {
            return true;
        }
        if (writableFiles == 0) {
            MessageDialog.openError((Shell)this.fShell, (String)this.fDialogTitle, (String)SearchMessages.ReplaceOperation_error_allFilesReadOnly);
            return false;
        }
        String key = readOnlyFiles == 1 ? SearchMessages.ReplaceOperation_question_continueWithReadOnly_singular : SearchMessages.ReplaceOperation_question_continueWithReadOnly_plural;
        return MessageDialog.openQuestion((Shell)this.fShell, (String)this.fDialogTitle, (String)MessageFormat.format(key, new Integer(readOnlyFiles)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void replaceInFile(IProgressMonitor monitor, IFile file, RetrieverMatch[] matches, Collection failures) {
        try {
            try {
                ITextFileBufferManager bm;
                int ticks;
                block22: {
                    block21: {
                        if (file.isReadOnly()) {
                            Object var20_5 = null;
                            monitor.done();
                            return;
                        }
                        ticks = 3;
                        monitor.beginTask(SearchMessages.ReplaceOperation_task_performChanges, ticks);
                        bm = FileBuffers.getTextFileBufferManager();
                        --ticks;
                        bm.connect(file.getFullPath(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        if (!monitor.isCanceled()) break block21;
                        Object var18_12 = null;
                        bm.disconnect(file.getFullPath(), (IProgressMonitor)new SubProgressMonitor(monitor, ticks));
                        Object var20_6 = null;
                        monitor.done();
                        return;
                    }
                    try {
                        ITextFileBuffer fb = bm.getTextFileBuffer(file.getFullPath());
                        boolean wasDirty = fb.isDirty();
                        IDocument doc = fb.getDocument();
                        PositionTracker tracker = InternalSearchUI.getInstance().getPositionTracker();
                        int i = 0;
                        while (i < matches.length) {
                            RetrieverMatch match = matches[i];
                            if (!match.isFiltered() && match.isReplaced() != this.fReplace) {
                                int offset = match.getOffset();
                                int length = match.getLength();
                                Position currentPosition = tracker.getCurrentPosition(match);
                                if (currentPosition != null) {
                                    offset = currentPosition.offset;
                                    length = currentPosition.length;
                                }
                                String currentText = null;
                                try {
                                    currentText = doc.get(offset, length);
                                }
                                catch (BadLocationException badLocationException) {}
                                if (currentText == null || !currentText.equals(match.getCurrentText())) {
                                    failures.add(this.createErrorStatus(Messages.format(SearchMessages.ReplaceOperation_error_cannotLocateMatchAt, new Object[]{file.getFullPath(), new Integer(match.getLine().getLineNumber())})));
                                } else {
                                    String newText;
                                    String string = newText = this.fReplace ? match.computeReplacement(this.fPattern, this.fReplacement) : match.getOriginal();
                                    if (newText == null) {
                                        failures.add(this.createErrorStatus(Messages.format(SearchMessages.ReplaceOperation_error_cannotComputeReplacement, new Object[]{file.getFullPath(), new Integer(match.getLine().getLineNumber())})));
                                    } else {
                                        try {
                                            doc.replace(offset, length, newText);
                                            match.setReplacement(this.fReplace ? newText : null);
                                        }
                                        catch (BadLocationException badLocationException) {
                                            failures.add(this.createErrorStatus(Messages.format(SearchMessages.ReplaceOperation_error_cannotLocateMatchAt, new Object[]{file, new Integer(match.getLine().getLineNumber())})));
                                        }
                                    }
                                }
                            }
                            ++i;
                        }
                        if (wasDirty) break block22;
                        --ticks;
                        fb.commit((IProgressMonitor)new SubProgressMonitor(monitor, 1), true);
                    }
                    catch (Throwable throwable) {
                        Object var18_13 = null;
                        bm.disconnect(file.getFullPath(), (IProgressMonitor)new SubProgressMonitor(monitor, ticks));
                        throw throwable;
                    }
                }
                Object var18_14 = null;
                bm.disconnect(file.getFullPath(), (IProgressMonitor)new SubProgressMonitor(monitor, ticks));
            }
            catch (CoreException e) {
                failures.add(e.getStatus());
            }
            Object var20_8 = null;
        }
        catch (Throwable throwable) {
            Object var20_7 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
    }

    private Status createErrorStatus(String message) {
        return new Status(4, SearchPlugin.getID(), 1, message, null);
    }

    public boolean wasSuccessful() {
        return this.fSuccess;
    }
}

