/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui.text2;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.search.internal.ui.text.IFileSearchContentProvider;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search2.internal.ui.text2.RetrieverLine;
import org.eclipse.search2.internal.ui.text2.RetrieverResult;
import org.eclipse.search2.internal.ui.text2.RetrieverTreeViewer;

public class RetrieverContentProvider
implements ITreeContentProvider,
IFileSearchContentProvider {
    private static final Object[] EMPTY_ARR = new Object[0];
    private RetrieverResult fResult;
    private RetrieverTreeViewer fTreeViewer;
    private Map fChildrenMap;
    private int[] fMatchCount;
    private HashSet fAutoExpand = new HashSet();
    private boolean fFlatLayout;

    public RetrieverContentProvider(RetrieverTreeViewer viewer, boolean flatLayout) {
        this.fTreeViewer = viewer;
        this.fFlatLayout = flatLayout;
    }

    public Object getParent(Object element) {
        if (element instanceof RetrieverLine) {
            return ((RetrieverLine)element).getParent();
        }
        if (element instanceof IProject) {
            return null;
        }
        if (element instanceof IResource) {
            IResource resource = (IResource)element;
            return this.fFlatLayout ? null : resource.getParent();
        }
        return null;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof AbstractTextSearchResult) {
            this.initialize((AbstractTextSearchResult)newInput);
        }
    }

    protected synchronized void initialize(AbstractTextSearchResult result) {
        this.fResult = (RetrieverResult)result;
        this.fChildrenMap = new HashMap();
        this.fAutoExpand.clear();
        this.fMatchCount = null;
        if (result != null) {
            Object[] elements = result.getElements();
            int i = 0;
            while (i < elements.length) {
                Object element = elements[i];
                if (this.fResult.getDisplayedMatchCount(element) > 0) {
                    this.insert(element, false, null, null);
                }
                ++i;
            }
            this.updateFilterItem(false, null, null);
        }
    }

    protected void insert(Object child, boolean refreshViewer, HashSet refreshElems, HashMap insertElems) {
        Object parent;
        Object dummyParent = parent = this.getParent(child);
        if (parent == null) {
            dummyParent = this.fResult;
        }
        if (this.insertInMap(dummyParent, child, this.fChildrenMap)) {
            if (refreshViewer) {
                this.insertInMap(dummyParent, child, insertElems);
            }
            if (parent != null) {
                this.insert(parent, refreshViewer, refreshElems, insertElems);
            }
        }
    }

    private boolean insertInMap(Object parent, Object child, Map map) {
        HashSet<Object> children = (HashSet<Object>)map.get(parent);
        if (children == null) {
            children = new HashSet<Object>();
            map.put(parent, children);
        }
        return children.add(child);
    }

    protected void remove(Object element, boolean refreshViewer, HashSet refreshElems) {
        if (this.hasChildren(element)) {
            if (refreshViewer) {
                refreshElems.add(element);
            }
        } else {
            this.fChildrenMap.remove(element);
            Object parent = this.getParent(element);
            if (parent != null) {
                if (this.removeFromSiblings(element, parent)) {
                    this.remove(parent, refreshViewer, refreshElems);
                }
            } else if (this.removeFromSiblings(element, this.fResult) && refreshViewer) {
                refreshElems.add(this.fResult);
            }
        }
    }

    private boolean removeFromSiblings(Object element, Object parent) {
        Set siblings = (Set)this.fChildrenMap.get(parent);
        if (siblings != null) {
            return siblings.remove(element);
        }
        return false;
    }

    public Object[] getChildren(Object parentElement) {
        Set children = (Set)this.fChildrenMap.get(parentElement);
        if (children == null) {
            return EMPTY_ARR;
        }
        return children.toArray();
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public synchronized void elementsChanged(final Object[] updatedElements) {
        if (updatedElements.length == 0) {
            return;
        }
        Runnable r = new Runnable(){

            public void run() {
                RetrieverContentProvider.this.handeElementsChanged(updatedElements);
            }
        };
        this.fTreeViewer.preservingSelection(r);
    }

    private void handeElementsChanged(Object[] updatedElements) {
        HashSet refreshElems = new HashSet();
        HashMap insertElems = new HashMap();
        this.updateFilterItem(true, refreshElems, insertElems);
        int i = 0;
        while (i < updatedElements.length) {
            Object updatedElem = updatedElements[i];
            if (this.fResult.getDisplayedMatchCount(updatedElem) > 0) {
                this.insert(updatedElem, true, refreshElems, insertElems);
            } else {
                this.remove(updatedElem, true, refreshElems);
            }
            ++i;
        }
        if (refreshElems.contains(this.fResult)) {
            this.fTreeViewer.refresh();
        } else {
            Iterator iter = refreshElems.iterator();
            while (iter.hasNext()) {
                Object elem = iter.next();
                Object parent = this.getParent(elem);
                if (this.containsElemOrAParent(refreshElems, parent)) continue;
                this.fTreeViewer.refresh(elem);
            }
        }
        Object[] insertParents = insertElems.keySet().toArray();
        int i2 = 0;
        while (i2 < insertParents.length) {
            Object element = insertParents[i2];
            this.insertInView(element, refreshElems, insertElems);
            ++i2;
        }
    }

    private void updateFilterItem(boolean updateViewer, HashSet refreshElems, HashMap insertElems) {
        if (this.fResult != null) {
            int[] matchCount = this.fResult.getDetailedMatchCount();
            if (matchCount[0] == matchCount[1]) {
                if (this.fMatchCount != null) {
                    this.remove(this.fMatchCount, updateViewer, refreshElems);
                    this.fMatchCount = null;
                }
            } else if (this.fMatchCount != null) {
                this.fMatchCount[0] = matchCount[0];
                this.fMatchCount[1] = matchCount[1];
                refreshElems.add(this.fMatchCount);
            } else {
                this.fMatchCount = matchCount;
                this.insert(this.fMatchCount, updateViewer, refreshElems, insertElems);
            }
        }
    }

    private boolean insertInView(Object element, HashSet refreshElems, HashMap insertElems) {
        Collection children;
        Object parent = this.getParent(element);
        if (parent == null) {
            parent = this.fResult;
        }
        if ((children = (Collection)insertElems.remove(element)) == null) {
            return !this.containsElemOrAParent(refreshElems, element);
        }
        boolean needToInsert = true;
        if (element != this.fResult) {
            needToInsert = this.insertInView(parent, refreshElems, insertElems);
        }
        if (needToInsert) {
            boolean bl = needToInsert = !refreshElems.contains(element);
        }
        if (needToInsert) {
            this.fTreeViewer.add(element, children.toArray());
        }
        if (this.fAutoExpand.contains(element)) {
            this.fTreeViewer.setExpandedState(element, true);
        }
        return needToInsert;
    }

    private boolean containsElemOrAParent(HashSet set, Object elem) {
        while (elem != null) {
            if (set.contains(elem)) {
                return true;
            }
            elem = this.getParent(elem);
        }
        return set.contains(this.fResult);
    }

    public void clear() {
        this.initialize(this.fResult);
        this.fTreeViewer.refresh();
    }

    public AbstractTextSearchResult getResult() {
        return this.fResult;
    }

    public void onExpansionStateChange(Object element, boolean expanded) {
        if (!expanded) {
            this.fAutoExpand.remove(element);
        } else {
            this.fAutoExpand.add(element);
        }
    }

    public void setLayout(boolean flat) {
        if (flat != this.fFlatLayout) {
            this.fFlatLayout = flat;
            this.initialize(this.fResult);
        }
    }

    public void onSelectionChanged(SelectionChangedEvent event) {
        IStructuredSelection sel = (IStructuredSelection)event.getSelection();
        Object element = sel.getFirstElement();
        if (element != null) {
            element = this.getParent(element);
            while (element != null && this.fAutoExpand.add(element)) {
                element = this.getParent(element);
            }
        }
    }
}

