/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui.text2;

import java.util.regex.Pattern;
import org.eclipse.search.internal.core.text.PatternConstructor;
import org.eclipse.search2.internal.ui.SearchMessages;
import org.eclipse.search2.internal.ui.text2.RetrieverPage;

public class RetrieverFilter {
    private static String sLastCauseForError;
    private Pattern fFilterPattern;
    private String fFilterText;
    private int fAcceptedLocations;
    private boolean fIsRegex;
    private boolean fHideMatching;
    private int fOriginatorsHash;

    public RetrieverFilter(RetrieverPage page, int acceptedLocations, String filterText, boolean isRegex, boolean hideMatching, int originatorsHash) {
        this.fOriginatorsHash = originatorsHash;
        this.fFilterPattern = null;
        this.fFilterText = null;
        if (filterText != null && filterText.length() != 0) {
            block3: {
                try {
                    this.fFilterPattern = PatternConstructor.createPattern(filterText, isRegex, false, false, false);
                    this.fFilterText = filterText;
                }
                catch (Exception e) {
                    if (page == null || filterText.equals(sLastCauseForError)) break block3;
                    page.showError(String.valueOf(SearchMessages.RetrieverFindTab_Error_invalidRegex) + e.getMessage());
                }
            }
            sLastCauseForError = filterText;
        }
        this.fAcceptedLocations = acceptedLocations;
        this.fIsRegex = isRegex;
        this.fHideMatching = hideMatching;
    }

    public RetrieverFilter() {
        this.fAcceptedLocations = 63;
    }

    public int getOriginatorsHash() {
        return this.fOriginatorsHash;
    }

    public boolean getHideMatching() {
        return this.fHideMatching;
    }

    public int getAcceptedLocations() {
        return this.fAcceptedLocations;
    }

    public Pattern getPattern() {
        return this.fFilterPattern;
    }

    public boolean getIsRegex() {
        return this.fIsRegex;
    }

    public String getFilterString() {
        return this.fFilterText;
    }
}

