/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui.text2;

import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.search.internal.ui.SearchPluginImages;
import org.eclipse.search.internal.ui.text.FileLabelProvider;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search2.internal.ui.SearchMessages;
import org.eclipse.search2.internal.ui.text2.RetrieverLine;
import org.eclipse.swt.graphics.Image;

public class RetrieverLabelProvider
extends FileLabelProvider {
    private boolean fAppendContainer = false;

    public RetrieverLabelProvider(AbstractTextSearchViewPage page, int orderFlag) {
        super(page, orderFlag);
    }

    public void setAppendFileContainer(boolean val) {
        this.fAppendContainer = val;
    }

    public Image getImage(Object element) {
        if (element instanceof RetrieverLine) {
            return SearchPluginImages.get("org.eclipse.search.ui.line_match.gif");
        }
        return super.getImage(element);
    }

    public String getText(Object element) {
        if (element instanceof RetrieverLine) {
            RetrieverLine line = (RetrieverLine)element;
            StringBuffer buf = new StringBuffer();
            buf.append(String.valueOf(line.getLineNumber()));
            buf.append(": ");
            buf.append(RetrieverLabelProvider.convertChars(line.getString()));
            return buf.toString();
        }
        if (element instanceof int[]) {
            int[] matchCount = (int[])element;
            Integer hidden = new Integer(matchCount[0] - matchCount[1]);
            if (hidden == 1) {
                return SearchMessages.RetrieverLabelProvider_FilterHidesMatches_labelSingular;
            }
            return MessageFormat.format(SearchMessages.RetrieverLabelProvider_FilterHidesMatches_labelPlural, hidden);
        }
        if (this.fAppendContainer && element instanceof IFile) {
            IFile file = (IFile)element;
            return RetrieverLabelProvider.getFileLableWithContainer(file.getFullPath());
        }
        return super.getText(element);
    }

    public static String getFileLableWithContainer(IPath path) {
        StringBuffer buf = new StringBuffer();
        buf.append(path.lastSegment());
        buf.append(" - ");
        buf.append(path.removeLastSegments(1).toString());
        return buf.toString();
    }

    static String convertChars(CharSequence input) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < input.length()) {
            char c = input.charAt(i);
            switch (c) {
                case '\r': {
                    result.append("\\r");
                    break;
                }
                case '\n': {
                    result.append("\\n");
                    break;
                }
                case '\t': {
                    result.append("    ");
                    break;
                }
                default: {
                    result.append(c);
                }
            }
            ++i;
        }
        return result.toString();
    }
}

