/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui.text2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.search2.internal.ui.text2.RetrieverMatch;

public class RetrieverLine {
    private static final RetrieverMatch[] EMPTY_ARRAY = new RetrieverMatch[0];
    private static final int HIGH_BIT = Integer.MIN_VALUE;
    private IFile fParent;
    private int fLineNumber;
    private String fLineData;
    private RetrieverMatch[] fMatches;

    public RetrieverLine(IFile parent, int lineNumber) {
        this.fParent = parent;
        this.fLineNumber = lineNumber;
        this.fMatches = null;
        this.setIsFiltered(false);
    }

    public int getLineNumber() {
        return this.fLineNumber & Integer.MAX_VALUE;
    }

    public void setData(String line) {
        this.fLineData = line;
    }

    public synchronized void addMatch(RetrieverMatch match) {
        if (this.fMatches == null) {
            this.fMatches = new RetrieverMatch[]{match};
        } else {
            RetrieverMatch[] newMatches = new RetrieverMatch[this.fMatches.length + 1];
            System.arraycopy(this.fMatches, 0, newMatches, 0, this.fMatches.length);
            newMatches[this.fMatches.length] = match;
            this.fMatches = newMatches;
        }
    }

    public synchronized void filter(Pattern regex, boolean hideMatching, int acceptLocations, Collection changedMatches) {
        boolean lineWasFiltered = this.isFiltered();
        boolean lineIsFiltered = regex != null && regex.matcher(this.fLineData).find() == hideMatching;
        int i = 0;
        while (i < this.fMatches.length) {
            boolean doFilter;
            RetrieverMatch match = this.fMatches[i];
            boolean wasFiltered = lineWasFiltered || match.isFiltered();
            boolean bl = doFilter = lineIsFiltered || (match.getKind() & acceptLocations) == 0;
            if (wasFiltered != doFilter) {
                if (changedMatches != null) {
                    changedMatches.add(match);
                }
                match.setFiltered(doFilter);
            }
            ++i;
        }
        this.setIsFiltered(lineIsFiltered);
    }

    private void setIsFiltered(boolean value) {
        this.fLineNumber = value ? (this.fLineNumber |= Integer.MIN_VALUE) : (this.fLineNumber &= Integer.MAX_VALUE);
    }

    public String getLine() {
        return this.fLineData;
    }

    public RetrieverMatch[] getMatches(boolean copy) {
        return copy ? (RetrieverMatch[])this.fMatches.clone() : this.fMatches;
    }

    public IFile getParent() {
        return this.fParent;
    }

    public synchronized void addMatchCount(int[] count) {
        count[0] = count[0] + this.fMatches.length;
        if (!this.isFiltered()) {
            int i = 0;
            while (i < this.fMatches.length) {
                if (!this.fMatches[i].isFiltered()) {
                    count[1] = count[1] + 1;
                }
                ++i;
            }
        }
    }

    public int getLength() {
        return this.fLineData.length();
    }

    public String getString() {
        return this.getPreString(null);
    }

    public synchronized String getPreString(RetrieverMatch match) {
        StringBuffer pre = new StringBuffer();
        int offset = 0;
        int lineLength = this.fLineData.length();
        int i = 0;
        while (i < this.fMatches.length) {
            RetrieverMatch m = this.fMatches[i];
            if (m == match) break;
            if (m.isReplaced()) {
                int start = m.getLineOffset();
                if (start >= lineLength) break;
                pre.append(this.fLineData.substring(offset, start));
                pre.append(m.getReplacement());
                offset = start + m.getOriginalLength();
                if (offset >= lineLength) break;
            }
            if (m == match) break;
            ++i;
        }
        if (offset < lineLength) {
            int end = match == null ? lineLength : Math.min(match.getLineOffset(), lineLength);
            pre.append(this.fLineData.substring(offset, end));
        }
        return pre.toString();
    }

    public synchronized String computeReplacement(RetrieverMatch match, Pattern p, String replacement) {
        int shouldStart;
        if (match.getLineOffset() + match.getOriginalLength() > this.fLineData.length()) {
            return null;
        }
        RetrieverMatch prev = null;
        int i = 0;
        while (i < this.fMatches.length) {
            RetrieverMatch m = this.fMatches[i];
            if (m == match) break;
            prev = m;
            ++i;
        }
        int offsetInLine = prev == null ? 0 : prev.getLineOffset() + prev.getOriginalLength();
        Matcher matcher = p.matcher(this.fLineData);
        if (matcher.find(offsetInLine) && (shouldStart = match.getLineOffset()) == matcher.start()) {
            StringBuffer help = new StringBuffer();
            try {
                matcher.appendReplacement(help, replacement);
            }
            catch (Exception exception) {
                return replacement.replaceAll("\\\\\\\\", "\\\\");
            }
            return help.substring(shouldStart);
        }
        return null;
    }

    public synchronized String getPostString(RetrieverMatch match) {
        StringBuffer post = new StringBuffer();
        int offset = 0;
        int lineLength = this.fLineData.length();
        int i = 0;
        while (i < this.fMatches.length) {
            RetrieverMatch m = this.fMatches[i];
            if (m == match) {
                offset = match.getLineOffset() + match.getOriginalLength();
            } else if (offset > 0 && m.isReplaced()) {
                int start = m.getLineOffset();
                if (start >= lineLength) break;
                post.append(this.fLineData.substring(offset, start));
                post.append(m.getReplacement());
                offset = start + m.getOriginalLength();
                if (offset >= lineLength) break;
            }
            ++i;
        }
        if (offset < lineLength) {
            post.append(this.fLineData.substring(offset, lineLength));
        }
        return post.toString();
    }

    public void setParent(IFile file) {
        this.fParent = file;
    }

    public synchronized boolean checkState(boolean replace) {
        int i = 0;
        while (i < this.fMatches.length) {
            RetrieverMatch match = this.fMatches[i];
            if (!match.isFiltered() && replace != match.isReplaced()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public synchronized void remove(Set matchset) {
        ArrayList<RetrieverMatch> matches = new ArrayList<RetrieverMatch>();
        int i = 0;
        while (i < this.fMatches.length) {
            RetrieverMatch m = this.fMatches[i];
            if (!matchset.contains(m)) {
                matches.add(m);
            }
            ++i;
        }
        this.fMatches = matches.toArray(new RetrieverMatch[matches.size()]);
    }

    public synchronized int getDisplayedMatchCount() {
        int result = 0;
        if (!this.isFiltered()) {
            int i = 0;
            while (i < this.fMatches.length) {
                if (!this.fMatches[i].isFiltered()) {
                    ++result;
                }
                ++i;
            }
        }
        return result;
    }

    public synchronized RetrieverMatch[] getDisplayedMatches() {
        int count = this.getDisplayedMatchCount();
        if (count == 0) {
            return EMPTY_ARRAY;
        }
        if (count == this.fMatches.length) {
            return this.fMatches;
        }
        RetrieverMatch[] result = new RetrieverMatch[count];
        int j = 0;
        int i = 0;
        while (i < this.fMatches.length) {
            RetrieverMatch match = this.fMatches[i];
            if (!match.isFiltered()) {
                result[j++] = match;
            }
            ++i;
        }
        return result;
    }

    public boolean isFiltered() {
        return (this.fLineNumber & Integer.MIN_VALUE) != 0;
    }

    public int getMatchCount() {
        return 0;
    }

    public String substring(int begin, int end) {
        return this.fLineData.substring(begin, end);
    }
}

