/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui.text2;

import java.util.regex.Pattern;
import org.eclipse.search.ui.text.Match;
import org.eclipse.search2.internal.ui.text2.RetrieverLine;

public class RetrieverMatch
extends Match {
    private int fKind;
    private int fLineOffset;
    private String fReplacement;
    private String fOriginal;

    public RetrieverMatch(RetrieverLine line, String original, int offset, int length, int lineOffset, int kind) {
        super(line, offset, length);
        this.fOriginal = original;
        this.fReplacement = null;
        this.fLineOffset = lineOffset;
        this.fKind = kind;
    }

    public int getKind() {
        return this.fKind;
    }

    public void setReplacement(String replacement) {
        this.fReplacement = replacement;
    }

    public boolean isReplaced() {
        return this.fReplacement != null;
    }

    public String getReplacement() {
        return this.fReplacement;
    }

    public String getOriginal() {
        return this.fOriginal;
    }

    public boolean filter(Pattern filterExpr, boolean hideMatching, int filterOptions, boolean invertOptions) {
        boolean filtered = false;
        if ((this.fKind & filterOptions) == 0 == invertOptions) {
            filtered = true;
        }
        this.setFiltered(filtered);
        return filtered;
    }

    public int getLineOffset() {
        return this.fLineOffset;
    }

    public String getCurrentText() {
        return this.fReplacement != null ? this.fReplacement : this.fOriginal;
    }

    public String computeReplacement(Pattern pattern, String replacement) {
        return this.getLine().computeReplacement(this, pattern, replacement);
    }

    public RetrieverLine getLine() {
        return (RetrieverLine)this.getElement();
    }

    public int getOriginalLength() {
        return this.fOriginal.length();
    }
}

