/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui.text2;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.internal.ui.SearchPluginImages;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.SearchResultEvent;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.IEditorMatchAdapter;
import org.eclipse.search.ui.text.IFileMatchAdapter;
import org.eclipse.search.ui.text.Match;
import org.eclipse.search2.internal.ui.SearchMessages;
import org.eclipse.search2.internal.ui.text2.FilterMatchEvent;
import org.eclipse.search2.internal.ui.text2.IRetrieverKeys;
import org.eclipse.search2.internal.ui.text2.RetrieverFilter;
import org.eclipse.search2.internal.ui.text2.RetrieverLine;
import org.eclipse.search2.internal.ui.text2.RetrieverMatch;
import org.eclipse.search2.internal.ui.text2.RetrieverQuery;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;

class RetrieverResult
extends AbstractTextSearchResult
implements ISearchResult,
IEditorMatchAdapter,
IFileMatchAdapter,
IRetrieverKeys {
    private static final RetrieverMatch[] EMPTY_ARRAY = new RetrieverMatch[0];
    private Pattern fFilterExpr;
    private boolean fFilterHideMatching;
    private int fAcceptLocations = 0;
    private RetrieverQuery fQuery;
    private boolean fIsComplete;
    private HashMap fFilesToLines = new HashMap();
    private FilterMatchEvent fFilterEvent = new FilterMatchEvent(this);
    private RetrieverFilter fFilter;

    public RetrieverResult(RetrieverQuery query) {
        this.fQuery = query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filter(RetrieverFilter filter) {
        this.fFilter = filter;
        boolean hideMatches = filter.getHideMatching();
        int acceptLocations = filter.getAcceptedLocations();
        Pattern filterPattern = filter.getPattern();
        if (this.fFilterHideMatching == hideMatches && acceptLocations == this.fAcceptLocations && (filterPattern == this.fFilterExpr || filterPattern != null && filterPattern.equals(this.fFilterExpr))) {
            return;
        }
        this.fFilterExpr = filterPattern;
        this.fFilterHideMatching = hideMatches;
        this.fAcceptLocations = acceptLocations;
        ArrayList changedMatches = new ArrayList();
        Object[] lines = this.getElements();
        int i = 0;
        while (i < lines.length) {
            RetrieverLine line = (RetrieverLine)lines[i];
            line.filter(this.fFilterExpr, this.fFilterHideMatching, this.fAcceptLocations, changedMatches);
            ++i;
        }
        FilterMatchEvent filterMatchEvent = this.fFilterEvent;
        synchronized (filterMatchEvent) {
            if (!changedMatches.isEmpty()) {
                this.fireChange(this.getFilterSearchResultEvent(changedMatches));
            }
        }
    }

    private SearchResultEvent getFilterSearchResultEvent(ArrayList matches) {
        Match[] matchArray = matches.toArray(new Match[matches.size()]);
        this.fFilterEvent.setMatches(matchArray);
        return this.fFilterEvent;
    }

    public boolean hasFilter() {
        return this.fFilterExpr != null || this.fAcceptLocations == 63;
    }

    public IEditorMatchAdapter getEditorMatchAdapter() {
        return this;
    }

    public IFileMatchAdapter getFileMatchAdapter() {
        return this;
    }

    public String getLabel() {
        String pattern = this.fQuery.getSearchText();
        String scope = this.fQuery.getScopeDescription().getNameForDescription();
        int matchCount = this.getMatchCount();
        if (pattern.length() == 0) {
            return SearchMessages.RetrieverResult_noInput_label;
        }
        if (matchCount == 1) {
            return MessageFormat.format(SearchMessages.RetrieverResult_labelSingular, pattern, scope);
        }
        return MessageFormat.format(SearchMessages.RetrieverResult_label, pattern, new Integer(matchCount), scope);
    }

    public String getTooltip() {
        return this.getLabel();
    }

    public ImageDescriptor getImageDescriptor() {
        return SearchPluginImages.DESC_OBJ_TSEARCH_DPDN;
    }

    public ISearchQuery getQuery() {
        return this.fQuery;
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IFile file) {
        return this.collectMatches(this.getLinesForFile(file, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RetrieverLine[] getLinesForFile(IFile file, boolean copy) {
        RetrieverLine[] lines = null;
        HashMap hashMap = this.fFilesToLines;
        synchronized (hashMap) {
            lines = (RetrieverLine[])this.fFilesToLines.get(file);
        }
        return copy && lines != null ? (RetrieverLine[])lines.clone() : lines;
    }

    public IFile getFile(Object element) {
        if (element instanceof IFile) {
            return (IFile)element;
        }
        if (element instanceof RetrieverLine) {
            RetrieverLine line = (RetrieverLine)element;
            return line.getParent();
        }
        return null;
    }

    public boolean isShownInEditor(Match match, IEditorPart editor) {
        IEditorInput ei = editor.getEditorInput();
        if (ei instanceof IFileEditorInput) {
            IFileEditorInput fi = (IFileEditorInput)ei;
            Object line = match.getElement();
            if (line instanceof RetrieverLine) {
                return ((RetrieverLine)line).getParent().equals((Object)fi.getFile());
            }
        }
        return false;
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IEditorPart editor) {
        IEditorInput ei = editor.getEditorInput();
        if (ei instanceof IFileEditorInput) {
            IFileEditorInput fi = (IFileEditorInput)ei;
            return this.computeContainedMatches(result, fi.getFile());
        }
        return EMPTY_ARRAY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLinesForFile(IFile file, List lines) {
        RetrieverLine[] newLines = lines.toArray(new RetrieverLine[lines.size()]);
        Match[] oldMatches = this.collectMatches(this.getLinesForFile(file, false));
        HashMap hashMap = this.fFilesToLines;
        synchronized (hashMap) {
            this.fFilesToLines.remove(file);
        }
        if (oldMatches.length > 0) {
            this.removeMatches(oldMatches);
        }
        if (newLines.length > 0) {
            ArrayList<RetrieverMatch> matches = new ArrayList<RetrieverMatch>(newLines.length);
            Iterator iter = lines.iterator();
            while (iter.hasNext()) {
                RetrieverLine line = (RetrieverLine)iter.next();
                line.filter(this.fFilterExpr, this.fFilterHideMatching, this.fAcceptLocations, null);
                RetrieverMatch[] m = line.getMatches(false);
                matches.addAll(Arrays.asList(m));
            }
            if (!matches.isEmpty()) {
                HashMap hashMap2 = this.fFilesToLines;
                synchronized (hashMap2) {
                    this.fFilesToLines.put(file, newLines);
                }
                this.addMatches(matches.toArray(new Match[matches.size()]));
            }
        }
    }

    private RetrieverMatch[] collectMatches(RetrieverLine[] lines) {
        if (lines == null || lines.length == 0) {
            return EMPTY_ARRAY;
        }
        ArrayList<RetrieverMatch> matches = new ArrayList<RetrieverMatch>(lines.length);
        int i = 0;
        while (i < lines.length) {
            RetrieverLine line = lines[i];
            matches.addAll(Arrays.asList(line.getMatches(false)));
            ++i;
        }
        return matches.toArray(new RetrieverMatch[matches.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        HashMap hashMap = this.fFilesToLines;
        synchronized (hashMap) {
            this.fFilesToLines.clear();
        }
        super.removeAll();
    }

    public void removeMatch(Match match) {
        ((RetrieverLine)match.getElement()).remove(Collections.singleton(match));
        super.removeMatch(match);
    }

    public void removeMatches(Match[] matches) {
        HashSet<Match> matchset = new HashSet<Match>();
        matchset.addAll(Arrays.asList(matches));
        HashSet<Object> lines = new HashSet<Object>();
        int i = 0;
        while (i < matches.length) {
            RetrieverMatch match = (RetrieverMatch)matches[i];
            lines.add(match.getElement());
            ++i;
        }
        Iterator iter = lines.iterator();
        while (iter.hasNext()) {
            RetrieverLine line = (RetrieverLine)iter.next();
            line.remove(matchset);
        }
        super.removeMatches(matches);
    }

    public int getMatchCount(Object element) {
        if (element instanceof RetrieverLine) {
            return ((RetrieverLine)element).getMatchCount();
        }
        return 0;
    }

    public int getDisplayedMatchCount(Object element) {
        if (element instanceof RetrieverLine) {
            return ((RetrieverLine)element).getDisplayedMatchCount();
        }
        return 0;
    }

    public boolean isComplete() {
        return this.fIsComplete;
    }

    public void setComplete(boolean isComplete) {
        this.fIsComplete = isComplete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getDetailedMatchCount() {
        int[] result = new int[2];
        HashMap hashMap = this.fFilesToLines;
        synchronized (hashMap) {
            Iterator iter = this.fFilesToLines.values().iterator();
            while (iter.hasNext()) {
                RetrieverLine[] lines = (RetrieverLine[])iter.next();
                int i = 0;
                while (i < lines.length) {
                    RetrieverLine line = lines[i];
                    line.addMatchCount(result);
                    ++i;
                }
            }
        }
        return result;
    }

    public void searchAgain(Collection outdated) {
        if (this.fQuery != null) {
            this.fQuery.searchAgain(outdated, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public RetrieverFilter getFilter() {
        return this.fFilter;
    }
}

