/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui.text2;

import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.search2.internal.ui.text2.RetrieverLine;

public class RetrieverViewerSorter
extends ViewerSorter {
    private final ILabelProvider fLabelProvider;

    public RetrieverViewerSorter(ILabelProvider labelProvider) {
        super(null);
        this.fLabelProvider = labelProvider;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        if (e1 instanceof RetrieverLine && e2 instanceof RetrieverLine) {
            return ((RetrieverLine)e1).getLineNumber() - ((RetrieverLine)e2).getLineNumber();
        }
        int diff = this.category(e1) - this.category(e2);
        if (diff != 0) {
            return diff;
        }
        String name1 = this.fLabelProvider.getText(e1);
        String name2 = this.fLabelProvider.getText(e2);
        if (name1 == null) {
            name1 = "";
        }
        if (name2 == null) {
            name2 = "";
        }
        return this.getCollator().compare(name1, name2);
    }

    public final Collator getCollator() {
        if (this.collator == null) {
            this.collator = Collator.getInstance();
        }
        return this.collator;
    }

    public int category(Object element) {
        if (element instanceof IResource) {
            return -((IResource)element).getType();
        }
        return 0;
    }

    public void sort(Viewer viewer, Object[] elements) {
        if (elements.length > 0) {
            Object o = elements[0];
            if (o instanceof RetrieverLine) {
                this.sortLines(viewer, elements);
                return;
            }
            super.sort(viewer, elements);
        }
    }

    private void sortLines(Viewer viewer, Object[] elements) {
        Arrays.sort(elements, new Comparator(){

            public int compare(Object a, Object b) {
                RetrieverLine l1 = (RetrieverLine)a;
                RetrieverLine l2 = (RetrieverLine)b;
                return l1.getLineNumber() - l2.getLineNumber();
            }
        });
    }
}

