/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui.text2;

import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.search2.internal.ui.text2.IScopeDescription;
import org.eclipse.search2.internal.ui.text2.RetrieverLabelProvider;
import org.eclipse.ui.IWorkbenchPage;

public class SingleFileScopeDescription
implements IScopeDescription {
    private static final String KEY_FULL_PATH = "full-path";
    private IPath fPath;

    public SingleFileScopeDescription() {
    }

    public SingleFileScopeDescription(IFile file) {
        this.fPath = file.getFullPath();
    }

    public IResource[] getRoots(IWorkbenchPage page) {
        return this.getFiles(page);
    }

    public void store(IDialogSettings section) {
        if (this.fPath != null) {
            section.put(KEY_FULL_PATH, this.fPath.toPortableString());
        }
    }

    public void restore(IDialogSettings section) {
        this.fPath = null;
        String portable = section.get(KEY_FULL_PATH);
        if (portable != null) {
            this.fPath = Path.fromPortableString((String)portable);
        }
    }

    public void store(Properties props, String prefix) {
        if (this.fPath != null) {
            props.put(String.valueOf(prefix) + KEY_FULL_PATH, this.fPath.toPortableString());
        }
    }

    public void restore(Properties props, String prefix) {
        this.fPath = null;
        Object portable = props.get(String.valueOf(prefix) + KEY_FULL_PATH);
        if (portable != null) {
            this.fPath = Path.fromPortableString((String)portable.toString());
        }
    }

    public String getLabelForCombo() {
        return this.fPath == null ? "null" : RetrieverLabelProvider.getFileLableWithContainer(this.fPath);
    }

    public String getNameForDescription() {
        return this.getLabelForCombo();
    }

    public IFile[] getFiles(IWorkbenchPage page) {
        IResource r;
        if (this.fPath != null && (r = ResourcesPlugin.getWorkspace().getRoot().findMember(this.fPath)) instanceof IFile) {
            return new IFile[]{(IFile)r};
        }
        return new IFile[0];
    }
}

