/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui.text2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.search2.internal.ui.text2.IScopeDescription;
import org.eclipse.search2.internal.ui.text2.WindowWorkingSetScopeDescription;
import org.eclipse.search2.internal.ui.text2.WorkspaceScopeDescription;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;

public class WorkingSetScopeDescription
implements IScopeDescription {
    private static final String KEY_WORKING_SET_NAME = "workingset-names";
    private static final String KEY_LABEL = "workingset-label";
    private static final IResource[] EMPTY_ARRAY = new IResource[0];
    private String[] fWorkingSetNames;
    private String fLabel;
    static /* synthetic */ Class class$0;

    public WorkingSetScopeDescription() {
    }

    public WorkingSetScopeDescription(IWorkingSet[] set) {
        this.fWorkingSetNames = new String[set.length];
        int i = 0;
        while (i < set.length) {
            this.fWorkingSetNames[i] = set[i].getName();
            ++i;
        }
        this.fLabel = this.computeLabel();
    }

    private String computeLabel() {
        StringBuffer label = new StringBuffer();
        int i = 0;
        while (i < this.fWorkingSetNames.length) {
            if (i > 0) {
                label.append('+');
            }
            label.append(this.fWorkingSetNames[i]);
            ++i;
        }
        return label.toString();
    }

    public String getLabelForCombo() {
        return this.fLabel;
    }

    public String getNameForDescription() {
        return this.fLabel;
    }

    protected void setLabel(String label) {
        this.fLabel = label;
    }

    public IResource[] getRoots(IWorkbenchPage page) {
        return this.getRootsFromWorkingSets(this.getWorkingSets());
    }

    protected IResource[] getRootsFromWorkingSets(IWorkingSet[] ws) {
        if (ws == null) {
            return EMPTY_ARRAY;
        }
        HashSet resources = new HashSet();
        int i = 0;
        while (i < ws.length) {
            this.getResources(ws[i].getElements(), resources);
            ++i;
        }
        Iterator iter = resources.iterator();
        while (iter.hasNext()) {
            IResource r = (IResource)iter.next();
            IContainer parent = r.getParent();
            while (parent != null) {
                if (resources.contains(parent)) {
                    iter.remove();
                    parent = null;
                    continue;
                }
                parent = parent.getParent();
            }
        }
        return resources.toArray(new IResource[resources.size()]);
    }

    private void getResources(IAdaptable[] elements, Collection target) {
        int i = 0;
        while (i < elements.length) {
            IResource r;
            IAdaptable adaptable = elements[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((r = (IResource)adaptable.getAdapter((Class)clazz)) != null) {
                target.add(r);
            }
            ++i;
        }
    }

    public void restore(IDialogSettings section) {
        this.fWorkingSetNames = section.getArray(KEY_WORKING_SET_NAME);
        if (this.fWorkingSetNames == null) {
            throw new IllegalArgumentException();
        }
        this.fLabel = section.get(KEY_LABEL);
        if (this.fLabel == null) {
            this.fLabel = this.computeLabel();
        }
    }

    public void store(IDialogSettings section) {
        section.put(KEY_WORKING_SET_NAME, this.fWorkingSetNames);
        section.put(KEY_LABEL, this.fLabel);
    }

    public void store(Properties props, String prefix) {
        props.put(String.valueOf(prefix) + KEY_WORKING_SET_NAME, this.fWorkingSetNames);
        props.put(String.valueOf(prefix) + KEY_LABEL, this.fLabel);
    }

    public void restore(Properties props, String prefix) {
        this.fWorkingSetNames = (String[])props.get(String.valueOf(prefix) + KEY_WORKING_SET_NAME);
        this.fLabel = (String)props.get(String.valueOf(prefix) + KEY_LABEL);
        if (this.fLabel == null) {
            this.fLabel = this.computeLabel();
        }
    }

    public static IScopeDescription createWithDialog(IWorkbenchPage page, IScopeDescription scope) {
        if (page == null) {
            return null;
        }
        IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSetSelectionDialog dialog = manager.createWorkingSetSelectionDialog(page.getWorkbenchWindow().getShell(), true);
        IScopeDescription result = null;
        if (scope instanceof WindowWorkingSetScopeDescription) {
            dialog.setSelection(new IWorkingSet[]{page.getAggregateWorkingSet()});
        } else if (scope instanceof WorkingSetScopeDescription) {
            WorkingSetScopeDescription wsetscope = (WorkingSetScopeDescription)scope;
            dialog.setSelection(wsetscope.getWorkingSets());
        }
        if (dialog.open() == 0) {
            IWorkingSet[] wsarray = dialog.getSelection();
            if (wsarray != null && wsarray.length > 0) {
                if (wsarray.length == 1 && wsarray[0] == page.getAggregateWorkingSet()) {
                    result = new WindowWorkingSetScopeDescription();
                } else if (wsarray.length > 0) {
                    result = new WorkingSetScopeDescription(wsarray);
                    if (wsarray.length == 0) {
                        manager.addRecentWorkingSet(wsarray[0]);
                    }
                }
            } else {
                result = new WorkspaceScopeDescription();
            }
        }
        return result;
    }

    private IWorkingSet[] getWorkingSets() {
        IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
        ArrayList<IWorkingSet> workingSets = new ArrayList<IWorkingSet>();
        int i = 0;
        while (i < this.fWorkingSetNames.length) {
            IWorkingSet ws = manager.getWorkingSet(this.fWorkingSetNames[i]);
            if (ws != null) {
                workingSets.add(ws);
            }
            ++i;
        }
        return workingSets.toArray(new IWorkingSet[workingSets.size()]);
    }

    public IFile[] getFiles(IWorkbenchPage page) {
        return null;
    }
}

