/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import java.util.Date;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.team.internal.ccvs.core.filehistory.CVSFileRevision;
import org.eclipse.team.internal.core.LocalFileRevision;

public class CVSHistoryFilter
extends ViewerFilter {
    public String author;
    public Date fromDate;
    public Date toDate;
    public String comment;
    public boolean isOr;
    public boolean showLocal;

    public CVSHistoryFilter(String author, String comment, Date fromDate, Date toDate, boolean isOr, boolean showLocal) {
        this.author = author;
        this.comment = comment;
        this.fromDate = fromDate;
        this.toDate = toDate;
        this.isOr = isOr;
        this.showLocal = showLocal;
    }

    public boolean select(Viewer aviewer, Object parentElement, Object element) {
        if (element instanceof CVSFileRevision) {
            CVSFileRevision entry = (CVSFileRevision)element;
            if (this.isOr) {
                return this.hasAuthor() && this.authorMatch(entry) || this.hasDate() && this.dateMatch(entry) || this.hasComment() && this.commentMatch(entry);
            }
            return !(this.hasAuthor() && !this.authorMatch(entry) || this.hasDate() && !this.dateMatch(entry) || this.hasComment() && !this.commentMatch(entry));
        }
        if (element instanceof LocalFileRevision) {
            return this.showLocal();
        }
        return false;
    }

    protected boolean authorMatch(CVSFileRevision revision) {
        return revision.getAuthor().equals(this.author);
    }

    protected boolean commentMatch(CVSFileRevision revision) {
        return revision.getComment().toLowerCase().indexOf(this.comment.toLowerCase()) != -1;
    }

    protected boolean dateMatch(CVSFileRevision revision) {
        return this.fromDate.before(new Date(revision.getTimestamp())) && this.toDate.after(new Date(revision.getTimestamp()));
    }

    protected boolean hasAuthor() {
        return !this.author.equals("");
    }

    protected boolean hasComment() {
        return !this.comment.equals("");
    }

    protected boolean hasDate() {
        return this.fromDate != null && this.toDate != null;
    }

    protected boolean showLocal() {
        return this.showLocal;
    }
}

