/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import java.text.DateFormat;
import java.util.Date;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.team.core.history.IFileHistory;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.history.ITag;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.ui.AbstractCVSHistoryCategory;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.VersionCollator;
import org.eclipse.team.internal.core.LocalFileRevision;
import org.eclipse.team.internal.ui.TeamUIMessages;

public class CVSHistoryTableProvider {
    private IFileHistory currentFileHistory;
    private ICVSFile cvsFile;
    TreeViewer viewer;
    Font currentRevisionFont;
    private boolean baseModified;
    private static final int COL_REVISIONID = 0;
    private static final int COL_TAGS = 1;
    private static final int COL_DATE = 2;
    private static final int COL_AUTHOR = 3;
    private static final int COL_COMMENT = 4;
    static /* synthetic */ Class class$0;

    protected IFileRevision adaptToFileRevision(Object element) {
        IFileRevision entry = null;
        if (element instanceof IFileRevision) {
            entry = (IFileRevision)element;
        } else if (element instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)element;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.team.core.history.IFileRevision");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            entry = (IFileRevision)iAdaptable.getAdapter((Class)clazz);
        } else if (element instanceof AbstractCVSHistoryCategory) {
            entry = ((AbstractCVSHistoryCategory)element).getRevisions()[0];
        }
        return entry;
    }

    public TreeViewer createTree(Composite parent) {
        Tree tree = new Tree(parent, 66306);
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        GridData data = new GridData(1808);
        tree.setLayoutData((Object)data);
        TableLayout layout = new TableLayout();
        tree.setLayout((Layout)layout);
        TreeViewer viewer = new TreeViewer(tree);
        this.createColumns(tree, layout);
        viewer.setLabelProvider((IBaseLabelProvider)new HistoryLabelProvider());
        HistorySorter sorter = new HistorySorter(2);
        viewer.setSorter((ViewerSorter)sorter);
        tree.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (CVSHistoryTableProvider.this.currentRevisionFont != null) {
                    CVSHistoryTableProvider.this.currentRevisionFont.dispose();
                }
            }
        });
        this.viewer = viewer;
        return viewer;
    }

    private void createColumns(Tree tree, TableLayout layout) {
        SelectionListener headerListener = this.getColumnListener(this.viewer);
        TreeColumn col = new TreeColumn(tree, 0);
        col.setResizable(true);
        col.setText(TeamUIMessages.GenericHistoryTableProvider_Revision);
        col.addSelectionListener(headerListener);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, true));
        col = new TreeColumn(tree, 0);
        col.setResizable(true);
        col.setText(CVSUIMessages.HistoryView_tags);
        col.addSelectionListener(headerListener);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, true));
        col = new TreeColumn(tree, 0);
        col.setResizable(true);
        col.setText(TeamUIMessages.GenericHistoryTableProvider_RevisionTime);
        col.addSelectionListener(headerListener);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, true));
        col = new TreeColumn(tree, 0);
        col.setResizable(true);
        col.setText(TeamUIMessages.GenericHistoryTableProvider_Author);
        col.addSelectionListener(headerListener);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, true));
        col = new TreeColumn(tree, 0);
        col.setResizable(true);
        col.setText(TeamUIMessages.GenericHistoryTableProvider_Comment);
        col.addSelectionListener(headerListener);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, true));
    }

    private SelectionListener getColumnListener(final TreeViewer treeViewer) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int column = treeViewer.getTree().indexOf((TreeColumn)e.widget);
                HistorySorter oldSorter = (HistorySorter)treeViewer.getSorter();
                if (oldSorter != null && column == oldSorter.getColumnNumber()) {
                    oldSorter.setReversed(!oldSorter.isReversed());
                    treeViewer.refresh();
                } else {
                    treeViewer.setSorter((ViewerSorter)new HistorySorter(column));
                }
            }
        };
    }

    public void setFile(IFileHistory fileHistory, ICVSFile cvsFile) {
        this.currentFileHistory = fileHistory;
        this.cvsFile = cvsFile;
    }

    public IFileHistory getIFileHistory() {
        return this.currentFileHistory;
    }

    public String getCurrentRevision() {
        try {
            if (this.cvsFile != null && this.cvsFile.getSyncInfo() != null) {
                return this.cvsFile.getSyncInfo().getRevision();
            }
        }
        catch (CVSException cVSException) {}
        return null;
    }

    public void setLocalRevisionsDisplayed(boolean displayed) {
        HistorySorter oldSorter;
        int column = 0;
        if (displayed) {
            column = 2;
        }
        if ((oldSorter = (HistorySorter)this.viewer.getSorter()) != null && column == oldSorter.getColumnNumber()) {
            oldSorter.setReversed(column == 0);
            this.viewer.refresh();
        } else {
            HistorySorter newSorter = new HistorySorter(column);
            newSorter.setReversed(column == 0);
            this.viewer.setSorter((ViewerSorter)newSorter);
        }
    }

    public void setBaseModified(boolean modified) {
        this.baseModified = modified;
    }

    class HistoryLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IColorProvider,
    IFontProvider {
        Image dateImage = null;
        ImageDescriptor desc = null;

        HistoryLabelProvider() {
        }

        public void dispose() {
            if (this.dateImage != null) {
                JFaceResources.getResources().destroyImage(this.desc);
                this.dateImage = null;
            }
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (element instanceof AbstractCVSHistoryCategory && columnIndex == 0) {
                this.desc = CVSUIPlugin.getPlugin().getImageDescriptor("obj16/dates.gif");
                return this.desc.createImage();
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof AbstractCVSHistoryCategory) {
                if (columnIndex != 0) {
                    return "";
                }
                return ((AbstractCVSHistoryCategory)element).getName();
            }
            IFileRevision entry = CVSHistoryTableProvider.this.adaptToFileRevision(element);
            if (entry == null) {
                return "";
            }
            switch (columnIndex) {
                case 0: {
                    String revision = entry.getContentIdentifier();
                    String currentRevision = CVSHistoryTableProvider.this.getCurrentRevision();
                    if (currentRevision != null && currentRevision.equals(revision)) {
                        revision = CVSHistoryTableProvider.this.baseModified ? NLS.bind((String)CVSUIMessages.nameAndRevision, (Object[])new String[]{revision, CVSUIMessages.CVSHistoryTableProvider_base}) : NLS.bind((String)CVSUIMessages.currentRevision, (Object[])new String[]{revision});
                    }
                    return revision;
                }
                case 1: {
                    ITag[] tags = entry.getTags();
                    StringBuffer result = new StringBuffer();
                    int i = 0;
                    while (i < tags.length) {
                        result.append(tags[i].getName());
                        if (i < tags.length - 1) {
                            result.append(", ");
                        }
                        ++i;
                    }
                    return result.toString();
                }
                case 2: {
                    long date = entry.getTimestamp();
                    Date dateFromLong = new Date(date);
                    return DateFormat.getInstance().format(dateFromLong);
                }
                case 3: {
                    return entry.getAuthor();
                }
                case 4: {
                    String comment = entry.getComment();
                    int index = comment.indexOf("\n");
                    switch (index) {
                        case -1: {
                            return comment;
                        }
                        case 0: {
                            return CVSUIMessages.HistoryView_______4;
                        }
                    }
                    return NLS.bind((String)CVSUIMessages.CVSCompareRevisionsInput_truncate, (Object[])new String[]{comment.substring(0, index)});
                }
            }
            return "";
        }

        public Color getForeground(Object element) {
            if (element instanceof AbstractCVSHistoryCategory) {
                return Display.getCurrent().getSystemColor(10);
            }
            IFileRevision entry = CVSHistoryTableProvider.this.adaptToFileRevision(element);
            if (!entry.exists()) {
                return Display.getCurrent().getSystemColor(18);
            }
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Font getFont(Object element) {
            if (element instanceof AbstractCVSHistoryCategory) {
                return this.getCurrentRevisionFont();
            }
            IFileRevision entry = CVSHistoryTableProvider.this.adaptToFileRevision(element);
            if (entry == null) {
                return null;
            }
            String revision = entry.getContentIdentifier();
            String comment = entry.getComment();
            String tempCurrentRevision = CVSHistoryTableProvider.this.getCurrentRevision();
            if (tempCurrentRevision != null && tempCurrentRevision.equals(revision) || comment.equals(CVSUIMessages.CVSHistoryTableProvider_currentVersion)) {
                return this.getCurrentRevisionFont();
            }
            return null;
        }

        private Font getCurrentRevisionFont() {
            if (CVSHistoryTableProvider.this.currentRevisionFont == null) {
                Font defaultFont = JFaceResources.getDefaultFont();
                FontData[] data = defaultFont.getFontData();
                int i = 0;
                while (i < data.length) {
                    data[i].setStyle(1);
                    ++i;
                }
                CVSHistoryTableProvider.this.currentRevisionFont = new Font((Device)CVSHistoryTableProvider.this.viewer.getTree().getDisplay(), data);
            }
            return CVSHistoryTableProvider.this.currentRevisionFont;
        }
    }

    class HistorySorter
    extends ViewerSorter {
        private boolean reversed = false;
        private int columnNumber;
        private VersionCollator versionCollator = new VersionCollator();
        private int[][] SORT_ORDERS_BY_COLUMN;

        public HistorySorter(int columnNumber) {
            int[][] nArrayArray = new int[5][];
            int[] nArray = new int[5];
            nArray[1] = 2;
            nArray[2] = 3;
            nArray[3] = 4;
            nArray[4] = 1;
            nArrayArray[0] = nArray;
            int[] nArray2 = new int[5];
            nArray2[0] = 1;
            nArray2[1] = 2;
            nArray2[3] = 3;
            nArray2[4] = 4;
            nArrayArray[1] = nArray2;
            int[] nArray3 = new int[5];
            nArray3[0] = 2;
            nArray3[2] = 3;
            nArray3[3] = 4;
            nArray3[4] = 1;
            nArrayArray[2] = nArray3;
            int[] nArray4 = new int[5];
            nArray4[0] = 3;
            nArray4[2] = 2;
            nArray4[3] = 4;
            nArray4[4] = 1;
            nArrayArray[3] = nArray4;
            int[] nArray5 = new int[5];
            nArray5[0] = 4;
            nArray5[2] = 2;
            nArray5[3] = 3;
            nArray5[4] = 1;
            nArrayArray[4] = nArray5;
            this.SORT_ORDERS_BY_COLUMN = nArrayArray;
            this.columnNumber = columnNumber;
        }

        public int compare(Viewer compareViewer, Object o1, Object o2) {
            if (o1 instanceof AbstractCVSHistoryCategory || o2 instanceof AbstractCVSHistoryCategory) {
                return 0;
            }
            IFileRevision e1 = CVSHistoryTableProvider.this.adaptToFileRevision(o1);
            IFileRevision e2 = CVSHistoryTableProvider.this.adaptToFileRevision(o2);
            int result = 0;
            if (e1 == null || e2 == null) {
                result = super.compare(compareViewer, o1, o2);
            } else {
                int[] columnSortOrder = this.SORT_ORDERS_BY_COLUMN[this.columnNumber];
                int i = 0;
                while (i < columnSortOrder.length) {
                    result = this.compareColumnValue(columnSortOrder[i], e1, e2);
                    if (result != 0) break;
                    ++i;
                }
            }
            if (this.reversed) {
                result = -result;
            }
            return result;
        }

        int compareColumnValue(int columnNumber, IFileRevision e1, IFileRevision e2) {
            switch (columnNumber) {
                case 0: {
                    if (e1 instanceof LocalFileRevision || e2 instanceof LocalFileRevision) {
                        long date2;
                        long date1 = e1.getTimestamp();
                        if (date1 == (date2 = e2.getTimestamp())) {
                            return 0;
                        }
                        return date1 > date2 ? -1 : 1;
                    }
                    return this.versionCollator.compare(e1.getContentIdentifier(), e2.getContentIdentifier());
                }
                case 1: {
                    ITag[] tags1 = e1.getTags();
                    ITag[] tags2 = e2.getTags();
                    if (tags2.length == 0) {
                        return -1;
                    }
                    if (tags1.length == 0) {
                        return 1;
                    }
                    return this.getCollator().compare(tags1[0].getName(), tags2[0].getName());
                }
                case 2: {
                    long date1 = e1.getTimestamp();
                    long date2 = e2.getTimestamp();
                    if (date1 == date2) {
                        return 0;
                    }
                    return date1 > date2 ? -1 : 1;
                }
                case 3: {
                    return this.getCollator().compare(e1.getAuthor(), e2.getAuthor());
                }
                case 4: {
                    return this.getCollator().compare(e1.getComment(), e2.getComment());
                }
            }
            return 0;
        }

        public int getColumnNumber() {
            return this.columnNumber;
        }

        public boolean isReversed() {
            return this.reversed;
        }

        public void setReversed(boolean newReversed) {
            this.reversed = newReversed;
        }
    }
}

