/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSSyncInfo;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.ILogEntry;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Update;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.ui.CVSResourceTransfer;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.HistoryDropAdapter;
import org.eclipse.team.internal.ccvs.ui.HistoryTableProvider;
import org.eclipse.team.internal.ccvs.ui.HistoryView;
import org.eclipse.team.internal.ccvs.ui.RemoteFileEditorInput;
import org.eclipse.team.internal.ccvs.ui.SimpleContentProvider;
import org.eclipse.team.internal.ccvs.ui.TextViewerAction;
import org.eclipse.team.internal.ccvs.ui.actions.CVSAction;
import org.eclipse.team.internal.ccvs.ui.actions.MoveRemoteTagAction;
import org.eclipse.team.internal.ccvs.ui.actions.OpenLogEntryAction;
import org.eclipse.team.internal.ccvs.ui.operations.ITagOperation;
import org.eclipse.team.internal.ccvs.ui.operations.TagInRepositoryOperation;
import org.eclipse.team.internal.ccvs.ui.operations.UpdateOperation;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.ui.synchronize.SyncInfoCompareInput;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;

public class HistoryView
extends ViewPart {
    private IFile file;
    private ILogEntry[] entries;
    private HistoryTableProvider historyTableProvider;
    private TableViewer tableViewer;
    private TextViewer textViewer;
    private TableViewer tagViewer;
    private OpenLogEntryAction openAction;
    private IAction toggleTextAction;
    private IAction toggleTextWrapAction;
    private IAction toggleListAction;
    private TextViewerAction copyAction;
    private TextViewerAction selectAllAction;
    private Action getContentsAction;
    private Action getRevisionAction;
    private Action refreshAction;
    private Action tagWithExistingAction;
    private Action linkWithEditorAction;
    private SashForm sashForm;
    private SashForm innerSashForm;
    private Image branchImage;
    private Image versionImage;
    private ILogEntry currentSelection;
    private boolean linkingEnabled;
    private IPreferenceStore settings;
    private FetchLogEntriesJob fetchLogEntriesJob;
    private boolean shutdown = false;
    public static final String VIEW_ID = "org.eclipse.team.ccvs.ui.HistoryView";
    private IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
            if (part instanceof IEditorPart) {
                HistoryView.this.editorActivated((IEditorPart)part);
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
            if (part == HistoryView.this) {
                HistoryView.this.editorActivated(HistoryView.this.getViewSite().getPage().getActiveEditor());
            }
        }

        public void partOpened(IWorkbenchPart part) {
            if (part == HistoryView.this) {
                HistoryView.this.editorActivated(HistoryView.this.getViewSite().getPage().getActiveEditor());
            }
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }
    };
    private IPartListener2 partListener2 = new IPartListener2(){

        public void partActivated(IWorkbenchPartReference ref) {
        }

        public void partBroughtToTop(IWorkbenchPartReference ref) {
        }

        public void partClosed(IWorkbenchPartReference ref) {
        }

        public void partDeactivated(IWorkbenchPartReference ref) {
        }

        public void partOpened(IWorkbenchPartReference ref) {
        }

        public void partHidden(IWorkbenchPartReference ref) {
        }

        public void partVisible(IWorkbenchPartReference ref) {
            if (ref.getPart(true) == HistoryView.this) {
                HistoryView.this.editorActivated(HistoryView.this.getViewSite().getPage().getActiveEditor());
            }
        }

        public void partInputChanged(IWorkbenchPartReference ref) {
        }
    };
    static /* synthetic */ Class class$0;

    protected void contributeActions() {
        CVSUIPlugin plugin = CVSUIPlugin.getPlugin();
        this.refreshAction = new Action(CVSUIMessages.HistoryView_refreshLabel, plugin.getImageDescriptor("elcl16/refresh.gif")){

            public void run() {
                HistoryView.this.refresh();
            }
        };
        this.refreshAction.setToolTipText(CVSUIMessages.HistoryView_refresh);
        this.refreshAction.setDisabledImageDescriptor(plugin.getImageDescriptor("dlcl16/refresh.gif"));
        this.refreshAction.setHoverImageDescriptor(plugin.getImageDescriptor("elcl16/refresh.gif"));
        this.linkWithEditorAction = new Action(CVSUIMessages.HistoryView_linkWithLabel, plugin.getImageDescriptor("elcl16/synced.gif")){

            public void run() {
                HistoryView.this.setLinkingEnabled(this.isChecked());
            }
        };
        this.linkWithEditorAction.setToolTipText(CVSUIMessages.HistoryView_linkWithLabel);
        this.linkWithEditorAction.setHoverImageDescriptor(plugin.getImageDescriptor("elcl16/synced.gif"));
        this.linkWithEditorAction.setChecked(this.isLinkingEnabled());
        this.openAction = new OpenLogEntryAction();
        this.tableViewer.getTable().addListener(14, new Listener(){

            public void handleEvent(Event e) {
                HistoryView.this.openAction.selectionChanged(null, HistoryView.this.tableViewer.getSelection());
                HistoryView.this.openAction.run(null);
            }
        });
        this.getContentsAction = this.getContextMenuAction(CVSUIMessages.HistoryView_getContentsAction, true, new IWorkspaceRunnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws CoreException {
                ICVSRemoteFile remoteFile = HistoryView.this.currentSelection.getRemoteFile();
                monitor.beginTask(null, 100);
                try {
                    try {
                        if (HistoryView.this.confirmOverwrite()) {
                            InputStream in = remoteFile.getContents((IProgressMonitor)new SubProgressMonitor(monitor, 50));
                            HistoryView.this.file.setContents(in, false, true, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                        }
                    }
                    catch (TeamException e) {
                        throw new CoreException(e.getStatus());
                    }
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var4_7 = null;
                }
                monitor.done();
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.getContentsAction, "org.eclipse.team.cvs.ui.get_file_contents_action_context");
        this.getRevisionAction = this.getContextMenuAction(CVSUIMessages.HistoryView_getRevisionAction, true, new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ICVSRemoteFile remoteFile = HistoryView.this.currentSelection.getRemoteFile();
                try {
                    if (HistoryView.this.confirmOverwrite()) {
                        CVSTag revisionTag = new CVSTag(remoteFile.getRevision(), 2);
                        if (CVSAction.checkForMixingTags(HistoryView.this.getSite().getShell(), new IResource[]{HistoryView.this.file}, revisionTag)) {
                            new UpdateOperation(null, new IResource[]{HistoryView.this.file}, new Command.LocalOption[]{Update.IGNORE_LOCAL_CHANGES}, revisionTag).run(monitor);
                            HistoryView.this.historyTableProvider.setFile((ICVSFile)remoteFile);
                            Display.getDefault().asyncExec(new Runnable(this){
                                final /* synthetic */ 8 this$1;
                                {
                                    this.this$1 = var1_1;
                                }

                                public void run() {
                                    HistoryView.access$3(8.access$0(this.this$1)).refresh();
                                }
                            });
                        }
                    }
                }
                catch (InvocationTargetException e) {
                    CVSException.wrapException((Exception)e);
                }
                catch (InterruptedException interruptedException) {}
            }

            static /* synthetic */ HistoryView access$0(8 var0) {
                return var0.HistoryView.this;
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.getRevisionAction, "org.eclipse.team.cvs.ui.get_file_revision_action_context");
        MoveRemoteTagAction tagActionDelegate = new MoveRemoteTagAction(){

            protected ICVSResource[] getSelectedCVSResources() {
                ICVSResource[] resources = super.getSelectedCVSResources();
                if (resources == null || resources.length == 0) {
                    ArrayList<ICVSRemoteFile> logEntrieFiles = null;
                    IStructuredSelection selection = this.getSelection();
                    if (!selection.isEmpty()) {
                        logEntrieFiles = new ArrayList<ICVSRemoteFile>();
                        Iterator elements = selection.iterator();
                        while (elements.hasNext()) {
                            Object adapter;
                            Object next = elements.next();
                            if (next instanceof ILogEntry) {
                                logEntrieFiles.add(((ILogEntry)next).getRemoteFile());
                                continue;
                            }
                            if (!(next instanceof IAdaptable)) continue;
                            IAdaptable a = (IAdaptable)next;
                            Class<?> clazz = class$0;
                            if (clazz == null) {
                                try {
                                    clazz = Class.forName("org.eclipse.team.internal.ccvs.core.ICVSResource");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if (!((adapter = a.getAdapter((Class)clazz)) instanceof ICVSResource)) continue;
                            logEntrieFiles.add(((ILogEntry)adapter).getRemoteFile());
                        }
                    }
                    if (logEntrieFiles != null && !logEntrieFiles.isEmpty()) {
                        return logEntrieFiles.toArray(new ICVSResource[logEntrieFiles.size()]);
                    }
                }
                return resources;
            }

            protected ITagOperation createTagOperation() {
                return new TagInRepositoryOperation(this, this.getTargetPart(), this.getSelectedRemoteResources()){
                    final /* synthetic */ 10 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void execute(IProgressMonitor monitor) throws CVSException, InterruptedException {
                        super.execute(monitor);
                        Display.getDefault().asyncExec(new Runnable(this){
                            final /* synthetic */ 11 this$2;
                            {
                                this.this$2 = var1_1;
                            }

                            public void run() {
                                if (!11.access$0(this.this$2).wasCancelled()) {
                                    HistoryView.access$4(10.access$0(11.access$0(this.this$2)));
                                }
                            }
                        });
                    }

                    static /* synthetic */ 10 access$0(11 var0) {
                        return var0.this$1;
                    }
                };
            }

            static /* synthetic */ HistoryView access$0(10 var0) {
                return var0.HistoryView.this;
            }
        };
        this.tagWithExistingAction = this.getContextMenuAction(CVSUIMessages.HistoryView_tagWithExistingAction, false, new IWorkspaceRunnable((IActionDelegate)tagActionDelegate){
            private final /* synthetic */ IActionDelegate val$tagActionDelegate;
            {
                this.val$tagActionDelegate = iActionDelegate;
            }

            public void run(IProgressMonitor monitor) throws CoreException {
                this.val$tagActionDelegate.selectionChanged((IAction)HistoryView.this.tagWithExistingAction, HistoryView.this.tableViewer.getSelection());
                this.val$tagActionDelegate.run((IAction)HistoryView.this.tagWithExistingAction);
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.getRevisionAction, "org.eclipse.team.cvs.ui.tag_with_existing_action_context");
        final IPreferenceStore store = CVSUIPlugin.getPlugin().getPreferenceStore();
        this.toggleTextAction = new Action(CVSUIMessages.HistoryView_showComment){

            public void run() {
                HistoryView.this.setViewerVisibility();
                store.setValue("pref_show_comments", HistoryView.this.toggleTextAction.isChecked());
            }
        };
        this.toggleTextAction.setChecked(store.getBoolean("pref_show_comments"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.toggleTextAction, "org.eclipse.team.cvs.ui.show_comment_in_history_action_context");
        this.toggleTextWrapAction = new Action(CVSUIMessages.HistoryView_wrapComment){

            public void run() {
                HistoryView.this.setViewerVisibility();
                store.setValue("pref_wrap_comments", HistoryView.this.toggleTextWrapAction.isChecked());
            }
        };
        this.toggleTextWrapAction.setChecked(store.getBoolean("pref_wrap_comments"));
        this.toggleListAction = new Action(CVSUIMessages.HistoryView_showTags){

            public void run() {
                HistoryView.this.setViewerVisibility();
                store.setValue("pref_show_tags", HistoryView.this.toggleListAction.isChecked());
            }
        };
        this.toggleListAction.setChecked(store.getBoolean("pref_show_tags"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.toggleListAction, "org.eclipse.team.cvs.ui.show_tag_in_history_action_context");
        MenuManager menuMgr = new MenuManager();
        Menu menu = menuMgr.createContextMenu((Control)this.tableViewer.getTable());
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuMgr) {
                HistoryView.this.fillTableMenu(menuMgr);
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        this.tableViewer.getTable().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.tableViewer);
        IActionBars actionBars = this.getViewSite().getActionBars();
        IMenuManager actionBarsMenu = actionBars.getMenuManager();
        actionBarsMenu.add(this.toggleTextWrapAction);
        actionBarsMenu.add((IContributionItem)new Separator());
        actionBarsMenu.add(this.toggleTextAction);
        actionBarsMenu.add(this.toggleListAction);
        IToolBarManager tbm = this.getViewSite().getActionBars().getToolBarManager();
        tbm.add((IAction)this.refreshAction);
        tbm.add((IAction)this.linkWithEditorAction);
        tbm.update(false);
        this.copyAction = new TextViewerAction((ITextViewer)this.textViewer, 4);
        this.copyAction.setText(CVSUIMessages.HistoryView_copy);
        actionBars.setGlobalActionHandler(ITextEditorActionConstants.COPY, (IAction)this.copyAction);
        this.selectAllAction = new TextViewerAction((ITextViewer)this.textViewer, 7);
        this.selectAllAction.setText(CVSUIMessages.HistoryView_selectAll);
        actionBars.setGlobalActionHandler(ITextEditorActionConstants.SELECT_ALL, (IAction)this.selectAllAction);
        actionBars.updateActionBars();
        menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuMgr) {
                HistoryView.this.fillTextMenu(menuMgr);
            }
        });
        StyledText text = this.textViewer.getTextWidget();
        menu = menuMgr.createContextMenu((Control)text);
        text.setMenu(menu);
    }

    private void setViewerVisibility() {
        boolean showText = this.toggleTextAction.isChecked();
        boolean showList = this.toggleListAction.isChecked();
        if (showText && showList) {
            this.sashForm.setMaximizedControl(null);
            this.innerSashForm.setMaximizedControl(null);
        } else if (showText) {
            this.sashForm.setMaximizedControl(null);
            this.innerSashForm.setMaximizedControl((Control)this.textViewer.getTextWidget());
        } else if (showList) {
            this.sashForm.setMaximizedControl(null);
            this.innerSashForm.setMaximizedControl((Control)this.tagViewer.getTable());
        } else {
            this.sashForm.setMaximizedControl(this.tableViewer.getControl());
        }
        boolean wrapText = this.toggleTextWrapAction.isChecked();
        this.textViewer.getTextWidget().setWordWrap(wrapText);
    }

    public void createPartControl(Composite parent) {
        this.settings = CVSUIPlugin.getPlugin().getPreferenceStore();
        this.linkingEnabled = this.settings.getBoolean("pref_history_view_linking");
        this.initializeImages();
        this.sashForm = new SashForm(parent, 512);
        this.sashForm.setLayoutData((Object)new GridData(1808));
        this.tableViewer = this.createTable((Composite)this.sashForm);
        this.innerSashForm = new SashForm((Composite)this.sashForm, 256);
        this.tagViewer = this.createTagTable((Composite)this.innerSashForm);
        this.textViewer = this.createText((Composite)this.innerSashForm);
        this.sashForm.setWeights(new int[]{70, 30});
        this.innerSashForm.setWeights(new int[]{50, 50});
        this.contributeActions();
        this.setViewerVisibility();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.sashForm, "org.eclipse.team.cvs.ui.resource_history_view_context");
        this.initDragAndDrop();
        this.getSite().getPage().addPartListener(this.partListener);
        this.getSite().getPage().addPartListener(this.partListener2);
    }

    private void initializeImages() {
        CVSUIPlugin plugin = CVSUIPlugin.getPlugin();
        this.versionImage = plugin.getImageDescriptor("obj16/prjversions_rep.gif").createImage();
        this.branchImage = plugin.getImageDescriptor("obj16/tag.gif").createImage();
    }

    protected TableViewer createTable(Composite parent) {
        this.historyTableProvider = new HistoryTableProvider();
        TableViewer viewer = this.historyTableProvider.createTable(parent);
        viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                ICVSRemoteFile file;
                if (HistoryView.this.entries != null) {
                    return HistoryView.this.entries;
                }
                if (!(inputElement instanceof ICVSRemoteFile)) {
                    return null;
                }
                ICVSRemoteFile remoteFile = (ICVSRemoteFile)inputElement;
                if (HistoryView.this.fetchLogEntriesJob == null) {
                    HistoryView.this.fetchLogEntriesJob = new FetchLogEntriesJob();
                }
                if ((file = HistoryView.this.fetchLogEntriesJob.getRemoteFile()) == null || !file.equals((Object)remoteFile)) {
                    if (HistoryView.this.fetchLogEntriesJob.getState() != 0) {
                        HistoryView.this.fetchLogEntriesJob.cancel();
                        try {
                            HistoryView.this.fetchLogEntriesJob.join();
                        }
                        catch (InterruptedException e) {
                            CVSUIPlugin.log((CoreException)((Object)new CVSException(NLS.bind((String)CVSUIMessages.HistoryView_errorFetchingEntries, (Object[])new String[]{remoteFile.getName()}), (Throwable)e)));
                        }
                    }
                    HistoryView.this.fetchLogEntriesJob.setRemoteFile(remoteFile);
                }
                Utils.schedule((Job)HistoryView.this.fetchLogEntriesJob, (IWorkbenchSite)HistoryView.this.getViewSite());
                return new Object[0];
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                HistoryView.this.entries = null;
            }
        });
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection == null || !(selection instanceof IStructuredSelection)) {
                    HistoryView.this.textViewer.setDocument((IDocument)new Document(""));
                    HistoryView.this.tagViewer.setInput(null);
                    return;
                }
                IStructuredSelection ss = (IStructuredSelection)selection;
                if (ss.size() != 1) {
                    HistoryView.this.textViewer.setDocument((IDocument)new Document(""));
                    HistoryView.this.tagViewer.setInput(null);
                    return;
                }
                ILogEntry entry = (ILogEntry)ss.getFirstElement();
                HistoryView.this.textViewer.setDocument((IDocument)new Document(entry.getComment()));
                HistoryView.this.tagViewer.setInput((Object)entry.getTags());
            }
        });
        return viewer;
    }

    private TableViewer createTagTable(Composite parent) {
        Table table = new Table(parent, 68352);
        TableViewer result = new TableViewer(table);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        table.setLayout((Layout)layout);
        result.setContentProvider((IContentProvider)new SimpleContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement == null) {
                    return new Object[0];
                }
                Object[] tags = (CVSTag[])inputElement;
                return tags;
            }
        });
        result.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                if (element == null) {
                    return null;
                }
                CVSTag tag = (CVSTag)element;
                switch (tag.getType()) {
                    case 0: 
                    case 1: {
                        return HistoryView.this.branchImage;
                    }
                    case 2: {
                        return HistoryView.this.versionImage;
                    }
                }
                return null;
            }

            public String getText(Object element) {
                return ((CVSTag)element).getName();
            }
        });
        result.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                int type2;
                if (!(e1 instanceof CVSTag) || !(e2 instanceof CVSTag)) {
                    return super.compare(viewer, e1, e2);
                }
                CVSTag tag1 = (CVSTag)e1;
                CVSTag tag2 = (CVSTag)e2;
                int type1 = tag1.getType();
                if (type1 != (type2 = tag2.getType())) {
                    return type2 - type1;
                }
                return super.compare(viewer, (Object)tag1, (Object)tag2);
            }
        });
        return result;
    }

    protected TextViewer createText(Composite parent) {
        TextViewer result = new TextViewer(parent, 2826);
        result.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                HistoryView.this.copyAction.update();
            }
        });
        return result;
    }

    public void dispose() {
        this.shutdown = true;
        if (this.branchImage != null) {
            this.branchImage.dispose();
            this.branchImage = null;
        }
        if (this.versionImage != null) {
            this.versionImage.dispose();
            this.versionImage = null;
        }
        if (this.fetchLogEntriesJob != null && this.fetchLogEntriesJob.getState() != 0) {
            this.fetchLogEntriesJob.cancel();
            try {
                this.fetchLogEntriesJob.join();
            }
            catch (InterruptedException e) {
                CVSUIPlugin.log((CoreException)((Object)new CVSException(NLS.bind((String)CVSUIMessages.HistoryView_errorFetchingEntries, (Object[])new String[]{""}), (Throwable)e)));
            }
        }
        this.getSite().getPage().removePartListener(this.partListener);
        this.getSite().getPage().removePartListener(this.partListener2);
    }

    protected TableViewer getViewer() {
        return this.tableViewer;
    }

    void initDragAndDrop() {
        int ops = 7;
        Transfer[] transfers = new Transfer[]{ResourceTransfer.getInstance(), CVSResourceTransfer.getInstance()};
        this.tableViewer.addDropSupport(ops, transfers, (DropTargetListener)new HistoryDropAdapter((StructuredViewer)this.tableViewer, this));
    }

    private void fillTableMenu(IMenuManager manager) {
        ISelection sel;
        manager.add((IContributionItem)new Separator("group.file"));
        if (this.file != null && !(sel = this.tableViewer.getSelection()).isEmpty() && sel instanceof IStructuredSelection && ((IStructuredSelection)sel).size() == 1) {
            manager.add((IAction)this.getContentsAction);
            manager.add((IAction)this.getRevisionAction);
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.tagWithExistingAction);
        }
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IAction)this.refreshAction);
        manager.add((IContributionItem)new Separator("additions-end"));
    }

    private void fillTextMenu(IMenuManager manager) {
        manager.add((IAction)this.copyAction);
        manager.add((IAction)this.selectAllAction);
    }

    public void setFocus() {
        Table control;
        if (this.tableViewer != null && (control = this.tableViewer.getTable()) != null && !control.isDisposed()) {
            control.setFocus();
        }
    }

    public void showHistory(IResource resource, boolean refetch) {
        if (resource instanceof IFile) {
            IFile newfile = (IFile)resource;
            if (!refetch && this.file != null && newfile.equals((Object)this.file)) {
                return;
            }
            this.file = newfile;
            RepositoryProvider teamProvider = RepositoryProvider.getProvider((IProject)this.file.getProject(), (String)CVSProviderPlugin.getTypeId());
            if (teamProvider != null) {
                try {
                    ICVSRemoteFile remoteFile = (ICVSRemoteFile)CVSWorkspaceRoot.getRemoteResourceFor((IResource)this.file);
                    if (remoteFile != null) {
                        this.historyTableProvider.setFile((ICVSFile)remoteFile);
                        this.tableViewer.setInput((Object)remoteFile);
                        this.setContentDescription(remoteFile.getName());
                        this.setTitleToolTip(resource.getFullPath().toString());
                    }
                }
                catch (TeamException e) {
                    CVSUIPlugin.openError(this.getViewSite().getShell(), null, null, e);
                }
            }
        } else {
            this.file = null;
            this.tableViewer.setInput(null);
            this.setContentDescription("");
            this.setTitleToolTip("");
        }
    }

    protected void editorActivated(IEditorPart editor) {
        if (editor == null || !this.isLinkingEnabled() || !this.checkIfPageIsVisible()) {
            return;
        }
        IEditorInput input = editor.getEditorInput();
        if (input instanceof SyncInfoCompareInput) {
            SyncInfoCompareInput syncInput = (SyncInfoCompareInput)input;
            SyncInfo info = syncInput.getSyncInfo();
            if (info instanceof CVSSyncInfo && info.getLocal().getType() == 1) {
                ICVSRemoteFile loaded;
                try {
                    loaded = (ICVSRemoteFile)CVSWorkspaceRoot.getRemoteResourceFor((IResource)info.getLocal());
                }
                catch (CVSException e) {
                    CVSUIPlugin.log((CoreException)((Object)e));
                    loaded = null;
                }
                if (loaded != null) {
                    this.showHistory(loaded, false);
                } else {
                    ICVSRemoteFile remote = (ICVSRemoteFile)info.getRemote();
                    ICVSRemoteFile base = (ICVSRemoteFile)info.getBase();
                    if (remote != null) {
                        this.showHistory(remote, false);
                    } else if (base != null) {
                        this.showHistory(base, false);
                    }
                }
            }
        } else if (input instanceof RemoteFileEditorInput) {
            ICVSRemoteFile remote = ((RemoteFileEditorInput)input).getCVSRemoteFile();
            if (remote != null) {
                this.showHistory(remote, false);
            }
        } else {
            IFile file = ResourceUtil.getFile((IEditorInput)input);
            if (file != null) {
                this.showHistory((IResource)file, false);
            }
        }
    }

    private boolean checkIfPageIsVisible() {
        return this.getViewSite().getPage().isPartVisible((IWorkbenchPart)this);
    }

    public void showHistory(ICVSRemoteFile remoteFile, boolean refetch) {
        try {
            if (remoteFile == null) {
                this.tableViewer.setInput(null);
                this.setContentDescription("");
                this.setTitleToolTip("");
                return;
            }
            ICVSFile existingFile = this.historyTableProvider.getICVSFile();
            if (!refetch && existingFile != null && existingFile.equals(remoteFile)) {
                return;
            }
            this.file = null;
            this.historyTableProvider.setFile((ICVSFile)remoteFile);
            this.tableViewer.setInput((Object)remoteFile);
            this.setContentDescription(remoteFile.getName());
            this.setTitleToolTip(remoteFile.getRepositoryRelativePath());
        }
        catch (TeamException e) {
            CVSUIPlugin.openError(this.getViewSite().getShell(), null, null, e);
        }
    }

    private Action getContextMenuAction(String title, final boolean needsProgressDialog, final IWorkspaceRunnable action) {
        return new Action(title){

            public void run() {
                block8: {
                    try {
                        if (HistoryView.this.file == null) {
                            return;
                        }
                        ISelection selection = HistoryView.this.tableViewer.getSelection();
                        if (!(selection instanceof IStructuredSelection)) {
                            return;
                        }
                        IStructuredSelection ss = (IStructuredSelection)selection;
                        Object o = ss.getFirstElement();
                        HistoryView.this.currentSelection = (ILogEntry)o;
                        if (needsProgressDialog) {
                            PlatformUI.getWorkbench().getProgressService().run(true, true, new IRunnableWithProgress(this, action){
                                final /* synthetic */ 25 this$1;
                                private final /* synthetic */ IWorkspaceRunnable val$action;
                                {
                                    this.this$1 = var1_1;
                                    this.val$action = iWorkspaceRunnable;
                                }

                                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                    try {
                                        this.val$action.run(monitor);
                                    }
                                    catch (CoreException e) {
                                        throw new InvocationTargetException(e);
                                    }
                                }
                            });
                            break block8;
                        }
                        try {
                            action.run(null);
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    catch (InvocationTargetException e) {
                        CVSUIPlugin.openError(HistoryView.this.getViewSite().getShell(), null, null, e, 12);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }

            public boolean isEnabled() {
                ISelection selection = HistoryView.this.tableViewer.getSelection();
                if (!(selection instanceof IStructuredSelection)) {
                    return false;
                }
                IStructuredSelection ss = (IStructuredSelection)selection;
                return ss.size() == 1;
            }
        };
    }

    private boolean confirmOverwrite() {
        if (this.file != null && this.file.exists()) {
            ICVSFile cvsFile = CVSWorkspaceRoot.getCVSFileFor((IFile)this.file);
            try {
                if (cvsFile.isModified(null)) {
                    String title = CVSUIMessages.HistoryView_overwriteTitle;
                    String msg = CVSUIMessages.HistoryView_overwriteMsg;
                    final MessageDialog dialog = new MessageDialog(this.getViewSite().getShell(), title, null, msg, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
                    final int[] result = new int[1];
                    this.getViewSite().getShell().getDisplay().syncExec(new Runnable(){

                        public void run() {
                            result[0] = dialog.open();
                        }
                    });
                    if (result[0] != 0) {
                        return false;
                    }
                }
            }
            catch (CVSException e) {
                CVSUIPlugin.log((CoreException)((Object)e));
            }
        }
        return true;
    }

    private void refresh() {
        this.entries = null;
        BusyIndicator.showWhile((Display)this.tableViewer.getTable().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                if (HistoryView.this.file != null) {
                    try {
                        ICVSRemoteFile remoteFile = (ICVSRemoteFile)CVSWorkspaceRoot.getRemoteResourceFor((IResource)HistoryView.this.file);
                        HistoryView.this.historyTableProvider.setFile((ICVSFile)remoteFile);
                    }
                    catch (CVSException e) {
                        CVSUIPlugin.log((CoreException)((Object)e));
                    }
                }
                HistoryView.this.tableViewer.refresh();
            }
        });
    }

    public void selectRevision(String revision) {
        if (this.entries == null) {
            return;
        }
        ILogEntry entry = null;
        int i = 0;
        while (i < this.entries.length) {
            if (this.entries[i].getRevision().equals(revision)) {
                entry = this.entries[i];
                break;
            }
            ++i;
        }
        if (entry != null) {
            StructuredSelection selection = new StructuredSelection(entry);
            this.tableViewer.setSelection((ISelection)selection, true);
        }
    }

    public void setLinkingEnabled(boolean enabled) {
        this.linkingEnabled = enabled;
        this.settings.setValue("pref_history_view_linking", enabled);
        if (enabled) {
            this.editorActivated(this.getSite().getPage().getActiveEditor());
        }
    }

    private boolean isLinkingEnabled() {
        return this.linkingEnabled;
    }

    public static String flattenText(String string) {
        StringBuffer buffer = new StringBuffer(string.length() + 20);
        boolean skipAdjacentLineSeparator = true;
        int i = 0;
        while (i < string.length()) {
            char c = string.charAt(i);
            if (c == '\r' || c == '\n') {
                if (!skipAdjacentLineSeparator) {
                    buffer.append(CVSUIMessages.separator);
                }
                skipAdjacentLineSeparator = true;
            } else {
                buffer.append(c);
                skipAdjacentLineSeparator = false;
            }
            ++i;
        }
        return buffer.toString();
    }

    private class FetchLogEntriesJob
    extends Job {
        public ICVSRemoteFile remoteFile;

        public FetchLogEntriesJob() {
            super(CVSUIMessages.HistoryView_fetchHistoryJob);
        }

        public void setRemoteFile(ICVSRemoteFile file) {
            this.remoteFile = file;
        }

        public IStatus run(IProgressMonitor monitor) {
            try {
                if (this.remoteFile != null && !HistoryView.this.shutdown) {
                    HistoryView.this.entries = this.remoteFile.getLogEntries(monitor);
                    String revisionId = this.remoteFile.getRevision();
                    HistoryView.this.getSite().getShell().getDisplay().asyncExec(new Runnable(this, revisionId){
                        final /* synthetic */ FetchLogEntriesJob this$1;
                        private final /* synthetic */ String val$revisionId;
                        {
                            this.this$1 = fetchLogEntriesJob;
                            this.val$revisionId = string;
                        }

                        public void run() {
                            if (HistoryView.access$2(FetchLogEntriesJob.access$0(this.this$1)) != null && HistoryView.access$3(FetchLogEntriesJob.access$0(this.this$1)) != null && !HistoryView.access$3(FetchLogEntriesJob.access$0(this.this$1)).getTable().isDisposed()) {
                                HistoryView.access$3(FetchLogEntriesJob.access$0(this.this$1)).refresh();
                                FetchLogEntriesJob.access$0(this.this$1).selectRevision(this.val$revisionId);
                            }
                        }
                    });
                }
                return Status.OK_STATUS;
            }
            catch (TeamException e) {
                return e.getStatus();
            }
        }

        public ICVSRemoteFile getRemoteFile() {
            return this.remoteFile;
        }

        static /* synthetic */ HistoryView access$0(FetchLogEntriesJob fetchLogEntriesJob) {
            return fetchLogEntriesJob.HistoryView.this;
        }
    }
}

