/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.mappings;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.mapping.IResourceDiff;
import org.eclipse.team.core.mapping.ISynchronizationScopeManager;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoFilter;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSSyncInfo;
import org.eclipse.team.internal.ccvs.core.CVSWorkspaceSubscriber;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.client.PruneFolderVisitor;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.mappings.CVSSubscriberMergeContext;
import org.eclipse.team.internal.ccvs.ui.operations.CacheBaseContentsOperation;
import org.eclipse.team.internal.ccvs.ui.operations.CacheRemoteContentsOperation;
import org.eclipse.team.internal.core.mapping.CompoundResourceTraversal;

public class WorkspaceSubscriberContext
extends CVSSubscriberMergeContext {
    private final int type;

    public static WorkspaceSubscriberContext createContext(ISynchronizationScopeManager manager, int type) {
        CVSWorkspaceSubscriber subscriber = CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber();
        WorkspaceSubscriberContext mergeContext = new WorkspaceSubscriberContext((Subscriber)subscriber, manager, type);
        mergeContext.initialize();
        return mergeContext;
    }

    protected WorkspaceSubscriberContext(Subscriber subscriber, ISynchronizationScopeManager manager, int type) {
        super(subscriber, manager);
        this.type = type;
    }

    public void markAsMerged(final IDiff node, final boolean inSyncHint, IProgressMonitor monitor) throws CoreException {
        this.run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IResource resource = WorkspaceSubscriberContext.this.getDiffTree().getResource(node);
                if (resource.getType() != 1) {
                    return;
                }
                SyncInfo info = WorkspaceSubscriberContext.this.getSyncInfo(resource);
                WorkspaceSubscriberContext.this.ensureRemotesMatch(resource, node, info);
                if (info instanceof CVSSyncInfo) {
                    CVSSyncInfo cvsInfo = (CVSSyncInfo)info;
                    cvsInfo.makeOutgoing(monitor);
                    if (inSyncHint) {
                        SyncInfoFilter.ContentComparisonSyncInfoFilter comparator = new SyncInfoFilter.ContentComparisonSyncInfoFilter(false);
                        if (resource.getType() == 1 && info.getRemote() != null && comparator.compareContents((IFile)resource, info.getRemote(), Policy.subMonitorFor(monitor, 100))) {
                            ICVSFile cvsFile = CVSWorkspaceRoot.getCVSFileFor((IFile)((IFile)resource));
                            cvsFile.checkedIn(null, false);
                        }
                    }
                }
            }
        }, this.getMergeRule(node), 0, monitor);
    }

    protected void ensureRemotesMatch(IResource resource, IDiff node, SyncInfo info) throws CVSException {
        String ci2;
        String ci1;
        IResourceVariant variant = info.getRemote();
        IFileRevision remote = this.getRemote(node);
        if (variant != null && remote != null && remote instanceof IFileRevision && !(ci1 = variant.getContentIdentifier()).equals(ci2 = remote.getContentIdentifier())) {
            throw new CVSException(NLS.bind((String)CVSUIMessages.WorkspaceSubscriberContext_0, (Object)resource.getFullPath().toString()));
        }
    }

    private IFileRevision getRemote(IDiff node) {
        if (node == null) {
            return null;
        }
        if (node instanceof IThreeWayDiff) {
            IThreeWayDiff twd = (IThreeWayDiff)node;
            return this.getRemote((IDiff)twd.getRemoteChange());
        }
        if (node instanceof IResourceDiff) {
            IResourceDiff rd = (IResourceDiff)node;
            return rd.getAfterState();
        }
        return null;
    }

    public IStatus merge(IDiff delta, boolean force, IProgressMonitor monitor) throws CoreException {
        SyncInfo info = this.getSyncInfo(this.getDiffTree().getResource(delta));
        if (this.getMergeType() == 2) {
            force = true;
        }
        if (info == null || info.getKind() == 0 || SyncInfo.getDirection((int)info.getKind()) == 4 && !force) {
            return Status.OK_STATUS;
        }
        IStatus status = super.merge(delta, force, monitor);
        if (status.isOK() && delta.getKind() == 2) {
            IResource resource = this.getDiffTree().getResource(delta);
            if (resource.getType() == 1 && !resource.exists()) {
                ICVSResource localResource = CVSWorkspaceRoot.getCVSResourceFor((IResource)resource);
                localResource.unmanage(monitor);
            }
            this.pruneEmptyParents(new IDiff[]{delta});
        }
        return status;
    }

    private void pruneEmptyParents(IDiff[] deltas) throws CVSException {
        if (!CVSProviderPlugin.getPlugin().getPruneEmptyDirectories()) {
            return;
        }
        ICVSResource[] cvsResources = new ICVSResource[deltas.length];
        int i = 0;
        while (i < cvsResources.length) {
            cvsResources[i] = CVSWorkspaceRoot.getCVSResourceFor((IResource)this.getDiffTree().getResource(deltas[i]));
            ++i;
        }
        new PruneFolderVisitor().visit(CVSWorkspaceRoot.getCVSFolderFor((IContainer)ResourcesPlugin.getWorkspace().getRoot()), cvsResources);
    }

    public int getMergeType() {
        return this.type;
    }

    public void refresh(final ResourceTraversal[] traversals, int flags, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(null, 50);
        super.refresh(traversals, flags, Policy.subMonitorFor(monitor, 50));
        if (CVSProviderPlugin.getPlugin().getPruneEmptyDirectories()) {
            CompoundResourceTraversal ct = new CompoundResourceTraversal();
            ct.addTraversals(traversals);
            IResource[] roots = ct.getRoots();
            ICVSResource[] cvsResources = new ICVSResource[roots.length];
            int i = 0;
            while (i < cvsResources.length) {
                cvsResources[i] = CVSWorkspaceRoot.getCVSResourceFor((IResource)roots[i]);
                ++i;
            }
            new PruneFolderVisitor().visit(CVSWorkspaceRoot.getCVSFolderFor((IContainer)ResourcesPlugin.getWorkspace().getRoot()), cvsResources);
        }
        this.runInBackground(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                WorkspaceSubscriberContext.this.cacheContents(traversals, monitor);
            }
        });
        monitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void cacheContents(final ResourceTraversal[] traversals, IProgressMonitor monitor) throws CVSException {
        ResourceMapping[] mappings = new ResourceMapping[]{new ResourceMapping(){

            public Object getModelObject() {
                return WorkspaceSubscriberContext.this;
            }

            public IProject[] getProjects() {
                return ResourcesPlugin.getWorkspace().getRoot().getProjects();
            }

            public ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
                return traversals;
            }

            public boolean contains(ResourceMapping mapping) {
                return false;
            }

            public String getModelProviderId() {
                return "org.eclipse.core.resources.modelProvider";
            }
        }};
        try {
            try {
                monitor.beginTask(null, 50);
                new CacheBaseContentsOperation(null, mappings, this.getDiffTree(), true).run(Policy.subMonitorFor(monitor, 25));
                new CacheRemoteContentsOperation(null, mappings, this.getDiffTree()).run(Policy.subMonitorFor(monitor, 25));
            }
            catch (InvocationTargetException e) {
                throw CVSException.wrapException((Exception)e);
            }
            catch (InterruptedException interruptedException) {
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        monitor.done();
    }
}

