/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.resources.CVSEntryLineTag;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.operations.CheckoutIntoOperation;
import org.eclipse.team.internal.ccvs.ui.operations.CheckoutMultipleProjectsOperation;
import org.eclipse.team.internal.ccvs.ui.operations.CheckoutSingleProjectOperation;
import org.eclipse.team.internal.ccvs.ui.operations.ProjectMetaFileOperation;
import org.eclipse.team.internal.ccvs.ui.tags.TagSelectionWizardPage;
import org.eclipse.team.internal.ccvs.ui.tags.TagSource;
import org.eclipse.team.internal.ccvs.ui.wizards.CheckoutAsLocationSelectionPage;
import org.eclipse.team.internal.ccvs.ui.wizards.CheckoutAsMainPage;
import org.eclipse.team.internal.ccvs.ui.wizards.CheckoutAsProjectSelectionPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.NewProjectAction;

public class CheckoutAsWizard
extends Wizard {
    private ICVSRemoteFolder[] remoteFolders;
    private boolean allowProjectConfiguration;
    private CheckoutAsMainPage mainPage;
    private CheckoutAsProjectSelectionPage projectSelectionPage;
    private CheckoutAsLocationSelectionPage locationSelectionPage;
    private TagSelectionWizardPage tagSelectionPage;
    private IWorkbenchPart part;

    public static IDialogSettings getCheckoutAsDialogSettings() {
        IDialogSettings workbenchSettings = CVSUIPlugin.getPlugin().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection("CheckoutAsWizard");
        if (section == null) {
            section = workbenchSettings.addNewSection("CheckoutAsWizard");
        }
        return section;
    }

    public CheckoutAsWizard(IWorkbenchPart part, ICVSRemoteFolder[] remoteFolders, boolean allowProjectConfiguration) {
        this.part = part;
        this.remoteFolders = remoteFolders;
        this.setDialogSettings(CheckoutAsWizard.getCheckoutAsDialogSettings());
        this.setWindowTitle(CVSUIMessages.CheckoutAsWizard_title);
        this.allowProjectConfiguration = allowProjectConfiguration;
    }

    public void addPages() {
        this.setNeedsProgressMonitor(true);
        ImageDescriptor substImage = CVSUIPlugin.getPlugin().getImageDescriptor("wizban/newconnect_wizban.png");
        this.mainPage = new CheckoutAsMainPage(substImage, this.remoteFolders, this.allowProjectConfiguration);
        this.addPage((IWizardPage)this.mainPage);
        this.projectSelectionPage = new CheckoutAsProjectSelectionPage(substImage, this.remoteFolders);
        this.addPage((IWizardPage)this.projectSelectionPage);
        this.locationSelectionPage = new CheckoutAsLocationSelectionPage(substImage, this.remoteFolders);
        this.addPage((IWizardPage)this.locationSelectionPage);
        this.tagSelectionPage = new TagSelectionWizardPage("tagPage", CVSUIMessages.CheckoutAsWizard_3, substImage, CVSUIMessages.CheckoutAsWizard_4, TagSource.create((ICVSFolder[])this.remoteFolders), 29);
        if (this.remoteFolders.length > 0) {
            try {
                CVSEntryLineTag selectedTag = this.remoteFolders[0].getFolderSyncInfo().getTag();
                this.tagSelectionPage.setSelection((CVSTag)selectedTag);
            }
            catch (CVSException e) {
                CVSUIPlugin.log((CoreException)((Object)e));
            }
        }
        this.tagSelectionPage.setHelpContxtId("org.eclipse.team.cvs.ui.checkout_tag_selection_page_context");
        this.addPage((IWizardPage)this.tagSelectionPage);
    }

    public boolean performFinish() {
        try {
            if (this.mainPage.isPerformConfigure()) {
                return this.performConfigureAndCheckout();
            }
            if (this.mainPage.isPerformCheckoutAs()) {
                if (this.isSingleFolder()) {
                    return this.performSingleCheckoutAs();
                }
                return this.performMultipleCheckoutAs();
            }
            if (this.mainPage.isPerformCheckoutInto()) {
                return this.performCheckoutInto();
            }
        }
        catch (InvocationTargetException e) {
            this.handle(e);
        }
        catch (InterruptedException interruptedException) {}
        return false;
    }

    private boolean isSingleFolder() {
        return this.remoteFolders.length == 1;
    }

    public boolean canFinish() {
        return this.mainPage.isPageComplete() && (this.mainPage.isPerformConfigure() || this.mainPage.isPerformCheckoutInto() && this.projectSelectionPage.isPageComplete() || this.mainPage.isPerformCheckoutAs() && this.locationSelectionPage.isPageComplete());
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.mainPage) {
            if (this.mainPage.isPerformConfigure()) {
                return this.tagSelectionPage;
            }
            if (this.mainPage.isPerformCheckoutInto()) {
                return this.projectSelectionPage;
            }
            if (this.mainPage.isPerformCheckoutAs()) {
                if (this.isSingleFolder()) {
                    this.locationSelectionPage.setProjectName(this.mainPage.getProjectName());
                } else {
                    this.locationSelectionPage.setProject(null);
                }
                return this.locationSelectionPage;
            }
        }
        if (page != this.tagSelectionPage) {
            return this.tagSelectionPage;
        }
        return null;
    }

    private void handle(Throwable e) {
        CVSUIPlugin.openError(this.getShell(), CVSUIMessages.CheckoutAsWizard_error, null, e);
    }

    private boolean performConfigureAndCheckout() throws InvocationTargetException, InterruptedException {
        IProject newProject = this.getNewProject();
        if (newProject == null) {
            return false;
        }
        ICVSRemoteFolder folder = this.getRemoteFolder();
        new CheckoutSingleProjectOperation(this.part, folder, newProject, null, true).run();
        return true;
    }

    private ICVSRemoteFolder getRemoteFolder() {
        ICVSRemoteFolder folder = this.remoteFolders[0];
        CVSTag selectedTag = this.getSelectedTag();
        if (selectedTag != null) {
            folder = (ICVSRemoteFolder)folder.forTag(selectedTag);
        }
        return folder;
    }

    private ICVSRemoteFolder[] getRemoteFolders() {
        ICVSRemoteFolder[] folders = new ICVSRemoteFolder[this.remoteFolders.length];
        int i = 0;
        while (i < this.remoteFolders.length) {
            ICVSRemoteFolder remote = this.remoteFolders[i];
            folders[i] = (ICVSRemoteFolder)remote.forTag(this.getSelectedTag());
            ++i;
        }
        return folders;
    }

    private ICVSRemoteFolder[] getRemoteFoldersWithProjectDescriptions() throws InvocationTargetException, InterruptedException {
        ICVSRemoteFolder[] folders = this.getRemoteFolders();
        if (CVSUIPlugin.getPlugin().isUseProjectNameOnCheckout()) {
            folders = ProjectMetaFileOperation.updateFoldersWithProjectName(this.part, folders);
        }
        return folders;
    }

    private CVSTag getSelectedTag() {
        return this.tagSelectionPage.getSelectedTag();
    }

    private boolean performSingleCheckoutAs() throws InvocationTargetException, InterruptedException {
        IProject newProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.mainPage.getProjectName());
        String targetLocation = this.locationSelectionPage.getTargetLocation();
        ICVSRemoteFolder folder = this.getRemoteFolder();
        new CheckoutSingleProjectOperation(this.part, folder, newProject, targetLocation, false).run();
        return true;
    }

    private boolean performMultipleCheckoutAs() throws InvocationTargetException, InterruptedException {
        String targetLocation = this.locationSelectionPage.getTargetLocation();
        new CheckoutMultipleProjectsOperation(this.part, this.getRemoteFoldersWithProjectDescriptions(), targetLocation).run();
        return true;
    }

    private boolean performCheckoutInto() throws InvocationTargetException, InterruptedException {
        CheckoutIntoOperation operation;
        boolean recursive = this.projectSelectionPage.isRecurse();
        if (this.isSingleFolder()) {
            ICVSRemoteFolder folder = this.getRemoteFolder();
            operation = new CheckoutIntoOperation(this.part, folder, this.projectSelectionPage.getLocalFolder(), recursive);
        } else {
            operation = new CheckoutIntoOperation(this.part, this.getRemoteFolders(), this.projectSelectionPage.getParentFolder(), recursive);
        }
        operation.run();
        return true;
    }

    private IProject getNewProject() {
        NewProjectListener listener = new NewProjectListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener, 1);
        new NewProjectAction(PlatformUI.getWorkbench().getActiveWorkbenchWindow()).run();
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener);
        IProject project = listener.getNewProject();
        return project;
    }

    class NewProjectListener
    implements IResourceChangeListener {
        private IProject newProject = null;

        NewProjectListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta root = event.getDelta();
            IResourceDelta[] projectDeltas = root.getAffectedChildren();
            int i = 0;
            while (i < projectDeltas.length) {
                IResourceDelta delta = projectDeltas[i];
                IResource resource = delta.getResource();
                if (delta.getKind() == 1) {
                    this.newProject = (IProject)resource;
                }
                ++i;
            }
        }

        public IProject getNewProject() {
            return this.newProject;
        }
    }
}

